/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.settings;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3i;
import org.joml.Vector4f;

public record SkyColorSettings(Optional<Vector4f> color, Optional<Vector3i> sunsetColor, Optional<Integer> sunriseAlphaModifier) {
    public static Codec<Vector4f> VEC4F = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)4).map(listx -> new Vector4f(((Float)listx.getFirst()).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.get(2)).floatValue(), ((Float)listx.getLast()).floatValue())), vector4f -> List.of(Float.valueOf(vector4f.x), Float.valueOf(vector4f.y), Float.valueOf(vector4f.z), Float.valueOf(vector4f.w)));
    public static Codec<Vector3i> VEC3I = Codec.INT.listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)3).map(listx -> new Vector3i(((Integer)listx.getFirst()).intValue(), ((Integer)listx.get(1)).intValue(), ((Integer)listx.getLast()).intValue())), vec3 -> List.of(Integer.valueOf(vec3.x), Integer.valueOf(vec3.y), Integer.valueOf(vec3.z)));
    public static final Codec<SkyColorSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VEC4F.optionalFieldOf("sky_color").forGetter(SkyColorSettings::color), (App)VEC3I.optionalFieldOf("sunset_color").forGetter(SkyColorSettings::sunsetColor), (App)Codec.INT.optionalFieldOf("sunset_alpha_modifier").forGetter(SkyColorSettings::sunriseAlphaModifier)).apply((Applicative)instance, SkyColorSettings::new));

    public static SkyColorSettings createDefaultSettings() {
        return new SkyColorSettings(Optional.empty(), Optional.empty(), Optional.of(1));
    }

    public void setSkyColor(ClientLevel level, Camera camera, float partialTick) {
        if (this.color().isPresent()) {
            Vector4f skyColor = this.color().get();
            RenderSystem.setShaderColor((float)skyColor.x, (float)skyColor.y, (float)skyColor.z, (float)skyColor.w);
        } else {
            Vec3 defaultSkyColor = level.getSkyColor(camera.getPosition(), partialTick);
            RenderSystem.setShaderColor((float)((float)defaultSkyColor.x), (float)((float)defaultSkyColor.y), (float)((float)defaultSkyColor.z), (float)1.0f);
        }
    }
}

