/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.settings;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public record SkyObject(ResourceLocation texture, boolean blend, float size, Vector3f rotation, Vector3f objectRotation, int height, String rotationType) {
    public static Codec<Vector3f> VEC3F = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)3).map(listx -> new Vector3f(((Float)listx.getFirst()).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.getLast()).floatValue())), vector3f -> List.of(Float.valueOf(vector3f.x), Float.valueOf(vector3f.y), Float.valueOf(vector3f.z)));
    public static final Codec<SkyObject> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SkyObject::texture), (App)Codec.BOOL.fieldOf("blend").forGetter(SkyObject::blend), (App)Codec.FLOAT.fieldOf("size").forGetter(SkyObject::size), (App)VEC3F.fieldOf("rotation").forGetter(SkyObject::rotation), (App)VEC3F.fieldOf("object_rotation").forGetter(SkyObject::objectRotation), (App)Codec.INT.fieldOf("height").forGetter(SkyObject::height), (App)Codec.STRING.fieldOf("rotation_type").forGetter(SkyObject::rotationType)).apply((Applicative)instance, SkyObject::new));

    public void setObjectPosition(PoseStack poseStack, float dayAngle) {
        poseStack.mulPose(Axis.YP.rotationDegrees(this.rotation().y));
        if (Objects.equals(this.rotationType(), "DAY")) {
            poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle));
        } else if (Objects.equals(this.rotationType(), "NIGHT")) {
            poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle + 180.0f));
        } else {
            poseStack.mulPose(Axis.XP.rotationDegrees(this.rotation().x));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees(this.rotation().z));
    }

    public void setObjectRotation(PoseStack poseStack) {
        poseStack.translate(0.0f, 100.0f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(this.objectRotation.x));
        poseStack.mulPose(Axis.YP.rotationDegrees(this.objectRotation.y));
        poseStack.mulPose(Axis.ZP.rotationDegrees(this.objectRotation.z));
        poseStack.translate(0.0f, -100.0f, 0.0f);
    }

    public void drawSkyObject(Tesselator tesselator, PoseStack poseStack, float dayAngle) {
        if (this.blend()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        poseStack.pushPose();
        this.setObjectPosition(poseStack, dayAngle);
        this.setObjectRotation(poseStack);
        Matrix4f matrix4f = poseStack.last().pose();
        float ratio = 1.0f;
        if ((float)this.height() > Minecraft.getInstance().gameRenderer.getRenderDistance()) {
            ratio = Minecraft.getInstance().gameRenderer.getRenderDistance() / (float)this.height();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture());
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, -this.size() * ratio, (float)this.height() * ratio - 1.0f, -this.size() * ratio).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, this.size() * ratio, (float)this.height() * ratio - 1.0f, -this.size() * ratio).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, this.size() * ratio, (float)this.height() * ratio - 1.0f, this.size() * ratio).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, -this.size() * ratio, (float)this.height() * ratio - 1.0f, this.size() * ratio).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        poseStack.popPose();
        if (this.blend()) {
            RenderSystem.disableBlend();
        }
    }
}

