/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.tathan.sky_aesthetics.client.skies.settings.CloudSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.settings.FogSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyColorSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.settings.StarSettings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class SkyPropertiesProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private String modid = "sky_aesthetics";
    private final Codec<SkyProperties> codec;
    private final ResourceKey<Registry<SkyProperties>> registry = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)"sky_aesthetics"));

    public SkyPropertiesProvider(PackOutput packOutput) {
        this(packOutput, PackOutput.Target.RESOURCE_PACK, "sky_aesthetics");
    }

    public SkyPropertiesProvider(PackOutput packOutput, String modid) {
        this(packOutput, PackOutput.Target.RESOURCE_PACK, modid);
    }

    public SkyPropertiesProvider(PackOutput packOutput, PackOutput.Target target, String modid) {
        this.modid = modid;
        this.pathProvider = packOutput.createPathProvider(target, this.registry.location().getPath());
        this.codec = SkyProperties.CODEC;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        ArrayList futures = new ArrayList();
        this.build((key, value) -> futures.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)((JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow()), (Path)this.pathProvider.json(key))));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Sky Provider";
    }

    protected void build(BiConsumer<ResourceLocation, SkyProperties> consumer) {
        consumer.accept(this.skyLocation("test"), new SkyProperties((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"overworld")), this.skyLocation("test"), Optional.of(CloudSettings.createDefaultSettings()), Optional.of(FogSettings.createDefaultSettings()), true, Optional.of(CustomVanillaObject.Sun.createDefaultSun()), Optional.of(CustomVanillaObject.Moon.createDefaultMoon()), Optional.of(StarSettings.createDefaultStars()), Optional.of(SkyColorSettings.createDefaultSettings()), List.of(), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public ResourceLocation skyLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"sky_aesthetics", (String)path);
    }
}

