/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.tathan.sky_aesthetics.client.skies.utils.SkyHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.level.material.FogType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class}, priority=900)
public class FogRendererMixin {
    @Mutable
    @Shadow
    private static float fogRed;
    @Mutable
    @Shadow
    private static float fogGreen;
    @Mutable
    @Shadow
    private static float fogBlue;
    @Unique
    private static ClientLevel level;

    @Inject(method={"setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;z()D", shift=At.Shift.AFTER)})
    private static void setupCustomColor(Camera activeRenderInfo, float partialTicks, ClientLevel level, int renderDistanceChunks, float bossColorModifier, CallbackInfo ci) {
        FogRendererMixin.level = level;
        SkyHelper.canRenderSky(level, planetSky -> planetSky.getRenderer().fogSettings.customFogColor().ifPresent(color -> {
            fogRed = (float)color.x() / 255.0f;
            fogGreen = (float)color.y() / 255.0f;
            fogBlue = (float)color.z() / 255.0f;
        }));
    }

    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, at={@At(value="TAIL")})
    private static void modifyFogThickness(Camera camera, FogRenderer.FogMode fogMode, float farPlaneDistance, boolean shouldCreateFog, float partialTick, CallbackInfo ci) {
        FogType fogType = camera.getFluidInCamera();
        if (level != null && fogType == FogType.NONE) {
            SkyHelper.canRenderSky(level, planetSky -> planetSky.getRenderer().fogSettings.fogDensity().ifPresent(density -> {
                RenderSystem.setShaderFogStart((float)density.x);
                RenderSystem.setShaderFogEnd((float)density.y);
            }));
        }
    }
}

