/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.skies.DimensionSky;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyProperties;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;

public class SkiesRegistry
extends class_4309 {
    public static final Map<class_2960, DimensionSky> SKY_PROPERTIES = new HashMap<class_2960, DimensionSky>();
    public static DimensionSky SKY_DEV = null;
    public static Boolean USE_SKY_DEV = false;

    public SkiesRegistry() {
        super(SkyAesthetics.GSON, "sky_aesthetics");
    }

    protected void apply(Map<class_2960, JsonElement> object, @Nullable class_3300 resourceManager, @Nullable class_3695 profiler) {
        SKY_PROPERTIES.clear();
        object.forEach((key, value) -> {
            JsonObject json = class_3518.method_15295((JsonElement)value, (String)"sky properties");
            DataResult decoder = SkyProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            if (decoder.error().isPresent()) {
                SkyAesthetics.LOG.error("Error parsing sky : {}", (Object)((DataResult.Error)decoder.error().get()).message());
                return;
            }
            SkyProperties skyProperties = (SkyProperties)decoder.getOrThrow();
            DimensionSky dimensionSky = new DimensionSky(skyProperties);
            SkiesRegistry.registerSky(skyProperties.id(), dimensionSky);
            SkyAesthetics.LOG.info("{} | registered", (Object)skyProperties.id());
        });
    }

    public static void registerSky(class_2960 id, DimensionSky sky) {
        if (SKY_PROPERTIES.containsKey(id)) {
            SkyAesthetics.LOG.warn("Sky with id {} already exists, overwriting it", (Object)id);
        }
        SKY_PROPERTIES.put(id, sky);
    }

    public static void setSkyDev(DimensionSky sky) {
        if (SKY_DEV != null) {
            SkyAesthetics.LOG.warn("Sky dev already set, overwriting it");
        }
        SKY_DEV = sky;
    }
}

