/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies;

import fr.tathan.sky_aesthetics.client.DimensionRenderer;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyProperties;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

public class DimensionSky
extends DimensionSpecialEffects {
    private final DimensionRenderer renderer;
    private final ResourceKey<Level> dimension;
    private final ResourceLocation skyId;
    private final SkyProperties skyProperties;

    public DimensionSky(SkyProperties skyProperties) {
        this(skyProperties.world(), skyProperties.id(), skyProperties.toDimensionRenderer(), skyProperties);
    }

    public DimensionSky(ResourceKey<Level> dimension, ResourceLocation skyId, DimensionRenderer renderer, SkyProperties skyProperties) {
        super(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        this.renderer = renderer;
        this.dimension = dimension;
        this.skyId = skyId;
        this.skyProperties = skyProperties;
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 fogColor, float brightness) {
        return fogColor.multiply((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f));
    }

    public float @NotNull [] getSunriseColor(float timeOfDay, float partialTicks) {
        if (this.renderer.skyColor.sunsetColor().isPresent()) {
            Vector3i sunriseColor = this.renderer.skyColor.sunsetColor().get();
            float dayTime = Mth.cos((float)(timeOfDay * ((float)Math.PI * 2)));
            if (dayTime >= -0.4f && dayTime <= 0.4f) {
                float i = dayTime / 0.4f * 0.5f + 0.5f;
                float alpha = 1.0f - (1.0f - Mth.sin((float)(i * (float)Math.PI))) * 0.99f;
                alpha *= alpha;
                if (this.renderer.skyColor.sunriseAlphaModifier().isPresent()) {
                    alpha *= (float)this.renderer.skyColor.sunriseAlphaModifier().get().intValue();
                }
                if (this.sunriseCol == null) {
                    this.sunriseCol = new float[4];
                }
                this.sunriseCol[0] = (float)sunriseColor.x / 255.0f;
                this.sunriseCol[1] = (float)sunriseColor.y / 255.0f;
                this.sunriseCol[2] = (float)sunriseColor.z / 255.0f;
                this.sunriseCol[3] = alpha;
                return this.sunriseCol;
            }
        }
        if (this.sunriseCol == null) {
            this.sunriseCol = new float[4];
        }
        this.sunriseCol = super.getSunriseColor(timeOfDay, partialTicks);
        return this.sunriseCol;
    }

    public float getCloudHeight() {
        return this.getRenderer().cloudSettings.cloudHeight().intValue();
    }

    public boolean isFoggyAt(int x, int y) {
        return false;
    }

    public boolean forceBrightLightmap() {
        if (this.getSkyProperties().lightSettings().isPresent()) {
            return this.getSkyProperties().lightSettings().get().forceBrightLightmap();
        }
        return super.forceBrightLightmap();
    }

    public boolean constantAmbientLight() {
        if (this.getSkyProperties().lightSettings().isPresent()) {
            return this.getSkyProperties().lightSettings().get().constantAmbientLight();
        }
        return super.constantAmbientLight();
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public ResourceLocation getSkyId() {
        return this.skyId;
    }

    public SkyProperties getSkyProperties() {
        return this.skyProperties;
    }

    public DimensionRenderer getRenderer() {
        return this.renderer;
    }
}

