/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.settings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.tathan.sky_aesthetics.client.skies.utils.SkyHelper;
import fr.tathan.sky_aesthetics.helper.PlatformHelper;
import fr.tathan.sky_aesthetics.helper.SkyCompat;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;

public class CustomVanillaObject {

    public record Moon(boolean moonPhase, ResourceLocation moonTexture, Float moonHeight, Float moonSize) {
        public static final Codec<Moon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("moon_phase").forGetter(Moon::moonPhase), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Moon::moonTexture), (App)Codec.FLOAT.fieldOf("height").forGetter(Moon::moonHeight), (App)Codec.FLOAT.fieldOf("size").forGetter(Moon::moonSize)).apply((Applicative)instance, Moon::new));

        public static Moon createDefaultMoon() {
            return Moon.createMoon(true, ResourceLocation.parse((String)"textures/environment/moon_phases.png"), 75.0f, 75.0f);
        }

        public static Moon createMoon(boolean moonPhase, ResourceLocation texture, float height, float size) {
            return new Moon(moonPhase, texture, Float.valueOf(height), Float.valueOf(size));
        }

        public void render(ClientLevel level, Tesselator tesselator, PoseStack poseStack, float nightAngle) {
            if (PlatformHelper.isModLoaded("lunar")) {
                SkyCompat.drawLunarSky(level, tesselator, poseStack, this.moonSize().floatValue(), nightAngle);
            } else if (this.moonPhase()) {
                SkyHelper.drawMoonWithPhase(tesselator, poseStack, this.moonSize().floatValue(), this.moonTexture(), nightAngle);
            } else {
                SkyHelper.drawCelestialBody(this.moonTexture(), tesselator, poseStack, this.moonHeight().floatValue(), this.moonSize().floatValue(), nightAngle, 0.0f, 1.0f, 0.0f, 1.0f, false);
            }
        }
    }

    public record Sun(ResourceLocation sunTexture, Float sunHeight, Float sunSize) {
        public static final Codec<Sun> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Sun::sunTexture), (App)Codec.FLOAT.fieldOf("height").forGetter(Sun::sunHeight), (App)Codec.FLOAT.fieldOf("size").forGetter(Sun::sunSize)).apply((Applicative)instance, Sun::new));

        public static Sun createDefaultSun() {
            return Sun.createSun(ResourceLocation.parse((String)"textures/environment/sun.png"), 450.0f, 135.0f);
        }

        public static Sun createSun(ResourceLocation texture, float height, float size) {
            return new Sun(texture, Float.valueOf(height), Float.valueOf(size));
        }

        public void render(Tesselator tesselator, PoseStack poseStack, float dayAngle) {
            SkyHelper.drawCelestialBody(this.sunTexture(), tesselator, poseStack, this.sunHeight.floatValue(), this.sunSize.floatValue(), dayAngle, true);
        }
    }
}

