/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.settings;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyColorSettings;
import fr.tathan.sky_aesthetics.client.skies.utils.ShootingStar;
import fr.tathan.sky_aesthetics.client.skies.utils.StarHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3i;

public record StarSettings(boolean vanilla, boolean movingStars, int count, boolean allDaysVisible, float scale, Vector3i color, Optional<ShootingStars> shootingStars, Optional<ResourceLocation> starsTexture) {
    public static final Codec<StarSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("vanilla").forGetter(StarSettings::vanilla), (App)Codec.BOOL.fieldOf("moving_stars").forGetter(StarSettings::movingStars), (App)Codec.INT.fieldOf("count").forGetter(StarSettings::count), (App)Codec.BOOL.fieldOf("all_days_visible").forGetter(StarSettings::allDaysVisible), (App)Codec.FLOAT.fieldOf("scale").forGetter(StarSettings::scale), (App)SkyColorSettings.VEC3I.fieldOf("color").forGetter(StarSettings::color), (App)ShootingStars.CODEC.optionalFieldOf("shooting_stars").forGetter(StarSettings::shootingStars), (App)ResourceLocation.CODEC.optionalFieldOf("star_texture").forGetter(StarSettings::starsTexture)).apply((Applicative)instance, StarSettings::new));

    public static StarSettings createDefaultStars() {
        return new StarSettings(true, false, 30000, false, 0.05f, new Vector3i(255, 255, 255), Optional.empty(), Optional.empty());
    }

    public VertexBuffer getStarsBuffer() {
        if (this.count() > 100) {
            return StarHelper.createStars(this.scale(), this.count(), this.color().x(), this.color().y(), this.color().z(), Optional.empty(), Optional.empty());
        }
        if (this.vanilla()) {
            return StarHelper.createVanillaStars();
        }
        return null;
    }

    public void renderStars(ClientLevel level, float partialTick, PoseStack poseStack, Matrix4f projectionMatrix, float nightAngle, VertexBuffer starBuffer) {
        float starsAngle;
        float starLight = level.getStarBrightness(partialTick) * (1.0f - level.getRainLevel(partialTick));
        if (starBuffer == null) {
            return;
        }
        if (this.vanilla()) {
            if (starLight > 0.0f) {
                RenderSystem.setShaderColor((float)starLight, (float)starLight, (float)starLight, (float)starLight);
                FogRenderer.setupNoFog();
                starBuffer.bind();
                starBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
                VertexBuffer.unbind();
            }
            return;
        }
        float f = starsAngle = !this.movingStars() ? -90.0f : nightAngle;
        if (this.starsTexture().isPresent()) {
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        } else {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
        }
        if (this.allDaysVisible()) {
            RenderSystem.setShaderColor((float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f));
        } else if (starLight > 0.2f) {
            RenderSystem.setShaderColor((float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f));
        }
        StarHelper.drawStars(starBuffer, poseStack, projectionMatrix, starsAngle, this.starsTexture());
    }

    public void handleShootingStars(ClientLevel level, PoseStack poseStack, Matrix4f projectionMatrix, StarSettings star, float partialTick, HashMap<UUID, ShootingStar> shootingStars) {
        float starLight = level.getStarBrightness(partialTick) * (1.0f - level.getRainLevel(partialTick));
        if (!star.allDaysVisible() && !(starLight > 0.2f)) {
            if (!shootingStars.isEmpty()) {
                shootingStars.clear();
            }
            return;
        }
        ShootingStars shootingStarConfig = star.shootingStars().get();
        Random random = new Random();
        if (random.nextInt(1001) >= shootingStarConfig.percentage()) {
            UUID starId = UUID.randomUUID();
            ShootingStar shootingStar = new ShootingStar(random.nextFloat(shootingStarConfig.randomLifetime().x, shootingStarConfig.randomLifetime().y), shootingStarConfig, starId);
            shootingStars.putIfAbsent(starId, shootingStar);
        }
        if (this.shootingStars.isEmpty()) {
            return;
        }
        ArrayList<UUID> starsToRemove = new ArrayList<UUID>();
        for (ShootingStar shootingStar : shootingStars.values()) {
            if (!shootingStar.render(poseStack, projectionMatrix)) continue;
            starsToRemove.add(shootingStar.starId);
        }
        starsToRemove.forEach(shootingStars::remove);
    }

    public record ShootingStars(int percentage, Vec2 randomLifetime, float scale, float speed, Vec3 color, Optional<Integer> rotation) {
        public static Codec<Vec2> VEC2 = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)2).map(listx -> new Vec2(((Float)listx.getFirst()).floatValue(), ((Float)listx.get(1)).floatValue())), vec2 -> List.of(Float.valueOf(vec2.x), Float.valueOf(vec2.y)));
        public static final Codec<ShootingStars> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("percentage").forGetter(ShootingStars::percentage), (App)VEC2.fieldOf("random_lifetime").forGetter(ShootingStars::randomLifetime), (App)Codec.FLOAT.fieldOf("scale").forGetter(ShootingStars::scale), (App)Codec.FLOAT.fieldOf("speed").forGetter(ShootingStars::speed), (App)Vec3.CODEC.fieldOf("color").forGetter(ShootingStars::color), (App)Codec.INT.optionalFieldOf("rotation").forGetter(ShootingStars::rotation)).apply((Applicative)instance, ShootingStars::new));
    }
}

