/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import fr.tathan.sky_aesthetics.client.skies.settings.StarSettings;
import fr.tathan.sky_aesthetics.client.skies.utils.StarHelper;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ShootingStar {
    private final float lifeTime;
    private final StarSettings.ShootingStars starConfig;
    private final VertexBuffer starBuffer;
    public final UUID starId;
    private float life;
    private final int rotation;
    private final float randomSpeedModifier;

    public ShootingStar(float lifeTime, StarSettings.ShootingStars starConfig, UUID starId) {
        this.lifeTime = lifeTime;
        this.starConfig = starConfig;
        this.starBuffer = this.createStar(starConfig.color());
        this.starId = starId;
        this.life = 0.0f;
        this.randomSpeedModifier = new Random().nextInt(-20, 10);
        this.rotation = starConfig.rotation().isPresent() ? (starConfig.rotation().get() == 0 ? new Random().nextInt(360) : starConfig.rotation().get().intValue()) : 0;
    }

    private VertexBuffer createStar(Vec3 color) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Random random = new Random();
        Vec3 randomPos = new Vec3((double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() * 2.0f - 1.0f));
        StarHelper.createStar(randomPos, color, this.starConfig.scale(), random, bufferBuilder, null);
        vertexBuffer.bind();
        vertexBuffer.upload(bufferBuilder.buildOrThrow());
        VertexBuffer.unbind();
        return vertexBuffer;
    }

    public boolean render(PoseStack poseStack, Matrix4f projectionMatrix) {
        this.life += this.starConfig.speed();
        if (this.life >= this.lifeTime) {
            return true;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)5.0f, (float)4.0f, (float)5.0f, (float)5.0f);
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)this.rotation));
        poseStack.mulPose(Axis.XP.rotationDegrees(this.life + 180.0f));
        FogRenderer.setupNoFog();
        this.starBuffer.bind();
        this.starBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        poseStack.popPose();
        return false;
    }
}

