/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.DimensionRenderer;
import fr.tathan.sky_aesthetics.client.data.SkiesRegistry;
import fr.tathan.sky_aesthetics.client.skies.DimensionSky;
import fr.tathan.sky_aesthetics.helper.PlatformHelper;
import fr.tathan.sky_aesthetics.mixin.client.LevelRendererAccessor;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SkyHelper {
    public static void drawSky(Matrix4f matrix4f, Matrix4f projectionMatrix) {
        ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).stellaris$getSkyBuffer().bind();
        ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).stellaris$getSkyBuffer().drawWithShader(matrix4f, projectionMatrix, RenderSystem.getShader());
        VertexBuffer.unbind();
    }

    public static void drawMoonWithPhase(Tesselator tesselator, PoseStack poseStack, float y, ResourceLocation texture, float dayAngle) {
        int moonPhase = 3;
        int xCoord = moonPhase % 4;
        int yCoord = moonPhase / 4 % 2;
        float startX = (float)xCoord / 4.0f;
        float startY = (float)yCoord / 2.0f;
        float endX = (float)(xCoord + 1) / 4.0f;
        float endY = (float)(yCoord + 1) / 2.0f;
        SkyHelper.drawCelestialBody(texture, tesselator, poseStack, y, 20.0f, dayAngle, startX, endX, startY, endY, true);
    }

    public static void drawCelestialBody(ResourceLocation texture, Tesselator tesselator, PoseStack poseStack, float y, float size, float dayAngle, boolean blend) {
        SkyHelper.drawCelestialBody(texture, tesselator, poseStack, y, size, dayAngle, 0.0f, 1.0f, 1.0f, 0.0f, blend);
    }

    public static void drawCelestialBody(ResourceLocation texture, Tesselator tesselator, PoseStack poseStack, float y, float size, float dayAngle, float startX, float endX, float startY, float endY, boolean blend) {
        SkyHelper.drawCelestialBody(texture, tesselator, poseStack, y, size, dayAngle, startX, endX, startY, endY, blend, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
    }

    public static void drawCelestialBody(ResourceLocation texture, Tesselator tesselator, PoseStack poseStack, float y, float size, float dayAngle, float startX, float endX, float startY, float endY, boolean blend, float @Nullable [] color) {
        if (blend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle));
        Matrix4f matrix4f = poseStack.last().pose();
        if (color == null) {
            color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
        float ratio = 1.0f;
        if (y > Minecraft.getInstance().gameRenderer.getRenderDistance()) {
            ratio = Minecraft.getInstance().gameRenderer.getRenderDistance() / y;
        }
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)4.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, -size * ratio, y * ratio - 1.0f, -size * ratio).setUv(startX, endY);
        bufferBuilder.addVertex(matrix4f, size * ratio, y * ratio - 1.0f, -size * ratio).setUv(endX, endY);
        bufferBuilder.addVertex(matrix4f, size * ratio, y * ratio - 1.0f, size * ratio).setUv(endX, startY);
        bufferBuilder.addVertex(matrix4f, -size * ratio, y * ratio - 1.0f, size * ratio).setUv(startX, startY);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        poseStack.popPose();
        if (blend) {
            RenderSystem.disableBlend();
        }
    }

    public static void renderEndSky(PoseStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).stellaris$getEndSkyLocation());
        Tesselator tesselator = Tesselator.getInstance();
        for (int i = 0; i < 6; ++i) {
            poseStack.pushPose();
            switch (i) {
                case 1: 
                case 4: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case 2: 
                case 5: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case 3: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(270.0f));
                }
            }
            Matrix4f matrix4f = poseStack.last().pose();
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(-14145496);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            poseStack.popPose();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static boolean canRenderSky(ClientLevel level, Consumer<DimensionSky> action) {
        if (SkiesRegistry.SKY_DEV != null && SkiesRegistry.USE_SKY_DEV.booleanValue() && level.dimension().equals(SkiesRegistry.SKY_DEV.getDimension())) {
            action.accept(SkiesRegistry.SKY_DEV);
            return true;
        }
        for (DimensionSky sky : SkiesRegistry.SKY_PROPERTIES.values()) {
            if (!sky.getDimension().equals((Object)level.dimension())) continue;
            if (Arrays.stream(SkyAesthetics.CONFIG.disabledSkies).anyMatch(s -> s.equals(sky.getSkyId().toString()))) {
                return false;
            }
            if (Arrays.stream(SkyAesthetics.CONFIG.disabledDimensions).anyMatch(s -> s.equals(sky.getDimension().location().toString()))) {
                return false;
            }
            DimensionRenderer renderer = sky.getRenderer();
            if (renderer.renderCondition != null && renderer.renderCondition.isSkyRendered(DimensionRenderer.getServerLevel())) {
                return false;
            }
            action.accept(sky);
            return true;
        }
        return false;
    }

    public static boolean isAModCancelRendering(String[] modIds) {
        for (String modId : modIds) {
            if (!PlatformHelper.isModLoaded(modId)) continue;
            return true;
        }
        return false;
    }
}

