/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.tathan.sky_aesthetics.client.DimensionRenderer;
import fr.tathan.sky_aesthetics.client.skies.DimensionSky;
import fr.tathan.sky_aesthetics.client.skies.settings.CloudSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.settings.FogSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.LightSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyBoxSetting;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyColorSettings;
import fr.tathan.sky_aesthetics.client.skies.settings.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.settings.StarSettings;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public record SkyProperties(ResourceKey<Level> world, ResourceLocation id, Optional<CloudSettings> cloudSettings, Optional<FogSettings> fogSettings, Boolean weather, Optional<CustomVanillaObject.Sun> sun, Optional<CustomVanillaObject.Moon> moon, StarSettings stars, Optional<SkyColorSettings> skyColor, List<SkyObject> skyObjects, Optional<RenderCondition> renderCondition, Optional<SkyBoxSetting> skyBoxSetting, Optional<LightSettings> lightSettings) {
    public static final Codec<SkyProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("world").forGetter(SkyProperties::world), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(SkyProperties::id), (App)CloudSettings.CODEC.optionalFieldOf("cloud_settings").forGetter(SkyProperties::cloudSettings), (App)FogSettings.CODEC.optionalFieldOf("fog_settings").forGetter(SkyProperties::fogSettings), (App)Codec.BOOL.fieldOf("weather").forGetter(SkyProperties::weather), (App)CustomVanillaObject.Sun.CODEC.optionalFieldOf("sun").forGetter(SkyProperties::sun), (App)CustomVanillaObject.Moon.CODEC.optionalFieldOf("moon").forGetter(SkyProperties::moon), (App)StarSettings.CODEC.fieldOf("stars").forGetter(SkyProperties::stars), (App)SkyColorSettings.CODEC.optionalFieldOf("sky_color").forGetter(SkyProperties::skyColor), (App)SkyObject.CODEC.listOf().fieldOf("sky_objects").forGetter(SkyProperties::skyObjects), (App)RenderCondition.CODEC.optionalFieldOf("condition").forGetter(SkyProperties::renderCondition), (App)SkyBoxSetting.CODEC.optionalFieldOf("sky_box").forGetter(SkyProperties::skyBoxSetting), (App)LightSettings.CODEC.optionalFieldOf("light_settings").forGetter(SkyProperties::lightSettings)).apply((Applicative)instance, SkyProperties::new));

    public DimensionRenderer toDimensionRenderer() {
        DimensionRenderer.Builder builder = new DimensionRenderer.Builder().setWeather(this.weather).setStar(this.stars);
        this.moon.ifPresent(builder::addMoon);
        this.sun.ifPresent(builder::addSun);
        this.skyObjects.forEach(builder::addSkyObject);
        this.cloudSettings.ifPresent(builder::addCloudSettings);
        this.fogSettings.ifPresent(builder::setFogSettings);
        this.skyColor.ifPresent(builder::setSkyColor);
        this.renderCondition.ifPresent(builder::setRenderCondition);
        this.skyBoxSetting.ifPresent(builder::setSkyBoxSetting);
        return builder.build();
    }

    public DimensionSky toDimensionSky() {
        return new DimensionSky(this);
    }

    public static SkyProperties createDefault() {
        return new SkyProperties((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"overworld")), ResourceLocation.parse((String)"default"), Optional.of(CloudSettings.createDefaultSettings()), Optional.of(FogSettings.createDefaultSettings()), true, Optional.of(CustomVanillaObject.Sun.createDefaultSun()), Optional.of(CustomVanillaObject.Moon.createDefaultMoon()), StarSettings.createDefaultStars(), Optional.of(SkyColorSettings.createDefaultSettings()), List.of(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public record RenderCondition(Optional<TagKey<Biome>> biomes, Optional<ResourceKey<Biome>> biome) {
        public static final Codec<RenderCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(RenderCondition::biomes), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).optionalFieldOf("biome").forGetter(RenderCondition::biome)).apply((Applicative)instance, RenderCondition::new));

        public boolean isSkyRendered(ServerLevel level) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null || level == null) {
                return false;
            }
            if (this.biomes().isPresent()) {
                return level.getBiome(player.getOnPos()).is(this.biomes().get());
            }
            if (this.biome().isPresent()) {
                return level.getBiome(player.getOnPos()).is(this.biome().get());
            }
            return true;
        }
    }
}

