/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.sbr_core.utils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.world.entity.Entity;

public class InputStream {
    private static final Map<UUID, InputStream> INPUT_STREAM_MAP = new HashMap<UUID, InputStream>();
    private final LinkedList<KeyInput> keyStream = new LinkedList();
    public final UUID uuid;
    public final Entity entity;
    private static final long INPUT_TIMEOUT = 600L;

    public static InputStream getOrCreateInputStream(Entity entity) {
        InputStream inputStream = INPUT_STREAM_MAP.get(entity.m_20148_());
        if (inputStream == null) {
            inputStream = new InputStream(entity);
            INPUT_STREAM_MAP.put(entity.m_20148_(), inputStream);
        }
        return inputStream;
    }

    public InputStream(Entity entity) {
        this.entity = entity;
        this.uuid = entity.m_20148_();
    }

    private void cleanTimeOutInput() {
        long time = this.entity.m_9236_().m_46467_();
        while (!this.keyStream.isEmpty()) {
            KeyInput lastKey = this.keyStream.getLast();
            if (lastKey.time >= time - 600L) break;
            this.keyStream.removeLast();
        }
        while (!this.keyStream.isEmpty()) {
            KeyInput firstKey = this.keyStream.getFirst();
            if (firstKey.time <= time) break;
            this.keyStream.removeFirst();
        }
    }

    public void addInput(InputCommand inputCommand, EnumSet<InputCommand> commands, InputType type) {
        this.keyStream.addFirst(new KeyInput(this.entity.m_9236_().m_46467_(), inputCommand, commands, type));
    }

    public boolean checkInputWithPredicate(Predicate<KeyInput> predicate) {
        this.cleanTimeOutInput();
        return this.keyStream.stream().anyMatch(predicate);
    }

    public boolean checkInput(InputCommand targetCommand, InputType type) {
        return this.checkInputWithPredicate(key -> key.inputCommand.equals((Object)targetCommand) && key.type.equals((Object)type));
    }

    public boolean checkInputWithTime(InputCommand targetCommand, InputType type, long timeLimit) {
        return this.checkInputWithPredicate(key -> key.inputCommand.equals((Object)targetCommand) && key.time + timeLimit >= this.entity.m_9236_().m_46467_() && key.type.equals((Object)type));
    }

    public boolean checkInputWithRangedTime(InputCommand targetCommand, InputType type, long startTimeLimit, long endTimeLimit) {
        return this.checkInputWithPredicate(key -> key.inputCommand.equals((Object)targetCommand) && key.time + startTimeLimit >= this.entity.m_9236_().m_46467_() && key.time + endTimeLimit <= this.entity.m_9236_().m_46467_() && key.type.equals((Object)type));
    }

    public boolean checkInputWithCommands(InputCommand targetCommand, InputType type, EnumSet<InputCommand> commands) {
        return this.checkInputWithPredicate(key -> key.inputCommand.equals((Object)targetCommand) && key.commands.containsAll(commands) && key.type.equals((Object)type));
    }

    public boolean checkInputWithCommandsAndTime(InputCommand targetCommand, InputType type, long timeLimit, EnumSet<InputCommand> commands) {
        return this.checkInputWithPredicate(key -> key.inputCommand.equals((Object)targetCommand) && key.time + timeLimit >= this.entity.m_9236_().m_46467_() && key.commands.containsAll(commands) && key.type.equals((Object)type));
    }

    public boolean checkInputWithCommandsAndRangedTime(InputCommand targetCommand, InputType type, long startTimeLimit, long endTimeLimit, EnumSet<InputCommand> commands) {
        return this.checkInputWithPredicate(key -> key.inputCommand.equals((Object)targetCommand) && key.time + startTimeLimit >= this.entity.m_9236_().m_46467_() && key.time + endTimeLimit <= this.entity.m_9236_().m_46467_() && key.commands.containsAll(commands) && key.type.equals((Object)type));
    }

    public boolean checkTimeLineInput(LinkedList<TimeLineKeyInput> inputTimeLine) {
        this.cleanTimeOutInput();
        if (inputTimeLine.isEmpty()) {
            return true;
        }
        long currentReferenceTime = this.entity.m_9236_().m_46467_();
        Iterator inputIterator = this.keyStream.iterator();
        for (TimeLineKeyInput timelineKey : inputTimeLine) {
            long startTime = currentReferenceTime - timelineKey.startBeforeTime;
            long endTime = currentReferenceTime - timelineKey.endBeforeTime;
            boolean found = false;
            while (inputIterator.hasNext()) {
                KeyInput nextInput = (KeyInput)inputIterator.next();
                if (nextInput.time > endTime) continue;
                if (nextInput.time < startTime) break;
                if (!nextInput.inputCommand.equals((Object)timelineKey.inputCommand) || !nextInput.type.equals((Object)timelineKey.type) || !nextInput.commands.containsAll(timelineKey.commands)) continue;
                currentReferenceTime = nextInput.time;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public record KeyInput(long time, InputCommand inputCommand, EnumSet<InputCommand> commands, InputType type) {
    }

    public static enum InputType {
        START,
        END;

    }

    public record TimeLineKeyInput(long startBeforeTime, long endBeforeTime, InputCommand inputCommand, EnumSet<InputCommand> commands, InputType type) {
    }
}

