/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.sbr_core.utils;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import mods.flammpfeil.slashblade.ability.SlayerStyleArts;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.sbr_core.MrqxSlashBladeCore;
import net.mrqx.sbr_core.entity.EntityAirTrickSummonedSword;
import org.apache.commons.lang3.function.TriFunction;

@Mod.EventBusSubscriber
public class MrqxSlayerStyleArts {
    public static final int TRICK_ACTION_UNTOUCHABLE_TIME = 10;
    public static final String AVOID_TRICK_UP_KEY = "sb.avoid.trickup";
    public static final String AVOID_COUNTER_KEY = "sb.avoid.counter";
    public static final String AVOID_VEC_KEY = "sb.avoid.vec";
    public static final String AIR_TRICK_COUNTER_KEY = "sb.airtrick.counter";
    public static final String AIR_TRICK_TARGET_KEY = "sb.airtrick.target";
    public static final TriFunction<LivingEntity, Boolean, Boolean, Boolean> TRICK_UP = (livingEntity, shouldUntouchable, ignoreAvoid) -> livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
        if (!ignoreAvoid.booleanValue() && livingEntity.getPersistentData().m_128451_(AVOID_TRICK_UP_KEY) != 0) {
            return false;
        }
        if (shouldUntouchable.booleanValue()) {
            Untouchable.setUntouchable((LivingEntity)livingEntity, (int)10);
        }
        Vec3 motion = new Vec3(0.0, 0.8, 0.0);
        livingEntity.m_6478_(MoverType.SELF, motion);
        livingEntity.getPersistentData().m_128405_(AVOID_TRICK_UP_KEY, 2);
        livingEntity.m_6853_(false);
        livingEntity.getPersistentData().m_128405_(AVOID_COUNTER_KEY, 2);
        NBTHelper.putVector3d((CompoundTag)livingEntity.getPersistentData(), (String)AVOID_VEC_KEY, (Vec3)livingEntity.m_20182_());
        AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SlayerStyleArts.ADVANCEMENT_TRICK_UP);
        livingEntity.m_5496_(SoundEvents.f_11852_, 0.5f, 1.2f);
        return true;
    }).orElse(false);
    public static final BiFunction<LivingEntity, Boolean, Boolean> AIR_TRICK = (livingEntity, shouldUntouchable) -> livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
        Entity tmpTarget = state.getTargetEntity(livingEntity.m_9236_());
        Object target = tmpTarget != null && tmpTarget.getParts() != null && tmpTarget.getParts().length > 0 ? tmpTarget.getParts()[0] : tmpTarget;
        if (target == null) {
            return false;
        }
        if (target == livingEntity.m_21214_() && livingEntity.f_19797_ < livingEntity.m_21215_() + 100) {
            LivingEntity hitEntity = livingEntity.m_21214_();
            if (hitEntity != null) {
                MrqxSlayerStyleArts.doAirTrickTeleport((Entity)livingEntity, hitEntity);
            }
        } else {
            EntityAirTrickSummonedSword airTrickSummonedSword = new EntityAirTrickSummonedSword(MrqxSlashBladeCore.RegistryEvents.AirTrickSummonedSword, livingEntity.m_9236_());
            airTrickSummonedSword.m_5602_((Entity)livingEntity);
            airTrickSummonedSword.setTarget((Entity)target);
            airTrickSummonedSword.setShouldUntouchable((boolean)shouldUntouchable);
            Vec3 lastPos = livingEntity.m_20299_(1.0f);
            airTrickSummonedSword.f_19790_ = lastPos.f_82479_;
            airTrickSummonedSword.f_19791_ = lastPos.f_82480_;
            airTrickSummonedSword.f_19792_ = lastPos.f_82481_;
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0).m_82549_(livingEntity.m_20154_().m_82490_(-2.0));
            airTrickSummonedSword.m_6034_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            Vec3 dir = livingEntity.m_20154_();
            airTrickSummonedSword.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 1.0f, 0.0f);
            airTrickSummonedSword.m_5602_((Entity)livingEntity);
            airTrickSummonedSword.setDamage(0.01f);
            airTrickSummonedSword.setColor(state.getColorCode());
            airTrickSummonedSword.getPersistentData().m_128379_("doForceHit", true);
            livingEntity.m_9236_().m_7967_((Entity)airTrickSummonedSword);
            livingEntity.m_5496_(SoundEvents.f_11757_, 0.2f, 1.45f);
        }
        return true;
    }).orElse(false);
    public static final BiFunction<LivingEntity, Boolean, Boolean> TRICK_DOWN = (livingEntity, shouldUntouchable) -> livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
        Vec3 oldPos = livingEntity.m_20182_();
        Vec3 motion = new Vec3(0.0, -512.0, 0.0);
        livingEntity.m_6478_(MoverType.SELF, motion);
        if (livingEntity.m_20096_()) {
            if (shouldUntouchable.booleanValue()) {
                Untouchable.setUntouchable((LivingEntity)livingEntity, (int)10);
            }
            livingEntity.getPersistentData().m_128405_(AVOID_COUNTER_KEY, 2);
            NBTHelper.putVector3d((CompoundTag)livingEntity.getPersistentData(), (String)AVOID_VEC_KEY, (Vec3)livingEntity.m_20182_());
            state.updateComboSeq(livingEntity, ComboStateRegistry.NONE.getId());
            AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SlayerStyleArts.ADVANCEMENT_TRICK_DOWN);
            livingEntity.m_5496_(SoundEvents.f_11852_, 0.5f, 1.2f);
        } else {
            livingEntity.m_146884_(oldPos);
        }
        return true;
    }).orElse(false);
    public static final PropertyDispatch.QuadFunction<LivingEntity, Boolean, Boolean, Vec3, Boolean> TRICK_DODGE = (livingEntity, shouldUntouchable, ignoreAvoid, position) -> livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
        Level level = livingEntity.m_9236_();
        if (ignoreAvoid.booleanValue() || 0 < livingEntity.getCapability(CapabilityMobEffect.MOB_EFFECT).map(ef -> ef.doAvoid(level.m_46467_())).orElse(0)) {
            if (shouldUntouchable.booleanValue()) {
                Untouchable.setUntouchable((LivingEntity)livingEntity, (int)10);
            }
            livingEntity.m_5496_(SoundEvents.f_11852_, 0.5f, 1.2f);
            livingEntity.m_20219_(position);
            livingEntity.getPersistentData().m_128405_(AVOID_COUNTER_KEY, 2);
            NBTHelper.putVector3d((CompoundTag)livingEntity.getPersistentData(), (String)AVOID_VEC_KEY, (Vec3)livingEntity.m_20182_());
            AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SlayerStyleArts.ADVANCEMENT_TRICK_DODGE);
            state.updateComboSeq(livingEntity, state.getComboRoot());
            return true;
        }
        return false;
    }).orElse(false);

    public static void doAirTrickTeleport(Entity entityIn, LivingEntity target) {
        entityIn.getPersistentData().m_128405_(AIR_TRICK_COUNTER_KEY, 3);
        entityIn.getPersistentData().m_128405_(AIR_TRICK_TARGET_KEY, target.m_19879_());
        if (entityIn instanceof ServerPlayer) {
            AdvancementHelper.grantCriterion((ServerPlayer)((ServerPlayer)entityIn), (ResourceLocation)SlayerStyleArts.ADVANCEMENT_AIR_TRICK);
            Vec3 motion = target.m_20318_(1.0f).m_82546_(entityIn.m_20318_(1.0f)).m_82490_(0.5);
            ((ServerPlayer)entityIn).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entityIn.m_19879_(), motion));
        }
    }

    private static void executeTeleport(LivingEntity entityIn, LivingEntity target) {
        Level level = entityIn.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel worldIn = (ServerLevel)level;
        entityIn.m_5496_(SoundEvents.f_11852_, 0.75f, 1.25f);
        entityIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.updateComboSeq(entityIn, state.getComboRoot()));
        Untouchable.setUntouchable((LivingEntity)entityIn, (int)10);
        Vec3 teleportPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0).m_82549_(entityIn.m_20154_().m_82490_(-2.0));
        double x = teleportPos.f_82479_;
        double y = teleportPos.f_82480_;
        double z = teleportPos.f_82481_;
        float yaw = entityIn.m_146908_();
        float pitch = entityIn.m_146909_();
        Set relativeList = Collections.emptySet();
        BlockPos blockpos = new BlockPos((int)x, (int)y, (int)z);
        if (Level.m_46741_((BlockPos)blockpos)) {
            if (entityIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entityIn;
                ChunkPos chunkpos = new ChunkPos(blockpos);
                worldIn.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)entityIn.m_19879_());
                entityIn.m_8127_();
                if (serverPlayer.m_5803_()) {
                    serverPlayer.m_6145_(true, true);
                }
                if (worldIn == entityIn.m_9236_()) {
                    serverPlayer.f_8906_.m_9780_(x, y, z, yaw, pitch, relativeList);
                } else {
                    serverPlayer.m_8999_(worldIn, x, y, z, yaw, pitch);
                }
                entityIn.m_5616_(yaw);
            } else {
                float f1 = Mth.m_14177_((float)yaw);
                float f = Mth.m_14177_((float)pitch);
                f = Mth.m_14036_((float)f, (float)-90.0f, (float)90.0f);
                if (worldIn != entityIn.m_9236_()) {
                    entityIn.m_19877_();
                    LivingEntity entity = (LivingEntity)entityIn.m_6095_().m_20615_((Level)worldIn);
                    if (entity == null) {
                        return;
                    }
                    entity.m_20361_((Entity)entityIn);
                    entity.m_7678_(x, y, z, f1, f);
                    entity.m_5616_(f1);
                } else {
                    entityIn.m_7678_(x, y, z, f1, f);
                    entityIn.m_5616_(f1);
                }
            }
            if (!entityIn.m_21255_()) {
                entityIn.m_20256_(entityIn.m_20184_().m_82542_(1.0, 0.0, 1.0));
                entityIn.m_6853_(false);
            }
            if (entityIn instanceof PathfinderMob) {
                ((PathfinderMob)entityIn).m_21573_().m_26573_();
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTickEvent(LivingEvent.LivingTickEvent event) {
        AttributeInstance stepHeightAttribute;
        Vec3 deltaMovement;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            return;
        }
        Vec3 input = new Vec3((double)entity.f_20900_, (double)entity.f_20901_, (double)entity.f_20902_);
        double scale = 1.0;
        float yRot = entity.m_146908_();
        double d0 = input.m_82556_();
        if (d0 < 1.0E-7) {
            deltaMovement = Vec3.f_82478_;
        } else {
            Vec3 vec3 = (d0 > 1.0 ? input.m_82541_() : input).m_82490_(scale);
            float f = Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
            float f1 = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
            deltaMovement = new Vec3(vec3.f_82479_ * (double)f1 - vec3.f_82481_ * (double)f, vec3.f_82480_, vec3.f_82481_ * (double)f1 + vec3.f_82479_ * (double)f);
        }
        boolean doStepUpBoost = true;
        Vec3 offset = deltaMovement.m_82541_().m_82490_(0.5).m_82520_(0.0, 0.25, 0.0);
        BlockPos offsetPos = new BlockPos(VectorHelper.f2i((Vec3)entity.m_20182_().m_82549_(offset))).m_7495_();
        BlockState blockState = entity.m_9236_().m_8055_(offsetPos);
        if (blockState.m_278721_()) {
            doStepUpBoost = false;
        }
        if ((stepHeightAttribute = entity.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())) != null) {
            AttributeModifier stepUpBonus = new AttributeModifier(UUID.fromString("c8158a43-a96f-4db9-8858-57294fbe0ebb"), "StepUp Bonus", 0.5, AttributeModifier.Operation.ADDITION);
            stepHeightAttribute.m_22130_(stepUpBonus);
            if (doStepUpBoost && entity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
                stepHeightAttribute.m_22125_(stepUpBonus);
            }
        }
        if (entity.m_20096_() && 0 < entity.getPersistentData().m_128451_(AVOID_TRICK_UP_KEY)) {
            int count = entity.getPersistentData().m_128451_(AVOID_TRICK_UP_KEY);
            if (--count <= 0) {
                entity.getPersistentData().m_128473_(AVOID_TRICK_UP_KEY);
                if (entity instanceof ServerPlayer) {
                    ((ServerPlayer)entity).m_8959_();
                }
            } else {
                entity.getPersistentData().m_128405_(AVOID_TRICK_UP_KEY, count);
            }
        }
        if (entity.getPersistentData().m_128441_(AVOID_COUNTER_KEY)) {
            int count = entity.getPersistentData().m_128451_(AVOID_COUNTER_KEY);
            if (--count <= 0) {
                if (entity.getPersistentData().m_128441_(AVOID_VEC_KEY)) {
                    Vec3 pos = NBTHelper.getVector3d((CompoundTag)entity.getPersistentData(), (String)AVOID_VEC_KEY);
                    entity.m_20219_(pos);
                    entity.m_9236_().m_7605_((Entity)entity, (byte)46);
                }
                entity.getPersistentData().m_128473_(AVOID_COUNTER_KEY);
                entity.getPersistentData().m_128473_(AVOID_VEC_KEY);
                if (entity instanceof ServerPlayer) {
                    ((ServerPlayer)entity).m_8959_();
                }
            } else {
                entity.getPersistentData().m_128405_(AVOID_COUNTER_KEY, count);
            }
        }
        if (entity.getPersistentData().m_128441_(AIR_TRICK_COUNTER_KEY)) {
            int count = entity.getPersistentData().m_128451_(AIR_TRICK_COUNTER_KEY);
            if (--count <= 0) {
                if (entity.getPersistentData().m_128441_(AIR_TRICK_TARGET_KEY)) {
                    int id = entity.getPersistentData().m_128451_(AIR_TRICK_TARGET_KEY);
                    Entity entity2 = entity.m_9236_().m_6815_(id);
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity2;
                        MrqxSlayerStyleArts.executeTeleport(entity, living);
                    }
                }
                entity.getPersistentData().m_128473_(AIR_TRICK_COUNTER_KEY);
                entity.getPersistentData().m_128473_(AIR_TRICK_TARGET_KEY);
                if (entity instanceof ServerPlayer) {
                    ((ServerPlayer)entity).m_8959_();
                }
            } else {
                entity.getPersistentData().m_128405_(AIR_TRICK_COUNTER_KEY, count);
            }
        }
    }
}

