/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.sbr_core.utils;

import java.util.List;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.SummonedSwordArts;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntityBlisteringSwords;
import mods.flammpfeil.slashblade.entity.EntityHeavyRainSwords;
import mods.flammpfeil.slashblade.entity.EntitySpiralSwords;
import mods.flammpfeil.slashblade.entity.EntityStormSwords;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mrqx.sbr_core.utils.QuadConsumer;
import org.apache.logging.log4j.util.TriConsumer;

public class MrqxSummonedSwordArts {
    public static final TriConsumer<LivingEntity, LivingEntity, Double> BASE_SUMMONED_SWORD = (livingEntity, target, damage) -> {
        AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SummonedSwordArts.ADVANCEMENT_SUMMONEDSWORDS);
        Level worldIn = livingEntity.m_9236_();
        Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20192_() * 0.5, target.m_20189_());
        EntityAbstractSummonedSword summonedSword = new EntityAbstractSummonedSword(SlashBlade.RegistryEvents.SummonedSword, worldIn);
        Vec3 pos = livingEntity.m_20299_(1.0f).m_82549_(VectorHelper.getVectorForRotation((float)0.0f, (float)(livingEntity.m_5675_(0.0f) + 90.0f)).m_82490_(livingEntity.m_9236_().f_46441_.m_188500_() > 0.5 ? 1.0 : -1.0));
        summonedSword.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        summonedSword.setDamage(damage.doubleValue());
        summonedSword.m_5602_((Entity)livingEntity);
        livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> summonedSword.setColor(state.getColorCode()));
        summonedSword.setRoll(livingEntity.m_217043_().m_188501_() * 360.0f);
        Vec3 dir = targetPos.m_82546_(pos).m_82541_();
        summonedSword.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 3.0f, 0.0f);
        worldIn.m_7967_((Entity)summonedSword);
        livingEntity.m_5496_(SoundEvents.f_11757_, 0.2f, 1.45f);
    };
    public static final TriConsumer<LivingEntity, Double, Integer> SPIRAL_SWORD = (livingEntity, damage, count) -> {
        boolean alreadySummoned = livingEntity.m_20197_().stream().anyMatch(e -> e instanceof EntitySpiralSwords);
        if (alreadySummoned) {
            List<Entity> list = livingEntity.m_20197_().stream().filter(e -> e instanceof EntitySpiralSwords).toList();
            list.forEach(e -> ((EntitySpiralSwords)e).doFire());
        } else {
            livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SummonedSwordArts.ADVANCEMENT_SPIRAL_SWORDS);
                Level worldIn = livingEntity.m_9236_();
                for (int i = 0; i < count; ++i) {
                    EntitySpiralSwords spiralSwords = new EntitySpiralSwords(SlashBlade.RegistryEvents.SpiralSwords, worldIn);
                    spiralSwords.m_146884_(livingEntity.m_20182_());
                    spiralSwords.m_5602_((Entity)livingEntity);
                    spiralSwords.setColor(state.getColorCode());
                    spiralSwords.setRoll(0.0f);
                    spiralSwords.setDamage(damage.doubleValue());
                    spiralSwords.m_7998_((Entity)livingEntity, true);
                    spiralSwords.setDelay(360 / count * i);
                    worldIn.m_7967_((Entity)spiralSwords);
                    livingEntity.m_5496_(SoundEvents.f_11757_, 0.2f, 1.45f);
                }
            });
        }
    };
    public static final QuadConsumer<LivingEntity, LivingEntity, Double, Integer> STORM_SWORD = (livingEntity, target, damage, count) -> livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
        Level worldIn = livingEntity.m_9236_();
        if (!target.m_6084_() || target.m_213877_()) {
            return;
        }
        AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SummonedSwordArts.ADVANCEMENT_STORM_SWORDS);
        for (int i = 0; i < count; ++i) {
            EntityStormSwords stormSwords = new EntityStormSwords(SlashBlade.RegistryEvents.StormSwords, worldIn);
            stormSwords.m_146884_(livingEntity.m_20182_());
            stormSwords.m_5602_((Entity)livingEntity);
            stormSwords.setColor(state.getColorCode());
            stormSwords.setRoll(0.0f);
            stormSwords.setDamage(damage.doubleValue());
            stormSwords.m_7998_((Entity)target, true);
            stormSwords.setDelay(360 / count * i);
            worldIn.m_7967_((Entity)stormSwords);
            livingEntity.m_5496_(SoundEvents.f_11757_, 0.2f, 1.45f);
        }
    });
    public static final QuadConsumer<LivingEntity, LivingEntity, Double, Integer> BLISTERING_SWORD = (livingEntity, target, damage, count) -> livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
        Level worldIn = livingEntity.m_9236_();
        if (!target.m_6084_() || target.m_213877_()) {
            return;
        }
        AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SummonedSwordArts.ADVANCEMENT_BLISTERING_SWORDS);
        for (int i = 0; i < count; ++i) {
            EntityBlisteringSwords blisteringSwords = new EntityBlisteringSwords(SlashBlade.RegistryEvents.BlisteringSwords, worldIn);
            blisteringSwords.m_146884_(livingEntity.m_20182_());
            blisteringSwords.m_5602_((Entity)livingEntity);
            blisteringSwords.setColor(state.getColorCode());
            blisteringSwords.setRoll(0.0f);
            blisteringSwords.setDamage(damage.doubleValue());
            blisteringSwords.m_7998_((Entity)livingEntity, true);
            blisteringSwords.setDelay(i);
            worldIn.m_7967_((Entity)blisteringSwords);
            livingEntity.m_5496_(SoundEvents.f_11757_, 0.2f, 1.45f);
        }
    });
    public static final QuadConsumer<LivingEntity, Vec3, Double, Integer> HEAVY_RAIN_SWORD_POS = (livingEntity, targetPos, damage, count) -> livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
        Level worldIn = livingEntity.m_9236_();
        AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SummonedSwordArts.ADVANCEMENT_HEAVY_RAIN_SWORDS);
        Vec3 basePos = targetPos.m_82520_(0.0, 7.0, 0.0);
        EntityHeavyRainSwords rainSwords = new EntityHeavyRainSwords(SlashBlade.RegistryEvents.HeavyRainSwords, worldIn);
        rainSwords.m_5602_((Entity)livingEntity);
        rainSwords.setColor(state.getColorCode());
        rainSwords.setRoll(0.0f);
        rainSwords.setDamage(damage.doubleValue());
        rainSwords.m_7998_((Entity)livingEntity, true);
        rainSwords.setDelay(0);
        rainSwords.m_146884_(basePos);
        rainSwords.m_146926_(-90.0f);
        worldIn.m_7967_((Entity)rainSwords);
        for (int i = 0; i < count; ++i) {
            EntityHeavyRainSwords heavyRainSwords = new EntityHeavyRainSwords(SlashBlade.RegistryEvents.HeavyRainSwords, worldIn);
            heavyRainSwords.m_5602_((Entity)livingEntity);
            heavyRainSwords.setColor(state.getColorCode());
            heavyRainSwords.setRoll(0.0f);
            heavyRainSwords.setDamage(damage.doubleValue());
            heavyRainSwords.m_7998_((Entity)livingEntity, true);
            heavyRainSwords.setDelay(i);
            heavyRainSwords.setSpread(basePos);
            heavyRainSwords.m_146926_(-90.0f);
            worldIn.m_7967_((Entity)heavyRainSwords);
            livingEntity.m_5496_(SoundEvents.f_11757_, 0.2f, 1.45f);
        }
    });
    public static final QuadConsumer<LivingEntity, Entity, Double, Integer> HEAVY_RAIN_SWORD = (livingEntity, target, damage, count) -> livingEntity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
        Vec3 targetPos;
        AdvancementHelper.grantCriterion((LivingEntity)livingEntity, (ResourceLocation)SummonedSwordArts.ADVANCEMENT_HEAVY_RAIN_SWORDS);
        if (target != null) {
            targetPos = target.m_20182_();
        } else {
            Vec3 forwardDir = MrqxSummonedSwordArts.calculateViewVector(0.0f, livingEntity.m_146908_());
            targetPos = livingEntity.m_20318_(0.0f).m_82549_(forwardDir.m_82490_(5.0));
        }
        HEAVY_RAIN_SWORD_POS.accept((LivingEntity)livingEntity, targetPos, (Double)damage, (Integer)count);
    });

    public static Vec3 calculateViewVector(float x, float y) {
        float f = x * ((float)Math.PI / 180);
        float f1 = -y * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

