/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.api;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.r3944realms.superleadrope.api.type.util.ILeashHelper;
import top.r3944realms.superleadrope.api.workspace.Services;

public class SuperLeadRopeApi {
    public static final Logger LOGGER = LoggerFactory.getLogger(SuperLeadRopeApi.class);
    public static String MOD_ID = "superleadrope";

    public static ILeashHelper getLeashHelper() {
        return Services.WORK_SPACE.getLeashHelper();
    }

    @NotNull
    public static List<Entity> leashableInArea(Level pLevel, Vec3 pPos, Predicate<Entity> filter) {
        return SuperLeadRopeApi.leashableInArea(pLevel, pPos, filter, 1024.0);
    }

    @NotNull
    public static List<Entity> leashableInArea(@NotNull Entity entity, Predicate<Entity> filter, double fetchDistance) {
        return SuperLeadRopeApi.leashableInArea(entity.level(), entity.getBoundingBox().getCenter(), filter, fetchDistance);
    }

    @NotNull
    public static List<Entity> leashableInArea(@NotNull Level pLevel, Vec3 pPos, Predicate<Entity> filter, double fetchDistance) {
        return Services.WORK_SPACE.leashableInArea(pLevel, pPos, filter, fetchDistance);
    }

    @NotNull
    public static List<Entity> leashableInArea(Entity entity, Predicate<Entity> filter) {
        return SuperLeadRopeApi.leashableInArea(entity, filter, 1024.0);
    }

    @NotNull
    public static List<Entity> leashableInArea(Entity holder) {
        return SuperLeadRopeApi.leashableInArea(holder, (Entity i) -> SuperLeadRopeApi.isLeashHolder(i, holder), 1024.0);
    }

    public static boolean isSuperLeadKnot(Entity entity) {
        return Services.WORK_SPACE.isSuperLeadKnot(entity);
    }

    public static BlockPos getSuperLeadKnotPos(Entity entity) {
        return Services.WORK_SPACE.getSuperLeadPos(entity);
    }

    public static boolean isLeashable(Entity entity) {
        return Services.WORK_SPACE.isLeashable(entity);
    }

    public static boolean isLeashHolder(@NotNull Entity pEntity, Entity pTestHolder) {
        return Services.WORK_SPACE.isSuperLeadKnot(pTestHolder) ? SuperLeadRopeApi.isLeashHolder(pEntity, Services.WORK_SPACE.getSuperLeadPos(pTestHolder)) : SuperLeadRopeApi.isLeashHolder(pEntity, pTestHolder.getUUID());
    }

    public static boolean isLeashHolder(@NotNull Entity pEntity, UUID pHolderUUID) {
        return Services.WORK_SPACE.getLeashData(pEntity).map(leashData -> leashData.isLeashedBy(pHolderUUID)).orElse(false);
    }

    public static boolean isLeashHolder(@NotNull Entity pEntity, BlockPos pKnotPos) {
        return Services.WORK_SPACE.getLeashData(pEntity).map(leashData -> leashData.isLeashedBy(pKnotPos)).orElse(false);
    }
}

