/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.api.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.api.type.capabilty.LeashHolder;
import top.r3944realms.superleadrope.api.type.capabilty.LeashInfo;

public abstract class SuperLeadRopeEvent
extends Event
implements IModBusEvent {
    private final Entity LeashedEntity;

    protected SuperLeadRopeEvent(Entity leashedEntity) {
        this.LeashedEntity = leashedEntity;
    }

    public Entity getLeashedEntity() {
        return this.LeashedEntity;
    }

    @Cancelable
    public static class teleportWithHolder
    extends SuperLeadRopeEvent {
        private final Entity holderEntity;
        private final Level originalLevel;
        private final Level newLevel;
        private final Vec3 originalPosition;
        private final Vec3 newPosition;

        public teleportWithHolder(Entity leashedEntity, Entity holderEntity, Level originalLevel, Level newLevel, Vec3 originalPosition, Vec3 newPosition) {
            super(leashedEntity);
            this.holderEntity = holderEntity;
            this.originalLevel = originalLevel;
            this.newLevel = newLevel;
            this.originalPosition = originalPosition;
            this.newPosition = newPosition;
        }

        public Entity getHolderEntity() {
            return this.holderEntity;
        }

        public Vec3 getOriginalPosition() {
            return this.originalPosition;
        }

        public Level getOriginalLevel() {
            return this.originalLevel;
        }

        public Level getNewLevel() {
            return this.newLevel;
        }

        public Vec3 getNewPosition() {
            return this.newPosition;
        }
    }

    public static class keepNotBreakTick
    extends SuperLeadRopeEvent {
        private final int remainedTicks;
        private final Entity holderEntity;
        private final Map.Entry<?, LeashInfo> entry;

        public keepNotBreakTick(Entity leashedEntity, int remainedTicks, Entity holderEntity, Map.Entry<?, LeashInfo> entry) {
            super(leashedEntity);
            this.remainedTicks = remainedTicks;
            this.holderEntity = holderEntity;
            this.entry = entry;
        }

        public Entity getHolderEntity() {
            return this.holderEntity;
        }

        public int getRemainedTicks() {
            return this.remainedTicks;
        }

        public void resetRemainedTicks() {
            this.entry.setValue(this.entry.getValue().resetKeepTicks());
        }

        public int getMaxKeepTicks() {
            return this.entry.getValue().maxKeepLeashTicks();
        }
    }

    @Cancelable
    public static class hasFocus
    extends SuperLeadRopeEvent {
        private final Map<UUID, LeashInfo> vaildLeashHolders;
        private final Map<BlockPos, LeashInfo> vaildLeashKnots;
        private final Entity finalForceTarget;
        private Vec3 combinedForce;

        public hasFocus(Entity leashedEntity, Entity finalForceTarget, Vec3 combinedForce, Map<UUID, LeashInfo> vaildLeashHolders, Map<BlockPos, LeashInfo> vaildLeashKnots) {
            super(leashedEntity);
            this.finalForceTarget = finalForceTarget;
            this.combinedForce = combinedForce;
            this.vaildLeashHolders = new HashMap<UUID, LeashInfo>(vaildLeashHolders);
            this.vaildLeashKnots = new HashMap<BlockPos, LeashInfo>(vaildLeashKnots);
        }

        public Entity getFinalForceTarget() {
            return this.finalForceTarget;
        }

        public Vec3 getCombinedForce() {
            return this.combinedForce;
        }

        public void setCombinedForce(Vec3 combinedForce) {
            this.combinedForce = combinedForce;
        }

        public Map<UUID, LeashInfo> getVaildLeashHolders() {
            return this.vaildLeashHolders;
        }

        public Map<BlockPos, LeashInfo> getVaildLeashKnots() {
            return this.vaildLeashKnots;
        }
    }

    @Cancelable
    public static class ModifyValue
    extends SuperLeadRopeEvent {
        @Nullable
        private final LeashHolder holder;
        @Nullable
        private final Double oldValue;
        @Nullable
        private final Double newValue;
        private final Type type;
        private final Scope scope;

        public ModifyValue(Entity leashedEntity, UUID holderUUID, @Nullable Double oldValue, @Nullable Double newValue, Type type) {
            super(leashedEntity);
            this.holder = new LeashHolder(holderUUID);
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.type = type;
            this.scope = Scope.INSTANCE;
        }

        public ModifyValue(Entity leashedEntity, BlockPos knotBlockpos, @Nullable Double oldValue, @Nullable Double newValue, Type type) {
            super(leashedEntity);
            this.holder = new LeashHolder(knotBlockpos);
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.type = type;
            this.scope = Scope.INSTANCE;
        }

        public ModifyValue(Entity leashedEntity, @Nullable Double oldValue, @Nullable Double newValue, Type type) {
            super(leashedEntity);
            this.holder = null;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.type = type;
            this.scope = Scope.STATIC;
        }

        @Nullable
        public LeashHolder getHolder() {
            return this.holder;
        }

        @Nullable
        public Double getOldValue() {
            return this.oldValue;
        }

        @Nullable
        public Double getNewValue() {
            return this.newValue;
        }

        public Type getType() {
            return this.type;
        }

        public Scope getScope() {
            return this.scope;
        }

        public static enum Type {
            MAX_DISTANCE,
            ELASTIC_DISTANCE_SCALE;

        }

        public static enum Scope {
            STATIC,
            INSTANCE;

        }
    }

    @Cancelable
    public static class TransferLeash
    extends SuperLeadRopeEvent {
        private final LeashHolder oldLeashHolder;
        private final Entity newLeashHolder;

        public TransferLeash(Entity leashedEntity, UUID holderEntity, Entity newLeashHolder) {
            this(leashedEntity, holderEntity, null, false, newLeashHolder);
        }

        public TransferLeash(Entity leashedEntity, BlockPos holderKnot, Entity newLeashHolder) {
            this(leashedEntity, null, holderKnot, true, newLeashHolder);
        }

        private TransferLeash(Entity leashedEntity, @Nullable UUID holderEntity, @Nullable BlockPos holderPos, boolean isSuperLeadRopeKnot, Entity newLeashHolder) {
            super(leashedEntity);
            this.oldLeashHolder = isSuperLeadRopeKnot ? new LeashHolder(holderPos) : new LeashHolder(holderEntity);
            this.newLeashHolder = newLeashHolder;
        }

        public Entity getNewLeashHolder() {
            return this.newLeashHolder;
        }

        public LeashHolder getOldLeashHolder() {
            return this.oldLeashHolder;
        }
    }

    @Cancelable
    public static class RemoveLeash
    extends SuperLeadRopeEvent {
        private final LeashHolder leashHolder;

        public RemoveLeash(Entity leashedEntity, UUID holderEntity) {
            this(leashedEntity, holderEntity, null, false);
        }

        public RemoveLeash(Entity leashedEntity, BlockPos holderKnot) {
            this(leashedEntity, null, holderKnot, true);
        }

        private RemoveLeash(Entity leashedEntity, @Nullable UUID holderEntity, @Nullable BlockPos holderPos, boolean isSuperLeadRopeKnot) {
            super(leashedEntity);
            this.leashHolder = isSuperLeadRopeKnot ? new LeashHolder(holderPos) : new LeashHolder(holderEntity);
        }

        public LeashHolder getLeashHolder() {
            return this.leashHolder;
        }
    }

    @Cancelable
    public static class AddLeash
    extends SuperLeadRopeEvent {
        private final Entity holderEntity;
        @Nullable
        private final Double maxLeashDistance;
        @Nullable
        private final Double elasticDistanceScale;

        public AddLeash(Entity leashedEntity, Entity holderEntity) {
            this(leashedEntity, holderEntity, null, null);
        }

        public AddLeash(Entity leashedEntity, Entity holderEntity, @Nullable Double maxLeashDistance, @Nullable Double elasticDistanceScale) {
            super(leashedEntity);
            this.holderEntity = holderEntity;
            this.maxLeashDistance = maxLeashDistance;
            this.elasticDistanceScale = elasticDistanceScale;
        }

        public Entity getHolderEntity() {
            return this.holderEntity;
        }

        @Nullable
        public Double getMaxLeashDistance() {
            return this.maxLeashDistance;
        }

        @Nullable
        public Double getElasticDistanceScale() {
            return this.elasticDistanceScale;
        }
    }
}

