/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.api.type.util;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.api.SuperLeadRopeApi;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashData;
import top.r3944realms.superleadrope.api.type.capabilty.LeashInfo;

public interface ILeashHelper {
    public IHolder getHolderHelper(Entity var1);

    public ILeashed getLeashedHelper(Entity var1);

    public static boolean chooseMethodWithBooleanRet(@NotNull Supplier<Boolean> cond, Supplier<Boolean> trueSupplier, Supplier<Boolean> falseSupplier) {
        if (cond.get().booleanValue()) {
            return trueSupplier.get();
        }
        return falseSupplier.get();
    }

    public static void chooseMethodWithVoidRet(@NotNull Supplier<Boolean> cond, Supplier<Void> trueSupplier, Supplier<Void> falseSupplier) {
        if (cond.get().booleanValue()) {
            trueSupplier.get();
            return;
        }
        falseSupplier.get();
    }

    public static interface ILeashed {
        public ILeashData getLeashData();

        default public boolean attachLeash(Entity holder) {
            return this.getLeashData().addLeash(holder);
        }

        default public boolean attachLeash(Entity holder, String reserved) {
            return this.getLeashData().addLeash(holder, reserved);
        }

        default public boolean attachLeash(Entity holder, Double maxDistance, Double elasticDistanceScale) {
            return this.getLeashData().addLeash(holder, maxDistance, elasticDistanceScale);
        }

        default public boolean attachLeash(Entity holder, Double maxDistance, Double elasticDistanceScale, String reserved) {
            return this.getLeashData().addLeash(holder, maxDistance, elasticDistanceScale, reserved);
        }

        default public boolean attachLeash(Entity holder, Double maxDistance, Double elasticDistanceScale, int maxKeepTicks) {
            return this.getLeashData().addLeash(holder, maxDistance, elasticDistanceScale, maxKeepTicks);
        }

        default public boolean attachLeash(Entity holder, Double maxDistance, Double elasticDistanceScale, int maxKeepTicks, String reserved) {
            return this.getLeashData().addLeash(holder, maxDistance, elasticDistanceScale, maxKeepTicks, reserved);
        }

        default public boolean detachLeash(Entity entity) {
            return this.getLeashData().removeLeash(entity);
        }

        default public boolean detachLeash(UUID uuid) {
            return this.getLeashData().removeLeash(uuid);
        }

        default public boolean detachLeash(BlockPos blockPos) {
            return this.getLeashData().removeLeash(blockPos);
        }

        default public void detachAllLeashes() {
            this.getLeashData().removeAllLeashes();
        }

        default public void removeAllHolderLeashes() {
            this.getLeashData().removeAllHolderLeashes();
        }

        default public void removeAllKnotLeashes() {
            this.getLeashData().removeAllKnotLeashes();
        }

        default public boolean isLeashed() {
            return this.getLeashData().hasLeash();
        }

        default public boolean hasHolderLeashed() {
            return this.getLeashData().hasHolderLeash();
        }

        default public boolean isKnotLeashed() {
            return this.getLeashData().hasKnotLeash();
        }

        default public boolean isLeashedBy(Entity entity) {
            return this.getLeashData().isLeashedBy(entity);
        }

        default public boolean isLeashedBy(UUID uuid) {
            return this.getLeashData().isLeashedBy(uuid);
        }

        default public boolean isLeashedBy(BlockPos blockPos) {
            return this.getLeashData().isLeashedBy(blockPos);
        }

        default public Optional<LeashInfo> getLeashInfo(Entity entity) {
            return this.getLeashData().getLeashInfo(entity);
        }

        default public Optional<LeashInfo> getLeashInfo(UUID holderUUID) {
            return this.getLeashData().getLeashInfo(holderUUID);
        }

        default public Optional<LeashInfo> getLeashInfo(BlockPos knotPos) {
            return this.getLeashData().getLeashInfo(knotPos);
        }

        default public boolean transferLeash(Entity fromEntity, Entity toEntity) {
            return this.getLeashData().transferLeash(fromEntity, toEntity);
        }

        default public boolean transferLeash(Entity fromEntity, Entity toEntity, String reserved) {
            return this.getLeashData().transferLeash(fromEntity, toEntity, reserved);
        }

        default public boolean transferLeash(UUID fromEntityUUID, Entity toEntity) {
            return this.getLeashData().transferLeash(fromEntityUUID, toEntity);
        }

        default public boolean transferLeash(UUID fromEntityUUID, Entity toEntity, String reserved) {
            return this.getLeashData().transferLeash(fromEntityUUID, toEntity, reserved);
        }

        default public boolean transferLeash(BlockPos fromKnotBlockPos, Entity toEntity) {
            return this.getLeashData().transferLeash(fromKnotBlockPos, toEntity);
        }

        default public boolean transferLeash(BlockPos fromKnotBlockPos, Entity toEntity, String reserved) {
            return this.getLeashData().transferLeash(fromKnotBlockPos, toEntity, reserved);
        }

        default public boolean isInDelayedLeash(UUID holderUUID) {
            return this.getLeashData().isInDelayedLeash(holderUUID);
        }

        default public void applyLeashPhysics() {
            this.getLeashData().applyLeashForces();
        }

        default public boolean canBeLeashed() {
            return this.getLeashData().canBeLeashed();
        }

        default public boolean canBeAttachedTo(Entity holder) {
            return this.getLeashData().canBeAttachedTo(holder);
        }
    }

    public static interface IHolder {
        public Entity getHolderEntity();

        public Set<ILeashData> getAllLeashData();

        default public int getLeashCount() {
            return this.getAllLeashData().size();
        }

        default public boolean hasLeashes() {
            return !this.getAllLeashData().isEmpty();
        }

        default public void releaseAllLeashes() {
            this.getAllLeashData().forEach(i -> i.removeLeash(this.getHolderEntity()));
        }

        default public boolean isHoldingLeash(Entity entity) {
            return this.getAllLeashData().stream().anyMatch(i -> i.isLeashedBy(entity));
        }

        default public boolean isHoldingLeash(UUID uuid) {
            return this.getAllLeashData().stream().anyMatch(i -> i.isLeashedBy(uuid));
        }

        default public boolean isHoldingLeash(BlockPos blockPos) {
            return this.getAllLeashData().stream().anyMatch(i -> i.isLeashedBy(blockPos));
        }

        default public boolean leashEntity(Entity target) {
            if (SuperLeadRopeApi.isLeashable(target)) {
                if (this.isHoldingLeash(target)) {
                    return false;
                }
                return this.leashEntity(target.m_20148_());
            }
            return false;
        }

        public boolean leashEntity(UUID var1);

        default public boolean unleashEntity(Entity target) {
            if (SuperLeadRopeApi.isLeashable(target)) {
                if (!this.isHoldingLeash(target)) {
                    return false;
                }
                return this.unleashEntity(target.m_20148_());
            }
            return false;
        }

        public boolean unleashEntity(UUID var1);
    }
}

