/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import top.r3944realms.superleadrope.client.renderer.state.SuperLeashRenderState;

public class SuperLeashRenderer {
    private static final int LEASH_STEPS = 24;

    public static void renderLeash(SuperLeashRenderState state, PoseStack poseStack, MultiBufferSource buffer) {
        float[] rgb;
        int packedLight;
        float f;
        int i;
        poseStack.m_85836_();
        Vec3 startWorld = state.startPos();
        Vec3 endWorld = state.endPos();
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110475_());
        Minecraft mc = Minecraft.m_91087_();
        Vec3 camPos = mc.f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(startWorld.f_82479_ - camPos.f_82479_, startWorld.f_82480_ - camPos.f_82480_, startWorld.f_82481_ - camPos.f_82481_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int blockLightStart = SuperLeashRenderer.getBlockLight(BlockPos.m_274446_((Position)startWorld));
        int blockLightEnd = SuperLeashRenderer.getBlockLight(state.isFirstPerson() ? state.belowBlockPos() : BlockPos.m_274446_((Position)endWorld));
        int skyLightStart = 15;
        int skyLightEnd = 15;
        Offsets offsets = SuperLeashRenderer.computeOffsets(startWorld, endWorld);
        for (i = 0; i <= 24; ++i) {
            f = (float)i / 24.0f;
            packedLight = SuperLeashRenderer.packLight(blockLightStart, blockLightEnd, skyLightStart, skyLightEnd, f);
            rgb = SuperLeashRenderer.computeColor(state, i, false);
            SuperLeashRenderer.addVertexPair(consumer, matrix, offsets, packedLight, rgb, i, true);
        }
        for (i = 24; i >= 0; --i) {
            f = (float)i / 24.0f;
            packedLight = SuperLeashRenderer.packLight(blockLightStart, blockLightEnd, skyLightStart, skyLightEnd, f);
            rgb = SuperLeashRenderer.computeColor(state, i, true);
            SuperLeashRenderer.addVertexPair(consumer, matrix, offsets, packedLight, rgb, i, false);
        }
        poseStack.m_85849_();
    }

    private static Offsets computeOffsets(Vec3 start, Vec3 end) {
        float dx = (float)(end.f_82479_ - start.f_82479_);
        float dy = (float)(end.f_82480_ - start.f_82480_);
        float dz = (float)(end.f_82481_ - start.f_82481_);
        float base = 0.05f;
        float horiz = dx * dx + dz * dz;
        float inv = horiz > 1.0E-8f ? Mth.m_264536_((float)horiz) * base / 2.0f : 0.0f;
        float xOffset = dz * inv;
        float zOffset = dx * inv;
        float yOffsetPass1 = base;
        float dyOffsetPass1 = base;
        float yOffsetPass2 = base;
        float dyOffsetPass2 = -dyOffsetPass1;
        return new Offsets(dx, dy, dz, xOffset, zOffset, yOffsetPass1, dyOffsetPass1, yOffsetPass2, dyOffsetPass2);
    }

    private static int packLight(int blockStart, int blockEnd, int skyStart, int skyEnd, float f) {
        int block = (int)Mth.m_14179_((float)f, (float)blockStart, (float)blockEnd);
        int sky = (int)Mth.m_14179_((float)f, (float)skyStart, (float)skyEnd);
        return LightTexture.m_109885_((int)block, (int)sky);
    }

    private static float[] computeColor(SuperLeashRenderState state, int index, boolean reversePass) {
        float distance = (float)state.startPos().m_82554_(state.endPos());
        float ratio = (float)Mth.m_14008_((double)((double)distance / (state.maxDistance() * 2.0)), (double)0.0, (double)1.0);
        float rStart = 0.42f;
        float gStart = 0.31f;
        float bStart = 0.18f;
        float rEnd = 0.69f;
        float gEnd = 0.23f;
        float bEnd = 0.18f;
        float r = Mth.m_14179_((float)ratio, (float)rStart, (float)rEnd);
        float g = Mth.m_14179_((float)ratio, (float)gStart, (float)gEnd);
        float b = Mth.m_14179_((float)ratio, (float)bStart, (float)bEnd);
        float colorFactor = index % 2 == (reversePass ? 1 : 0) ? 0.7f : 1.0f;
        return new float[]{r * colorFactor, g * colorFactor, b * colorFactor};
    }

    private static void addVertexPair(VertexConsumer consumer, Matrix4f matrix, Offsets offsets, int packedLight, float[] rgb, int index, boolean usePass1) {
        float f = (float)index / 24.0f;
        float px = offsets.dx * f;
        float py = offsets.dy > 0.0f ? offsets.dy * f * f : offsets.dy - offsets.dy * (1.0f - f) * (1.0f - f);
        float pz = offsets.dz * f;
        float sway = 0.01f * (float)Math.sin((double)f * Math.PI * 6.0 + (double)index);
        float yOffset = usePass1 ? offsets.yOffsetPass1 : offsets.yOffsetPass2;
        float dyOffset = usePass1 ? offsets.dyOffsetPass1 : offsets.dyOffsetPass2;
        consumer.m_252986_(matrix, px - offsets.xOffset, py + dyOffset + sway, pz + offsets.zOffset).m_85950_(rgb[0], rgb[1], rgb[2], 1.0f).m_85969_(packedLight).m_5752_();
        consumer.m_252986_(matrix, px + offsets.xOffset, py + yOffset - dyOffset - sway, pz - offsets.zOffset).m_85950_(rgb[0], rgb[1], rgb[2], 1.0f).m_85969_(packedLight).m_5752_();
    }

    private static int getBlockLight(BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return 15;
        }
        return mc.f_91073_.m_45517_(LightLayer.BLOCK, pos);
    }

    private static class Offsets {
        public final float dx;
        public final float dy;
        public final float dz;
        public final float xOffset;
        public final float zOffset;
        public final float yOffsetPass1;
        public final float dyOffsetPass1;
        public final float yOffsetPass2;
        public final float dyOffsetPass2;

        public Offsets(float dx, float dy, float dz, float xOffset, float zOffset, float yOffsetPass1, float dyOffsetPass1, float yOffsetPass2, float dyOffsetPass2) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.xOffset = xOffset;
            this.zOffset = zOffset;
            this.yOffsetPass1 = yOffsetPass1;
            this.dyOffsetPass1 = dyOffsetPass1;
            this.yOffsetPass2 = yOffsetPass2;
            this.dyOffsetPass2 = dyOffsetPass2;
        }
    }
}

