/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.extensions.IForgeItem;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.api.SuperLeadRopeApi;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashData;
import top.r3944realms.superleadrope.content.SLPToolTier;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.core.register.SLPSoundEvents;
import top.r3944realms.superleadrope.util.capability.LeashDataInnerAPI;

public class SuperLeadRopeItem
extends TieredItem
implements IForgeItem {
    private static final double SHORT_RANGE = 5.0;
    private static final float THROW_SPEED = 1.5f;

    public SuperLeadRopeItem(@NotNull Item.Properties pProperties) {
        super((Tier)SLPToolTier.STRING, pProperties.m_41503_(1024).setNoRepair());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack lead = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            if (SuperLeadRopeItem.canUse(lead)) {
                return InteractionResultHolder.m_19098_((Object)lead);
            }
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        return InteractionResultHolder.m_19090_((Object)lead);
    }

    public static boolean canUse(@NotNull ItemStack itemStack) {
        return itemStack.m_41773_() < 1000;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        ItemStack itemStack = context.m_43722_();
        if (SuperLeadRopeItem.canUse(itemStack)) {
            return InteractionResult.SUCCESS;
        }
        if (SuperLeashKnotEntity.isSupportBlock(state)) {
            Player player = context.m_43723_();
            if (!level.f_46443_ && player != null) {
                return SuperLeadRopeItem.bindToBlock(player, level, pos, itemStack, false) ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean bindToEntity(Entity newHolder, Player player, Level level) {
        return SuperLeadRopeItem.bindToEntity(newHolder, player, level, player.m_20097_());
    }

    public static boolean bindToEntity(Entity newHolder, Player player, Level level, BlockPos pos) {
        boolean isSuccess = false;
        List<Entity> list = SuperLeadRopeApi.leashableInArea(level, pos.m_252807_(), entity -> SuperLeadRopeApi.isLeashHolder(entity, player.m_20148_()));
        for (Entity e : list) {
            Optional<ILeashData> leashDataOpt = LeashDataInnerAPI.getLeashData(e);
            if (!leashDataOpt.map(i -> i.canBeAttachedTo(newHolder)).orElse(false).booleanValue()) continue;
            leashDataOpt.ifPresent(i -> i.transferLeash(player.m_20148_(), newHolder));
            isSuccess = true;
        }
        if (!isSuccess) {
            return false;
        }
        level.m_220407_(GameEvent.f_223708_, pos, GameEvent.Context.m_223717_((Entity)player));
        level.m_247517_(null, newHolder.m_20097_(), (SoundEvent)SLPSoundEvents.LEAD_UNTIED.get(), SoundSource.PLAYERS);
        return true;
    }

    public static boolean bindToBlock(Player player, Level level, ItemStack leashStack, boolean shouldBindSelf) {
        return SuperLeadRopeItem.bindToBlock(player, level, player.m_20097_(), leashStack, shouldBindSelf);
    }

    public static boolean bindToBlock(Player player, Level level, BlockPos pos, ItemStack leashStack, boolean shouldBindSelf) {
        SuperLeashKnotEntity knot = null;
        AtomicBoolean isSuccess = new AtomicBoolean(false);
        UUID uuid = player.m_20148_();
        List<Entity> list = SuperLeadRopeApi.leashableInArea(level, pos.m_252807_(), entity -> SuperLeadRopeApi.isLeashHolder(entity, uuid));
        if (shouldBindSelf && list.isEmpty()) {
            if (leashStack.m_41619_() || !SuperLeadRopeItem.canUse(leashStack)) {
                return false;
            }
            knot = SuperLeashKnotEntity.getOrCreateKnot(level, pos);
            knot.m_7084_();
            SuperLeashKnotEntity finalKnot = knot;
            LeashDataInnerAPI.getLeashData((Entity)player).ifPresent(i -> {
                if (i.canBeAttachedTo((Entity)finalKnot)) {
                    if (!level.f_46443_) {
                        i.addLeash((Entity)finalKnot);
                    }
                    isSuccess.set(true);
                }
            });
        } else if (!list.isEmpty()) {
            for (Entity e : list) {
                if (knot == null) {
                    knot = SuperLeashKnotEntity.getOrCreateKnot(level, pos);
                    knot.m_7084_();
                }
                SuperLeashKnotEntity finalKnot = knot;
                LeashDataInnerAPI.getLeashData(e).ifPresent(i -> {
                    if (i.canBeAttachedTo((Entity)finalKnot)) {
                        if (!level.f_46443_) {
                            i.transferLeash(uuid, (Entity)finalKnot);
                        }
                        isSuccess.set(true);
                    }
                });
            }
        }
        if (isSuccess.get()) {
            level.m_220407_(GameEvent.f_157791_, pos, GameEvent.Context.m_223717_((Entity)player));
            return true;
        }
        return false;
    }
}

