/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.core.punishment;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record PunishmentDefinition(Type type, float strength, boolean affectOthers) {
    public static final PunishmentDefinition DEFAULT = new PunishmentDefinition(Type.LIGHTNING, 0.0f, false);

    public void toNetwork(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.writeFloat(this.strength);
        buf.writeBoolean(this.affectOthers);
    }

    public static PunishmentDefinition fromNetwork(FriendlyByteBuf buf) {
        Type type = (Type)buf.m_130066_(Type.class);
        float strength = buf.readFloat();
        boolean affectOthers = buf.readBoolean();
        return new PunishmentDefinition(type, strength, affectOthers);
    }

    public void execute(ServerPlayer target, DamageSource cause) {
        this.execute(target, cause, null);
    }

    public void execute(ServerPlayer target, DamageSource cause, @Nullable Component actionMessage) {
        ServerLevel level = (ServerLevel)target.m_9236_();
        switch (this.type) {
            case LIGHTNING: {
                LightningBolt bolt = new LightningBolt(EntityType.f_20465_, (Level)level);
                bolt.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                bolt.m_20874_(true);
                if (actionMessage != null) {
                    target.m_5661_(actionMessage, true);
                }
                level.m_7967_((Entity)bolt);
                target.m_6469_(cause, Float.MAX_VALUE);
                break;
            }
            case EXPLOSION: {
                break;
            }
        }
    }

    public static enum Type {
        LIGHTNING,
        EXPLOSION,
        EFFECT;

    }
}

