/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.util.riding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import top.r3944realms.superleadrope.CommonEventHandler;
import top.r3944realms.superleadrope.core.exception.RidingCycleException;
import top.r3944realms.superleadrope.core.util.ImmutablePair;
import top.r3944realms.superleadrope.util.model.RidingRelationship;
import top.r3944realms.superleadrope.util.riding.RidingFinder;

public class RidingSaver {
    private static Function<UUID, Entity> entityProvider;

    public static RidingRelationship save(@Nullable Entity entity) {
        return RidingSaver.save(entity, true);
    }

    public static RidingRelationship save(@Nullable Entity entity, boolean findRoot) {
        Entity rootEntity;
        if (entity == null) {
            return new RidingRelationship(Collections.emptyList(), null, null);
        }
        Entity entity2 = rootEntity = findRoot ? RidingFinder.findRootVehicle(entity) : entity;
        if (rootEntity == null) {
            return new RidingRelationship(Collections.emptyList(), null, null);
        }
        RidingRelationship rootRelationship = new RidingRelationship();
        rootRelationship.setEntityId(rootEntity.m_20148_());
        rootRelationship.setVehicleId(null);
        rootRelationship.setPassengers(new ArrayList<RidingRelationship>());
        LinkedList<ImmutablePair<Entity, RidingRelationship>> queue = new LinkedList<ImmutablePair<Entity, RidingRelationship>>();
        queue.offer(ImmutablePair.of(rootEntity, rootRelationship));
        HashSet<UUID> processedEntities = new HashSet<UUID>();
        processedEntities.add(rootEntity.m_20148_());
        while (!queue.isEmpty()) {
            ImmutablePair current = (ImmutablePair)queue.poll();
            Entity currentEntity = (Entity)current.first();
            RidingRelationship currentRelation = (RidingRelationship)current.second();
            List passengers = currentEntity.m_20197_();
            if (passengers.isEmpty()) continue;
            for (Entity passenger : passengers) {
                UUID passengerId = passenger.m_20148_();
                if (!processedEntities.contains(passengerId)) {
                    processedEntities.add(passengerId);
                    if (!CommonEventHandler.leashConfigManager.isEntityTeleportAllowed(passenger.m_6095_())) continue;
                    RidingRelationship passengerRelation = new RidingRelationship();
                    passengerRelation.setEntityId(passengerId);
                    passengerRelation.setVehicleId(currentEntity.m_20148_());
                    passengerRelation.setPassengers(new ArrayList<RidingRelationship>());
                    currentRelation.addPassenger(passengerRelation);
                    queue.offer(ImmutablePair.of(passenger, passengerRelation));
                    continue;
                }
                throw new RidingCycleException(passengerId, currentEntity.m_20148_());
            }
        }
        return rootRelationship;
    }

    public static RidingRelationship filterByWhitelistRoot(RidingRelationship relationship) {
        if (relationship == null) {
            return null;
        }
        if (CommonEventHandler.leashConfigManager.isEntityTeleportAllowed(Objects.requireNonNull(RidingSaver.getEntityType(relationship.getEntityId())))) {
            RidingRelationship filtered = new RidingRelationship();
            filtered.setEntityId(relationship.getEntityId());
            filtered.setVehicleId(relationship.getVehicleId());
            filtered.setPassengers(RidingSaver.filterPassengers(relationship.getPassengers()));
            return filtered;
        }
        for (RidingRelationship child : relationship.getPassengers()) {
            if (!CommonEventHandler.leashConfigManager.isEntityTeleportAllowed(Objects.requireNonNull(RidingSaver.getEntityType(child.getEntityId())))) continue;
            RidingRelationship newRoot = new RidingRelationship();
            newRoot.setEntityId(child.getEntityId());
            newRoot.setVehicleId(relationship.getVehicleId());
            newRoot.setPassengers(RidingSaver.filterPassengers(child.getPassengers()));
            return newRoot;
        }
        return new RidingRelationship(new ArrayList<RidingRelationship>(), null, null);
    }

    private static List<RidingRelationship> filterPassengers(List<RidingRelationship> passengers) {
        if (passengers == null || passengers.isEmpty()) {
            return new ArrayList<RidingRelationship>();
        }
        ArrayList<RidingRelationship> filtered = new ArrayList<RidingRelationship>();
        for (RidingRelationship passenger : passengers) {
            RidingRelationship childFiltered = RidingSaver.filterByWhitelistRoot(passenger);
            if (childFiltered == null || childFiltered.getEntityId() == null) continue;
            filtered.add(childFiltered);
        }
        return filtered;
    }

    public static void setEntityProvider(Function<UUID, Entity> provider) {
        entityProvider = provider;
    }

    private static EntityType<?> getEntityType(UUID entityId) {
        if (entityProvider == null) {
            return null;
        }
        Entity entity = entityProvider.apply(entityId);
        if (entity == null) {
            return null;
        }
        return entity.m_6095_();
    }
}

