/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.capability.inter;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;

public interface ILeashData
extends INBTSerializable<CompoundTag> {
    public boolean addLeash(Entity var1);

    public boolean addLeash(Entity var1, String var2);

    public boolean addLeash(Entity var1, double var2);

    public boolean addLeash(Entity var1, double var2, double var4, int var6);

    public boolean addLeash(Entity var1, double var2, String var4);

    public boolean addLeash(Entity var1, double var2, double var4, int var6, String var7);

    public void addLeash(Entity var1, LeashInfo var2);

    public void addDelayedLeash(Player var1);

    public void removeDelayedLeash(UUID var1);

    public boolean removeLeash(Entity var1);

    public boolean removeLeash(UUID var1);

    public boolean removeLeash(BlockPos var1);

    public void removeAllLeashes();

    public void removeAllHolderLeashes();

    public void removeAllKnotLeashes();

    public boolean setMaxDistance(Entity var1, double var2);

    public boolean setMaxDistance(Entity var1, double var2, int var4);

    public boolean setMaxDistance(Entity var1, double var2, int var4, String var5);

    public boolean setMaxDistance(UUID var1, double var2);

    public boolean setMaxDistance(UUID var1, double var2, int var4);

    public boolean setMaxDistance(UUID var1, double var2, int var4, String var5);

    public boolean setMaxDistance(BlockPos var1, double var2);

    public boolean setMaxDistance(BlockPos var1, double var2, int var4);

    public boolean setMaxDistance(BlockPos var1, double var2, int var4, String var5);

    public boolean setElasticDistance(Entity var1, double var2);

    public boolean setElasticDistance(Entity var1, double var2, int var4);

    public boolean setElasticDistance(Entity var1, double var2, int var4, String var5);

    public boolean setElasticDistance(UUID var1, double var2);

    public boolean setElasticDistance(UUID var1, double var2, int var4);

    public boolean setElasticDistance(UUID var1, double var2, int var4, String var5);

    public boolean setElasticDistance(BlockPos var1, double var2);

    public boolean setElasticDistance(BlockPos var1, double var2, int var4);

    public boolean setElasticDistance(BlockPos var1, double var2, int var4, String var5);

    public void applyLeashForces();

    public boolean transferLeash(Entity var1, Entity var2);

    public boolean transferLeash(Entity var1, Entity var2, String var3);

    public boolean transferLeash(UUID var1, Entity var2);

    public boolean transferLeash(UUID var1, Entity var2, String var3);

    public boolean transferLeash(BlockPos var1, Entity var2);

    public boolean transferLeash(BlockPos var1, Entity var2, String var3);

    public boolean hasLeash();

    public boolean hasKnotLeash();

    public boolean hasHolderLeash();

    public Collection<LeashInfo> getAllLeashes();

    public boolean isLeashedBy(Entity var1);

    public boolean isLeashedBy(UUID var1);

    public boolean isLeashedBy(BlockPos var1);

    public boolean isInDelayedLeash(UUID var1);

    public Optional<LeashInfo> getLeashInfo(Entity var1);

    public Optional<LeashInfo> getLeashInfo(UUID var1);

    public Optional<LeashInfo> getLeashInfo(BlockPos var1);

    public boolean canBeLeashed();

    public boolean canBeAttachedTo(Entity var1);

    public Optional<UUID> occupyLeash();

    public void markForSync();

    public void immediateSync();

    public void checkSync();

    public record LeashInfo(Optional<BlockPos> blockPosOpt, Optional<UUID> holderUUIDOpt, Optional<Integer> holderIdOpt, String reserved, double maxDistance, double elasticDistance, int keepLeashTicks, int maxKeepLeashTicks) {
        public static final LeashInfo EMPTY = new LeashInfo(Optional.empty(), Optional.empty(), Optional.empty(), "", 12.0, 6.0, 0, 0);

        public LeashInfo(UUID holderUUID, int holderId, String reserved, double maxDistance, double elasticDistance, int keepTicks, int maxKeepTicks) {
            this(Optional.empty(), Optional.of(holderUUID), Optional.of(holderId), reserved, maxDistance, elasticDistance, keepTicks, maxKeepTicks);
        }

        public LeashInfo(BlockPos knotPos, int holderId, String reserved, double maxDistance, double elasticDistance, int keepTicks, int maxKeepTicks) {
            this(Optional.of(knotPos), Optional.empty(), Optional.of(holderId), reserved, maxDistance, elasticDistance, keepTicks, maxKeepTicks);
        }

        public static LeashInfo create(Entity entity, String reserved, double maxDistance, double elasticDistance, int keepTicks, int maxKeepTicks) {
            LeashInfo leashInfo;
            if (entity instanceof SuperLeashKnotEntity) {
                SuperLeashKnotEntity knot = (SuperLeashKnotEntity)entity;
                leashInfo = new LeashInfo(knot.m_31748_(), entity.m_19879_(), reserved, maxDistance, elasticDistance, keepTicks, maxKeepTicks);
            } else {
                leashInfo = new LeashInfo(entity.m_20148_(), entity.m_19879_(), reserved, maxDistance, elasticDistance, keepTicks, maxKeepTicks);
            }
            return leashInfo;
        }

        public LeashInfo decrementKeepTicks() {
            return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, this.reserved, this.maxDistance, this.elasticDistance, Math.max(0, this.keepLeashTicks - 1), this.maxKeepLeashTicks);
        }

        public LeashInfo resetKeepTicks() {
            return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, this.reserved, this.maxDistance, this.elasticDistance, this.maxKeepLeashTicks, this.maxKeepLeashTicks);
        }

        public LeashInfo transferHolder(Entity entity) {
            return this.transferHolder(entity, this.reserved);
        }

        public LeashInfo transferHolder(Entity entity, String newReserved) {
            boolean isKnot = entity instanceof SuperLeashKnotEntity;
            return new LeashInfo(isKnot ? Optional.of(((SuperLeashKnotEntity)entity).m_31748_()) : Optional.empty(), !isKnot ? Optional.of(entity.m_20148_()) : Optional.empty(), Optional.of(entity.m_19879_()), newReserved, this.maxDistance, this.elasticDistance, this.keepLeashTicks, this.maxKeepLeashTicks);
        }
    }
}

