/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.util.riding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import top.r3944realms.superleadrope.util.model.RidingRelationship;

public class RidingFinder {
    public static List<Entity> getEntityFromRidingShip(RidingRelationship ship, Function<UUID, Entity> entityProvider) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        LinkedList<RidingRelationship> queue = new LinkedList<RidingRelationship>();
        queue.offer(ship);
        while (!queue.isEmpty()) {
            RidingRelationship poll = (RidingRelationship)queue.poll();
            ret.add(entityProvider.apply(ship.getEntityId()));
            List<RidingRelationship> passengers = poll.getPassengers();
            if (passengers.isEmpty()) continue;
            queue.addAll(passengers);
        }
        return ret;
    }

    @Nullable
    public static Entity findRootVehicle(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        Entity current = entity;
        while (current.m_20202_() != null && (current = current.m_20202_()) != entity) {
        }
        return current;
    }

    public static List<Entity> getAllPassengers(@Nullable Entity entity) {
        return RidingFinder.getAllPassengers(entity, true);
    }

    public static List<Entity> getAllPassengers(@Nullable Entity entity, boolean findRoot) {
        Entity rootEntity;
        if (entity == null) {
            return Collections.emptyList();
        }
        Entity entity2 = rootEntity = findRoot ? RidingFinder.findRootVehicle(entity) : entity;
        if (rootEntity == null) {
            return Collections.emptyList();
        }
        ArrayList<Entity> result = new ArrayList<Entity>();
        LinkedList<Entity> queue = new LinkedList<Entity>();
        queue.offer(rootEntity);
        while (!queue.isEmpty()) {
            Entity current = (Entity)queue.poll();
            result.add(current);
            List passengers = current.m_20197_();
            if (passengers.isEmpty()) continue;
            queue.addAll(passengers);
        }
        return Collections.unmodifiableList(result);
    }
}

