/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.config.LeashCommonConfig;

public class LeashConfigManager {
    private final Map<String, double[]> entityHolderMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> tagHolderMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> modHolderMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> entityLeashMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> tagLeashMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> modLeashMap = new ConcurrentHashMap<String, double[]>();
    private volatile List<String> teleportWhitelistCache = Collections.emptyList();
    private volatile String commandPrefixCache = "slp";
    private volatile boolean commandPrefixEnabledCache = true;
    private volatile boolean enableTrueDamping = true;
    private volatile double maxForce = 1.0;
    private volatile double playerSpringFactor = 0.3;
    private volatile double mobSpringFactor = 0.5;
    private volatile double maxLeashLength = 12.0;
    private volatile double elasticDistance = 6.0;
    private volatile double extremeSnapFactor = 2.0;
    private volatile double springDampening = 0.7;
    private volatile List<Double> axisElasticity = List.of(Double.valueOf(0.8), Double.valueOf(0.2), Double.valueOf(0.8));
    private volatile int maxLeashesPerEntity = 6;

    public LeashConfigManager() {
        this.reloadAll();
    }

    private Map<String, Map<String, double[]>> parseOffsetList(List<? extends String> offsetConfigs) {
        HashMap<String, double[]> entityMap = new HashMap<String, double[]>();
        HashMap<String, double[]> tagMap = new HashMap<String, double[]>();
        HashMap<String, double[]> modMap = new HashMap<String, double[]>();
        for (String string : offsetConfigs) {
            Matcher matcher = LeashCommonConfig.Common.OFFSET_PATTERN.matcher(string);
            if (!matcher.matches()) continue;
            try {
                String[] entities;
                double x = Double.parseDouble(matcher.group(1).trim());
                double y = Double.parseDouble(matcher.group(2).trim());
                double z = Double.parseDouble(matcher.group(3).trim());
                double[] offset = new double[]{x, y, z};
                for (String e : entities = matcher.group(4).split(",")) {
                    String trimmed = e.trim();
                    if (trimmed.equals("*")) {
                        modMap.put("*", offset);
                        continue;
                    }
                    if (trimmed.startsWith("#")) {
                        String body = trimmed.substring(1).trim();
                        if (body.contains(":")) {
                            tagMap.put(body, offset);
                            continue;
                        }
                        modMap.put(body, offset);
                        continue;
                    }
                    entityMap.put(trimmed, offset);
                }
            }
            catch (NumberFormatException ex) {
                SuperLeadRope.logger.error("Invalid offset config: {}", (Object)string);
            }
        }
        return Map.of("entity", entityMap, "tag", tagMap, "mod", modMap);
    }

    public void parseOffsetConfig() {
        Map<String, Map<String, double[]>> holder = this.parseOffsetList((List)LeashCommonConfig.COMMON.defaultHolderLocationOffset.get());
        this.entityHolderMap.clear();
        this.entityHolderMap.putAll(holder.get("entity"));
        this.tagHolderMap.clear();
        this.tagHolderMap.putAll(holder.get("tag"));
        this.modHolderMap.clear();
        this.modHolderMap.putAll(holder.get("mod"));
        Map<String, Map<String, double[]>> leash = this.parseOffsetList((List)LeashCommonConfig.COMMON.defaultApplyEntityLocationOffset.get());
        this.entityLeashMap.clear();
        this.entityLeashMap.putAll(leash.get("entity"));
        this.tagLeashMap.clear();
        this.tagLeashMap.putAll(leash.get("tag"));
        this.modLeashMap.clear();
        this.modLeashMap.putAll(leash.get("mod"));
    }

    private double[] getOffset(String entityId, String modId, List<String> tags, Map<String, double[]> entityMap, Map<String, double[]> tagMap, Map<String, double[]> modMap) {
        if (entityMap.containsKey(entityId)) {
            return entityMap.get(entityId);
        }
        for (String tag : tags) {
            if (!tagMap.containsKey(tag)) continue;
            return tagMap.get(tag);
        }
        if (modMap.containsKey(modId)) {
            return modMap.get(modId);
        }
        return modMap.getOrDefault("*", null);
    }

    public Vec3 getDefaultEntityOffset(EntityType<?> type) {
        String entityId = type.m_204041_().m_205785_().m_135782_().toString();
        String modId = entityId.split(":")[0];
        ArrayList<String> tags = new ArrayList<String>();
        for (TagKey t : type.m_204041_().m_203616_().toList()) {
            tags.add(t.f_203868_().toString());
        }
        double[] offset = this.getOffset(entityId, modId, tags, this.entityLeashMap, this.tagLeashMap, this.modLeashMap);
        return offset != null ? new Vec3(offset[0], offset[1], offset[2]) : Vec3.f_82478_;
    }

    public Vec3 getDefaultHolderOffset(EntityType<?> type) {
        String entityId = type.m_204041_().m_205785_().m_135782_().toString();
        String modId = entityId.split(":")[0];
        ArrayList<String> tags = new ArrayList<String>();
        for (TagKey t : type.m_204041_().m_203616_().toList()) {
            tags.add(t.f_203868_().toString());
        }
        double[] offset = this.getOffset(entityId, modId, tags, this.entityHolderMap, this.tagHolderMap, this.modHolderMap);
        return offset != null ? new Vec3(offset[0], offset[1], offset[2]) : Vec3.f_82478_;
    }

    public Vec3 getDefaultEntityOffset(Entity entity) {
        return this.getDefaultEntityOffset(entity.m_6095_());
    }

    public Vec3 getDefaultHolderOffset(Entity entity) {
        return this.getDefaultHolderOffset(entity.m_6095_());
    }

    public List<String> getTeleportWhitelist() {
        return Collections.unmodifiableList(this.teleportWhitelistCache);
    }

    public boolean isEntityTeleportAllowed(EntityType<?> type) {
        String entityId = type.m_204041_().m_205785_().m_135782_().toString();
        String modId = entityId.split(":")[0];
        for (String entry : this.teleportWhitelistCache) {
            if (entry.startsWith("#")) {
                String body = entry.substring(1);
                if (!body.contains(":") && body.equals(modId)) {
                    return true;
                }
                if (!body.contains(":")) continue;
                ResourceLocation tagId = new ResourceLocation(body);
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagId);
                if (!type.m_204041_().m_203656_(tag)) continue;
                return true;
            }
            if (!entry.equals(entityId)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntityTeleportAllowed(Entity entity) {
        return this.isEntityTeleportAllowed(entity.m_6095_());
    }

    public String getCommandPrefix() {
        return this.commandPrefixCache;
    }

    public boolean isCommandPrefixEnabled() {
        return this.commandPrefixEnabledCache;
    }

    public String getFullCommand(String subCommand) {
        return this.isCommandPrefixEnabled() ? this.getCommandPrefix() + " " + subCommand : subCommand;
    }

    public boolean isEnableTrueDamping() {
        return this.enableTrueDamping;
    }

    public double getMaxForce() {
        return this.maxForce;
    }

    public double getPlayerSpringFactor() {
        return this.playerSpringFactor;
    }

    public double getMobSpringFactor() {
        return this.mobSpringFactor;
    }

    public double getMaxLeashLength() {
        return this.maxLeashLength;
    }

    public double getElasticDistance() {
        return this.elasticDistance;
    }

    public double getExtremeSnapFactor() {
        return this.extremeSnapFactor;
    }

    public double getBreakDistance() {
        return this.maxLeashLength * this.extremeSnapFactor;
    }

    public double getSpringDampening() {
        return this.springDampening;
    }

    public List<Double> getAxisElasticity() {
        return Collections.unmodifiableList(this.axisElasticity);
    }

    public double getXElasticity() {
        return !this.axisElasticity.isEmpty() ? this.axisElasticity.get(0) : 0.8;
    }

    public double getYElasticity() {
        return this.axisElasticity.size() > 1 ? this.axisElasticity.get(1) : 0.2;
    }

    public double getZElasticity() {
        return this.axisElasticity.size() > 2 ? this.axisElasticity.get(2) : 0.8;
    }

    public int getMaxLeashesPerEntity() {
        return this.maxLeashesPerEntity;
    }

    public boolean canEntityAcceptMoreLeashes(Entity entity, int currentCount) {
        return currentCount < this.maxLeashesPerEntity;
    }

    public void reloadAll() {
        this.parseOffsetConfig();
        this.teleportWhitelistCache = new ArrayList<String>((Collection)LeashCommonConfig.COMMON.teleportWhitelist.get());
        this.commandPrefixCache = (String)LeashCommonConfig.COMMON.SLPModCommandPrefix.get();
        this.commandPrefixEnabledCache = (Boolean)LeashCommonConfig.COMMON.enableSLPModCommandPrefix.get();
        this.maxLeashLength = (Double)LeashCommonConfig.COMMON.maxLeashLength.get();
        this.elasticDistance = (Double)LeashCommonConfig.COMMON.elasticDistance.get();
        this.extremeSnapFactor = (Double)LeashCommonConfig.COMMON.extremeSnapFactor.get();
        this.springDampening = (Double)LeashCommonConfig.COMMON.springDampening.get();
        this.axisElasticity = new ArrayList<Double>((Collection)LeashCommonConfig.COMMON.axisSpecificElasticity.get());
        this.maxLeashesPerEntity = (Integer)LeashCommonConfig.COMMON.maxLeashesPerEntity.get();
        this.enableTrueDamping = (Boolean)LeashCommonConfig.COMMON.enableTrueDamping.get();
        this.maxForce = (Double)LeashCommonConfig.COMMON.maxForce.get();
        this.playerSpringFactor = (Double)LeashCommonConfig.COMMON.playerSpringFactor.get();
        this.mobSpringFactor = (Double)LeashCommonConfig.COMMON.mobSpringFactor.get();
        SuperLeadRope.logger.debug("Configs reloaded: {}", (Object)this.getStats());
    }

    public void clear() {
        this.entityHolderMap.clear();
        this.tagHolderMap.clear();
        this.modHolderMap.clear();
        this.entityLeashMap.clear();
        this.tagLeashMap.clear();
        this.modLeashMap.clear();
        this.teleportWhitelistCache = Collections.emptyList();
    }

    public static void loading(LeashConfigManager manager) {
        manager.reloadAll();
    }

    public static void reloading(LeashConfigManager manager) {
        manager.reloadAll();
    }

    public static void unloading(LeashConfigManager manager) {
        if (manager != null) {
            manager.clear();
        }
    }

    public String getStats() {
        return String.format("Holder: Entities: %d, Tags: %d, Mods: %d\nLeash: Entities: %d, Tags: %d, Mods: %d, TeleportWhitelist: %d", this.entityHolderMap.size(), this.tagHolderMap.size(), this.modHolderMap.size(), this.entityLeashMap.size(), this.tagLeashMap.size(), this.modLeashMap.size(), this.teleportWhitelistCache.size());
    }
}

