/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.capability.impi;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.CommonEventHandler;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.compat.CurtainCompat;
import top.r3944realms.superleadrope.content.capability.inter.ILeashData;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.core.register.SLPSoundEvents;
import top.r3944realms.superleadrope.network.NetworkHandler;
import top.r3944realms.superleadrope.network.toClient.LeashDataSyncPacket;
import top.r3944realms.superleadrope.util.capability.LeashDataAPI;
import top.r3944realms.superleadrope.util.capability.LeashStateAPI;
import top.r3944realms.superleadrope.util.riding.RindingLeash;

public class LeashDataImpl
implements ILeashData {
    private final Entity entity;
    private boolean needsSync = false;
    private long lastSyncTime;
    private final Set<UUID> delayedHolders = new CopyOnWriteArraySet<UUID>();
    private final Map<UUID, ILeashData.LeashInfo> leashHolders = new ConcurrentHashMap<UUID, ILeashData.LeashInfo>();
    private final Map<BlockPos, ILeashData.LeashInfo> leashKnots = new ConcurrentHashMap<BlockPos, ILeashData.LeashInfo>();

    public LeashDataImpl(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void markForSync() {
        if (!this.entity.m_9236_().f_46443_) {
            this.needsSync = true;
            this.immediateSync();
        }
    }

    @Override
    public void immediateSync() {
        this.syncNow();
    }

    @Override
    public void checkSync() {
        if (!this.needsSync || this.entity.m_9236_().f_46443_) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSyncTime > 2000L) {
            this.syncNow();
        }
    }

    private void syncNow() {
        CompoundTag currentData = this.serializeNBT();
        NetworkHandler.sendToPlayer(new LeashDataSyncPacket(this.entity.m_19879_(), currentData), this.entity, PacketDistributor.TRACKING_ENTITY_AND_SELF);
        this.lastSyncTime = System.currentTimeMillis();
        this.needsSync = false;
    }

    @Override
    public boolean addLeash(Entity holder) {
        return this.addLeash(holder, CommonEventHandler.leashConfigManager.getMaxLeashLength());
    }

    @Override
    public boolean addLeash(Entity holder, String reserved) {
        return this.addLeash(holder, CommonEventHandler.leashConfigManager.getMaxLeashLength(), reserved);
    }

    @Override
    public boolean addLeash(Entity holder, double maxDistance) {
        return this.addLeash(holder, maxDistance, CommonEventHandler.leashConfigManager.getElasticDistance(), 0, "");
    }

    @Override
    public boolean addLeash(Entity holder, double maxDistance, double elasticDistance, int maxKeepLeashTicks) {
        return this.addLeash(holder, maxDistance, elasticDistance, maxKeepLeashTicks, "");
    }

    @Override
    public boolean addLeash(Entity holder, double maxDistance, String reserved) {
        return this.addLeash(holder, maxDistance, CommonEventHandler.leashConfigManager.getElasticDistance(), 0, reserved);
    }

    @Override
    public boolean addLeash(Entity holder, double maxDistance, double elasticDistance, int maxKeepLeashTicks, String reserved) {
        boolean isSuperKnot = holder instanceof SuperLeashKnotEntity;
        if (!isSuperKnot && this.leashHolders.containsKey(holder.m_20148_()) || isSuperKnot && this.leashKnots.containsKey(((SuperLeashKnotEntity)holder).m_31748_())) {
            return false;
        }
        if (!this.canBeLeashed()) {
            Optional<UUID> uuidOptional = this.occupyLeash();
            if (uuidOptional.isEmpty()) {
                return false;
            }
            this.removeLeash(uuidOptional.get());
        }
        ILeashData.LeashInfo info = ILeashData.LeashInfo.create(holder, reserved, maxDistance, elasticDistance, maxKeepLeashTicks, maxKeepLeashTicks);
        if (isSuperKnot) {
            this.leashKnots.put(((SuperLeashKnotEntity)holder).m_31748_(), info);
        } else {
            this.leashHolders.put(holder.m_20148_(), info);
        }
        LeashStateAPI.Offset.setHolderFor(this.entity, holder);
        this.markForSync();
        return true;
    }

    @Override
    public void addLeash(Entity holder, ILeashData.LeashInfo leashInfo) {
        this.addLeash(holder, leashInfo.maxDistance(), leashInfo.elasticDistance(), leashInfo.maxKeepLeashTicks(), leashInfo.reserved());
    }

    @Override
    public void addDelayedLeash(Player holderPlayer) {
        this.delayedHolders.add(holderPlayer.m_20148_());
    }

    @Override
    public void removeDelayedLeash(UUID onceHolderUUID) {
        this.delayedHolders.remove(onceHolderUUID);
    }

    private <K> boolean updateLeashInfo(Map<K, ILeashData.LeashInfo> map, K key, Function<ILeashData.LeashInfo, ILeashData.LeashInfo> updater) {
        ILeashData.LeashInfo old = map.get(key);
        if (old == null || old.holderIdOpt().isEmpty()) {
            return false;
        }
        ILeashData.LeashInfo updated = updater.apply(old);
        if (updated == null) {
            return false;
        }
        map.put(key, updated);
        this.markForSync();
        return true;
    }

    @Override
    public boolean setMaxDistance(Entity holder, double newMaxDistance) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setMaxDistance(superLeashKnotEntity.m_31748_(), newMaxDistance);
        } else {
            bl = this.setMaxDistance(holder.m_20148_(), newMaxDistance);
        }
        return bl;
    }

    @Override
    public boolean setMaxDistance(Entity holder, double newMaxDistance, int newMaxKeepLeashTicks) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setMaxDistance(superLeashKnotEntity.m_31748_(), newMaxDistance, newMaxKeepLeashTicks);
        } else {
            bl = this.setMaxDistance(holder.m_20148_(), newMaxDistance, newMaxKeepLeashTicks);
        }
        return bl;
    }

    @Override
    public boolean setMaxDistance(Entity holder, double distance, int maxKeepTicks, String reserved) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setMaxDistance(superLeashKnotEntity.m_31748_(), distance, maxKeepTicks, reserved);
        } else {
            bl = this.setMaxDistance(holder.m_20148_(), distance, maxKeepTicks, reserved);
        }
        return bl;
    }

    @Override
    public boolean setMaxDistance(UUID holderUUID, double newMaxDistance) {
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new ILeashData.LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.reserved(), newMaxDistance, old.elasticDistance(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setMaxDistance(UUID holderUUID, double newMaxDistance, int newMaxKeepLeashTicks) {
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new ILeashData.LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.reserved(), newMaxDistance, old.elasticDistance(), Math.min(old.keepLeashTicks(), newMaxKeepLeashTicks), newMaxKeepLeashTicks));
    }

    @Override
    public boolean setMaxDistance(UUID holderUUID, double distance, int maxKeepTicks, String reserved) {
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new ILeashData.LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), reserved, distance, old.elasticDistance(), Math.min(old.keepLeashTicks(), maxKeepTicks), maxKeepTicks));
    }

    @Override
    public boolean setMaxDistance(BlockPos knotPos, double newMaxDistance) {
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new ILeashData.LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.reserved(), newMaxDistance, old.elasticDistance(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setMaxDistance(BlockPos knotPos, double newMaxDistance, int newMaxKeepLeashTicks) {
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new ILeashData.LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.reserved(), newMaxDistance, old.elasticDistance(), Math.min(old.keepLeashTicks(), newMaxKeepLeashTicks), newMaxKeepLeashTicks));
    }

    @Override
    public boolean setMaxDistance(BlockPos knotPos, double distance, int maxKeepTicks, String reserved) {
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new ILeashData.LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), reserved, distance, old.elasticDistance(), Math.min(old.keepLeashTicks(), maxKeepTicks), maxKeepTicks));
    }

    @Override
    public boolean setElasticDistance(Entity holder, double newElasticDistance) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setElasticDistance(superLeashKnotEntity.m_31748_(), newElasticDistance);
        } else {
            bl = this.setElasticDistance(holder.m_20148_(), newElasticDistance);
        }
        return bl;
    }

    @Override
    public boolean setElasticDistance(UUID holderUUID, double newElasticDistance) {
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new ILeashData.LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.reserved(), old.maxDistance(), newElasticDistance, old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setElasticDistance(BlockPos knotPos, double newElasticDistance) {
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new ILeashData.LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.reserved(), old.maxDistance(), newElasticDistance, old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setElasticDistance(Entity holder, double newElasticDistance, int newMaxKeepLeashTicks) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setElasticDistance(superLeashKnotEntity.m_31748_(), newElasticDistance, newMaxKeepLeashTicks);
        } else {
            bl = this.setElasticDistance(holder.m_20148_(), newElasticDistance, newMaxKeepLeashTicks);
        }
        return bl;
    }

    @Override
    public boolean setElasticDistance(Entity holder, double distance, int maxKeepTicks, String reserved) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setElasticDistance(superLeashKnotEntity.m_31748_(), distance, maxKeepTicks, reserved);
        } else {
            bl = this.setElasticDistance(holder.m_20148_(), distance, maxKeepTicks, reserved);
        }
        return bl;
    }

    @Override
    public boolean setElasticDistance(UUID holderUUID, double newElasticDistance, int newMaxKeepLeashTicks) {
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new ILeashData.LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.reserved(), old.maxDistance(), newElasticDistance, Math.min(old.keepLeashTicks(), newMaxKeepLeashTicks), newMaxKeepLeashTicks));
    }

    @Override
    public boolean setElasticDistance(UUID holderUUID, double distance, int maxKeepTicks, String reserved) {
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new ILeashData.LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), reserved, old.maxDistance(), distance, Math.min(old.keepLeashTicks(), maxKeepTicks), maxKeepTicks));
    }

    @Override
    public boolean setElasticDistance(BlockPos knotPos, double newElasticDistance, int newMaxKeepLeashTicks) {
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new ILeashData.LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.reserved(), old.maxDistance(), newElasticDistance, old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setElasticDistance(BlockPos knotPos, double newElasticDistance, int newMaxKeepLeashTicks, String reserved) {
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new ILeashData.LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), reserved, old.maxDistance(), newElasticDistance, Math.min(old.keepLeashTicks(), newMaxKeepLeashTicks), newMaxKeepLeashTicks));
    }

    @Override
    public void applyLeashForces() {
        Vec3 force;
        Vec3 combinedForce = Vec3.f_82478_;
        Vec3 combinedDirection = Vec3.f_82478_;
        int validLeashes = 0;
        for (Map.Entry<UUID, ILeashData.LeashInfo> entry : this.leashHolders.entrySet()) {
            force = this.calculateLeashForceForUUID(entry);
            if (force == null) continue;
            combinedForce = combinedForce.m_82549_(force);
            combinedDirection = combinedDirection.m_82549_(force.m_82541_());
            ++validLeashes;
        }
        for (Map.Entry<UUID, ILeashData.LeashInfo> entry : this.leashKnots.entrySet()) {
            force = this.calculateLeashForceForBlockPos(entry);
            if (force == null) continue;
            combinedForce = combinedForce.m_82549_(force);
            combinedDirection = combinedDirection.m_82549_(force.m_82541_());
            ++validLeashes;
        }
        boolean hasForce = !combinedForce.equals((Object)Vec3.f_82478_);
        Entity entity = RindingLeash.getFinalEntityForLeashIfForce(this.entity, hasForce);
        if (entity != null && hasForce) {
            ServerPlayer player;
            if (entity instanceof ServerPlayer && CurtainCompat.isNotFakePlayer((Player)(player = (ServerPlayer)entity))) {
                RindingLeash.applyForceToPlayer(player, combinedForce, CommonEventHandler.leashConfigManager.getPlayerSpringFactor(), 0.0, CommonEventHandler.leashConfigManager.getMaxForce());
            } else {
                this.applyForceToNonPlayerEntity(entity, combinedForce, validLeashes, combinedDirection);
            }
        }
        RindingLeash.protectAnimalMovement(entity, hasForce);
    }

    private void applyForceToNonPlayerEntity(Entity entity, Vec3 combinedForce, int validLeashes, Vec3 combinedDirection) {
        entity.m_20256_(entity.m_20184_().m_82549_(combinedForce));
        entity.f_19864_ = true;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.f_19797_ % 5 == 0) {
                if (validLeashes > 0 && this.canMobMove(mob)) {
                    this.moveMobTowardsCombinedDirection(mob, combinedDirection, validLeashes, combinedForce.m_82553_());
                } else {
                    mob.m_21573_().m_26573_();
                }
            }
        }
    }

    private boolean canMobMove(Mob mob) {
        return !mob.m_21224_() && mob.m_21515_() && mob.m_20184_().m_82556_() < 25.0;
    }

    private void moveMobTowardsCombinedDirection(Mob mob, Vec3 combinedDirection, int leashCount, double forceMagnitude) {
        if (combinedDirection.equals((Object)Vec3.f_82478_) || !this.canMobMove(mob)) {
            return;
        }
        Vec3 averageDirection = combinedDirection.m_82541_();
        double speed = this.calculateMobSpeed(mob, forceMagnitude);
        Vec3 targetPos = mob.m_20182_().m_82549_(averageDirection.m_82490_(2.0));
        if (this.isPositionQuickReachable(mob, targetPos)) {
            mob.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, speed);
            if (mob.f_19797_ % 10 == 0) {
                mob.m_21563_().m_24964_(targetPos);
            }
        }
    }

    private boolean isPositionQuickReachable(Mob mob, Vec3 targetPos) {
        double distance = mob.m_20182_().m_82554_(targetPos);
        if (distance > 10.0) {
            return false;
        }
        double heightDiff = Math.abs(targetPos.f_82480_ - mob.m_20182_().f_82480_);
        if (heightDiff > 2.0) {
            return false;
        }
        if (mob.m_9236_().m_46749_(BlockPos.m_274446_((Position)targetPos))) {
            BlockHitResult hitResult = mob.m_9236_().m_45547_(new ClipContext(mob.m_20182_(), targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob));
            return hitResult.m_6662_() == HitResult.Type.MISS;
        }
        return true;
    }

    private double calculateMobSpeed(Mob mob, double forceMagnitude) {
        double baseSpeed = mob instanceof Llama ? 1.5 : 1.0;
        double forceFactor = Math.min(forceMagnitude * 0.3, 1.5);
        return baseSpeed * (1.0 + forceFactor);
    }

    private Vec3 calculateLeashForceForUUID(Map.Entry<UUID, ILeashData.LeashInfo> entry) {
        UUID uuid = entry.getKey();
        Entity uuidHolder = ((ServerLevel)this.entity.m_9236_()).m_8791_(uuid);
        if (uuidHolder != null) {
            return this.calculateLeashForce(uuidHolder, entry);
        }
        if (!this.delayedHolders.contains(uuid)) {
            SuperLeadRope.logger.warn("Could not apply leash forces for {}, because it is not found(it will be removed from list).", (Object)uuid);
            this.leashHolders.remove(uuid);
        }
        return null;
    }

    private Vec3 calculateLeashForceForBlockPos(Map.Entry<BlockPos, ILeashData.LeashInfo> entry) {
        SuperLeashKnotEntity orCreateKnot = SuperLeashKnotEntity.getOrCreateKnot(this.entity.m_9236_(), entry.getKey());
        return this.calculateLeashForce((Entity)orCreateKnot, entry);
    }

    private Vec3 calculateLeashForce(Entity holder, Map.Entry<?, ILeashData.LeashInfo> entry) {
        double extremeSnapDist;
        Vec3 holderPos = holder.m_20182_().m_82520_(0.0, (double)holder.m_20206_() * 0.7, 0.0);
        ILeashData.LeashInfo info = entry.getValue();
        Vec3 entityPos = this.entity.m_20182_();
        double distance = holderPos.m_82554_(entityPos);
        if (distance > (extremeSnapDist = CommonEventHandler.leashConfigManager.getBreakDistance())) {
            if (info.keepLeashTicks() > 0) {
                Vec3 pullForce = this.calculateCriticalPullForce(holderPos, entityPos, distance, info);
                entry.setValue(info.decrementKeepTicks());
                return pullForce;
            }
            this.removeLeash(holder);
            this.entity.m_9236_().m_247517_(null, holder.m_20097_(), (SoundEvent)SLPSoundEvents.LEAD_BREAK.get(), SoundSource.PLAYERS);
            return null;
        }
        Vec3 pullForce = Vec3.f_82478_;
        if (distance > info.elasticDistance()) {
            pullForce = this.calculatePullForce(holderPos, entityPos, distance, info);
        }
        if (distance <= info.maxDistance() && info.keepLeashTicks() < info.maxKeepLeashTicks()) {
            entry.setValue(info.resetKeepTicks());
        }
        return pullForce;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    private Vec3 calculatePullForce(@NotNull Vec3 holderPos, Vec3 entityPos, double distance, @NotNull ILeashData.LeashInfo info) {
        Vec3 pullDirection = holderPos.m_82546_(entityPos).m_82541_();
        double pullStrength = 0.2;
        if (distance > info.maxDistance()) {
            double excessRatio = (distance - info.maxDistance()) / info.maxDistance();
            pullStrength += excessRatio * 0.8;
        }
        Vec3 pullForce = pullDirection.m_82490_((distance - info.elasticDistance()) * pullStrength * CommonEventHandler.leashConfigManager.getSpringDampening());
        return new Vec3(pullForce.f_82479_ * CommonEventHandler.leashConfigManager.getXElasticity(), pullForce.f_82480_ * CommonEventHandler.leashConfigManager.getXElasticity(), pullForce.f_82481_ * CommonEventHandler.leashConfigManager.getZElasticity());
    }

    @NotNull
    private Vec3 calculateCriticalPullForce(@NotNull Vec3 holderPos, Vec3 entityPos, double distance, @NotNull ILeashData.LeashInfo info) {
        Vec3 pullDirection = holderPos.m_82546_(entityPos).m_82541_();
        double excessRatio = (distance - info.maxDistance()) / info.maxDistance();
        double pullStrength = 1.0 + excessRatio * 2.0;
        Vec3 pullForce = pullDirection.m_82490_((distance - info.elasticDistance()) * pullStrength * CommonEventHandler.leashConfigManager.getSpringDampening());
        return new Vec3(pullForce.f_82479_ * CommonEventHandler.leashConfigManager.getXElasticity(), pullForce.f_82480_ * CommonEventHandler.leashConfigManager.getYElasticity(), pullForce.f_82481_ * CommonEventHandler.leashConfigManager.getZElasticity());
    }

    @Override
    public boolean removeLeash(Entity holder) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.removeLeash(superLeashKnotEntity.m_31748_());
        } else {
            bl = this.removeLeash(holder.m_20148_());
        }
        return bl;
    }

    @Override
    public boolean removeLeash(UUID holderUUID) {
        boolean removed;
        boolean bl = removed = this.leashHolders.remove(holderUUID) != null;
        if (removed) {
            LeashStateAPI.Operations.detach(this.entity, holderUUID);
            this.markForSync();
        }
        return removed;
    }

    @Override
    public boolean removeLeash(BlockPos knotPos) {
        boolean removed;
        boolean bl = removed = this.leashKnots.remove(knotPos) != null;
        if (removed) {
            LeashStateAPI.Operations.detach(this.entity, knotPos);
            this.markForSync();
        }
        return removed;
    }

    @Override
    public void removeAllLeashes() {
        this.leashHolders.clear();
        this.leashKnots.clear();
        LeashStateAPI.Offset.removeHolderAll(this.entity);
        this.markForSync();
    }

    @Override
    public void removeAllHolderLeashes() {
        this.leashHolders.clear();
        LeashStateAPI.Offset.removeAllHolderUUIDs(this.entity);
        this.markForSync();
    }

    @Override
    public void removeAllKnotLeashes() {
        this.leashKnots.clear();
        LeashStateAPI.Offset.removeAllHolderBlockPoses(this.entity);
        this.markForSync();
    }

    @Override
    public boolean transferLeash(Entity holder, Entity newHolder) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.transferLeash(superLeashKnotEntity.m_31748_(), newHolder);
        } else {
            bl = this.transferLeash(holder.m_20148_(), newHolder);
        }
        return bl;
    }

    @Override
    public boolean transferLeash(Entity holder, Entity newHolder, String reserved) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.transferLeash(superLeashKnotEntity.m_31748_(), newHolder, reserved);
        } else {
            bl = this.transferLeash(holder.m_20148_(), newHolder, reserved);
        }
        return bl;
    }

    @Override
    public boolean transferLeash(UUID oldHolderUUID, Entity newHolder) {
        ILeashData.LeashInfo info = this.leashHolders.remove(oldHolderUUID);
        if (info == null || newHolder == null) {
            return false;
        }
        if (newHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)newHolder;
            ILeashData.LeashInfo leashInfo = info.transferHolder((Entity)superLeashKnotEntity);
            this.leashKnots.put(superLeashKnotEntity.m_31748_(), leashInfo);
        } else {
            ILeashData.LeashInfo leashInfo = info.transferHolder(newHolder);
            this.leashHolders.put(newHolder.m_20148_(), leashInfo);
        }
        LeashStateAPI.Operations.transfer(this.entity, oldHolderUUID, newHolder);
        this.markForSync();
        return true;
    }

    @Override
    public boolean transferLeash(UUID oldHolderUUID, Entity newHolder, String reserved) {
        ILeashData.LeashInfo info = this.leashHolders.remove(oldHolderUUID);
        if (info == null || newHolder == null) {
            return false;
        }
        if (newHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)newHolder;
            ILeashData.LeashInfo leashInfo = info.transferHolder((Entity)superLeashKnotEntity, reserved);
            this.leashKnots.put(superLeashKnotEntity.m_31748_(), leashInfo);
        } else {
            ILeashData.LeashInfo leashInfo = info.transferHolder(newHolder, reserved);
            this.leashHolders.put(newHolder.m_20148_(), leashInfo);
        }
        LeashStateAPI.Operations.transfer(this.entity, oldHolderUUID, newHolder);
        this.markForSync();
        return true;
    }

    @Override
    public boolean transferLeash(BlockPos knotPos, Entity newHolder) {
        ILeashData.LeashInfo info = this.leashKnots.remove(knotPos);
        if (info == null || newHolder == null) {
            return false;
        }
        if (newHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)newHolder;
            ILeashData.LeashInfo leashInfo = info.transferHolder((Entity)superLeashKnotEntity);
            this.leashKnots.put(superLeashKnotEntity.m_31748_(), leashInfo);
        } else {
            ILeashData.LeashInfo leashInfo = info.transferHolder(newHolder);
            this.leashHolders.put(newHolder.m_20148_(), leashInfo);
        }
        LeashStateAPI.Operations.transfer(this.entity, knotPos, newHolder);
        this.markForSync();
        return true;
    }

    @Override
    public boolean transferLeash(BlockPos knotPos, Entity newHolder, String reserved) {
        ILeashData.LeashInfo info = this.leashKnots.remove(knotPos);
        if (info == null || newHolder == null) {
            return false;
        }
        if (newHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)newHolder;
            ILeashData.LeashInfo leashInfo = info.transferHolder((Entity)superLeashKnotEntity, reserved);
            this.leashKnots.put(superLeashKnotEntity.m_31748_(), leashInfo);
        } else {
            ILeashData.LeashInfo leashInfo = info.transferHolder(newHolder, reserved);
            this.leashHolders.put(newHolder.m_20148_(), leashInfo);
        }
        LeashStateAPI.Operations.transfer(this.entity, knotPos, newHolder);
        this.markForSync();
        return true;
    }

    @Override
    public boolean hasLeash() {
        return !this.leashKnots.isEmpty() || !this.leashHolders.isEmpty();
    }

    @Override
    public boolean hasKnotLeash() {
        return !this.leashKnots.isEmpty();
    }

    @Override
    public boolean hasHolderLeash() {
        return !this.leashHolders.isEmpty();
    }

    public static boolean isLeashable(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof Boat || entity instanceof AbstractMinecart;
    }

    @Override
    public Collection<ILeashData.LeashInfo> getAllLeashes() {
        return Stream.concat(this.leashHolders.values().stream(), this.leashKnots.values().stream()).collect(Collectors.toList());
    }

    @Override
    public boolean isLeashedBy(Entity holder) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.isLeashedBy(superLeashKnotEntity.m_31748_());
        } else {
            bl = this.isLeashedBy(holder.m_20148_());
        }
        return bl;
    }

    @Override
    public boolean isLeashedBy(UUID holderUUID) {
        return this.leashHolders.containsKey(holderUUID);
    }

    @Override
    public boolean isLeashedBy(BlockPos knotPos) {
        return this.leashKnots.containsKey(knotPos);
    }

    @Override
    public boolean isInDelayedLeash(UUID holderUUID) {
        return this.delayedHolders.contains(holderUUID);
    }

    @Override
    public Optional<ILeashData.LeashInfo> getLeashInfo(Entity holder) {
        Optional<ILeashData.LeashInfo> optional;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            optional = this.getLeashInfo(superLeashKnotEntity.m_31748_());
        } else {
            optional = this.getLeashInfo(holder.m_20148_());
        }
        return optional;
    }

    @Override
    public Optional<ILeashData.LeashInfo> getLeashInfo(UUID holderUUID) {
        return Optional.ofNullable(this.leashHolders.get(holderUUID));
    }

    @Override
    public Optional<ILeashData.LeashInfo> getLeashInfo(BlockPos knotPos) {
        return Optional.ofNullable(this.leashKnots.get(knotPos));
    }

    public CompoundTag serializeNBT() {
        CompoundTag infoTag;
        CompoundTag tag = new CompoundTag();
        ListTag holdersList = new ListTag();
        ListTag delayedHolderList = new ListTag();
        for (ILeashData.LeashInfo info : this.leashHolders.values()) {
            infoTag = LeashDataImpl.generateCompoundTagFromUUIDLeashInfo(info);
            holdersList.add((Object)infoTag);
        }
        for (ILeashData.LeashInfo info : this.leashKnots.values()) {
            infoTag = LeashDataImpl.generateCompoundTagFromBlockPosLeashInfo(info);
            holdersList.add((Object)infoTag);
        }
        for (UUID uuid : this.delayedHolders) {
            infoTag = LeashDataImpl.generateCompoundTagFromUUID(uuid);
            delayedHolderList.add((Object)infoTag);
        }
        tag.m_128365_("LeashHolders", (Tag)holdersList);
        tag.m_128365_("DelayedHolders", (Tag)delayedHolderList);
        return tag;
    }

    @NotNull
    private static CompoundTag generateCompoundTagFromUUID(@NotNull UUID uuid) {
        CompoundTag infoTag = new CompoundTag();
        infoTag.m_128362_("DelayHolderUUID", uuid);
        return infoTag;
    }

    @NotNull
    private static CompoundTag generateCompoundTagFromUUIDLeashInfo(@NotNull ILeashData.LeashInfo info) {
        CompoundTag infoTag = new CompoundTag();
        if (info.holderUUIDOpt().isEmpty()) {
            throw new IllegalArgumentException("LeashInfo.holderUUIDOpt is empty");
        }
        infoTag.m_128362_("HolderUUID", info.holderUUIDOpt().get());
        return LeashDataImpl.getCommonCompoundTag(info, infoTag);
    }

    @NotNull
    private static CompoundTag generateCompoundTagFromBlockPosLeashInfo(@NotNull ILeashData.LeashInfo info) {
        CompoundTag infoTag = new CompoundTag();
        if (info.blockPosOpt().isEmpty()) {
            throw new IllegalArgumentException("LeashInfo.blockPos is empty");
        }
        BlockPos blockPos = info.blockPosOpt().get();
        infoTag.m_128365_("KnotBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        return LeashDataImpl.getCommonCompoundTag(info, infoTag);
    }

    @NotNull
    private static CompoundTag getCommonCompoundTag(@NotNull ILeashData.LeashInfo info, CompoundTag infoTag) {
        if (info.holderIdOpt().isEmpty()) {
            throw new IllegalArgumentException("LeashInfo.intId is empty");
        }
        infoTag.m_128405_("HolderID", info.holderIdOpt().get().intValue());
        infoTag.m_128359_("LeashItem", info.reserved());
        infoTag.m_128347_("MaxDistance", info.maxDistance());
        infoTag.m_128347_("ElasticDistance", info.elasticDistance());
        infoTag.m_128405_("KeepLeashTicks", info.keepLeashTicks());
        infoTag.m_128405_("MaxKeepLeashTicks", info.maxKeepLeashTicks());
        return infoTag;
    }

    public void deserializeNBT(@NotNull CompoundTag nbt) {
        CompoundTag infoTag;
        int i;
        this.leashHolders.clear();
        this.leashKnots.clear();
        this.delayedHolders.clear();
        if (nbt.m_128425_("LeashHolders", 9)) {
            ListTag holdersList = nbt.m_128437_("LeashHolders", 10);
            for (i = 0; i < holdersList.size(); ++i) {
                infoTag = holdersList.m_128728_(i);
                if (infoTag.m_128441_("HolderUUID")) {
                    ILeashData.LeashInfo uuidLeashDataFormListTag = LeashDataImpl.getUUIDLeashDataFormListTag(infoTag);
                    this.leashHolders.put(uuidLeashDataFormListTag.holderUUIDOpt().orElseThrow(), uuidLeashDataFormListTag);
                    continue;
                }
                ILeashData.LeashInfo blockPosLeashDataFormListTag = LeashDataImpl.getBlockPosLeashDataFormListTag(infoTag);
                this.leashKnots.put(blockPosLeashDataFormListTag.blockPosOpt().orElseThrow(), blockPosLeashDataFormListTag);
            }
        }
        if (nbt.m_128425_("DelayedHolders", 9)) {
            ListTag delayedHolderList = nbt.m_128437_("DelayedHolders", 10);
            for (i = 0; i < delayedHolderList.size(); ++i) {
                infoTag = delayedHolderList.m_128728_(i);
                UUID delayedUUIDFormListTag = LeashDataImpl.getDelayedUUIDFormListTag(infoTag);
                this.delayedHolders.add(delayedUUIDFormListTag);
            }
        }
    }

    @NotNull
    private static UUID getDelayedUUIDFormListTag(@NotNull CompoundTag infoTag) {
        if (infoTag.m_128441_("DelayHolderUUID")) {
            return infoTag.m_128342_("DelayHolderUUID");
        }
        throw new IllegalArgumentException("LeashInfo.intId is empty");
    }

    @Contract(value="_ -> new")
    @NotNull
    private static ILeashData.LeashInfo getUUIDLeashDataFormListTag(@NotNull CompoundTag infoTag) {
        if (infoTag.m_128441_("HolderUUID")) {
            return new ILeashData.LeashInfo(infoTag.m_128342_("HolderUUID"), infoTag.m_128451_("HolderID"), infoTag.m_128461_("LeashItem"), infoTag.m_128459_("MaxDistance"), infoTag.m_128441_("ElasticDistance") ? infoTag.m_128459_("ElasticDistance") : 6.0, infoTag.m_128451_("KeepLeashTicks"), infoTag.m_128441_("MaxKeepLeashTicks") ? infoTag.m_128451_("MaxKeepLeashTicks") : 20);
        }
        throw new IllegalArgumentException("Unknown LeashInfo");
    }

    @Contract(value="_ -> new")
    @NotNull
    private static ILeashData.LeashInfo getBlockPosLeashDataFormListTag(@NotNull CompoundTag infoTag) {
        if (infoTag.m_128441_("KnotBlockPos")) {
            return new ILeashData.LeashInfo(NbtUtils.m_129239_((CompoundTag)infoTag.m_128469_("KnotBlockPos")), infoTag.m_128451_("HolderID"), infoTag.m_128461_("LeashItem"), infoTag.m_128459_("MaxDistance"), infoTag.m_128441_("ElasticDistance") ? infoTag.m_128459_("ElasticDistance") : 6.0, infoTag.m_128451_("KeepLeashTicks"), infoTag.m_128441_("MaxKeepLeashTicks") ? infoTag.m_128451_("MaxKeepLeashTicks") : 20);
        }
        throw new IllegalArgumentException("Unknown LeashInfo");
    }

    @Override
    public boolean canBeLeashed() {
        return this.leashHolders.size() + this.leashKnots.size() <= CommonEventHandler.leashConfigManager.getMaxLeashesPerEntity();
    }

    @Override
    public Optional<UUID> occupyLeash() {
        if (this.canBeLeashed() || this.delayedHolders.isEmpty()) {
            return Optional.empty();
        }
        int size = this.delayedHolders.size();
        int index = (int)(Math.random() * (double)size);
        UUID selected = null;
        int i = 0;
        for (UUID uuid : this.delayedHolders) {
            if (i == index) {
                selected = uuid;
                break;
            }
            ++i;
        }
        if (selected != null) {
            this.delayedHolders.remove(selected);
            return Optional.of(selected);
        }
        return Optional.empty();
    }

    @NotNull
    public static List<Entity> leashableInArea(Level pLevel, Vec3 pPos, Predicate<Entity> filter) {
        return LeashDataImpl.leashableInArea(pLevel, pPos, filter, 1024.0);
    }

    @NotNull
    public static List<Entity> leashableInArea(@NotNull Level pLevel, Vec3 pPos, Predicate<Entity> filter, double fetchDistance) {
        AABB box = AABB.m_165882_((Vec3)pPos, (double)fetchDistance, (double)fetchDistance, (double)fetchDistance);
        return pLevel.m_6443_(Entity.class, box, e -> LeashDataImpl.isLeashable(e) && filter.test((Entity)e));
    }

    @NotNull
    public static List<Entity> leashableInArea(@NotNull Entity entity, Predicate<Entity> filter, double fetchDistance) {
        return LeashDataImpl.leashableInArea(entity.m_9236_(), entity.m_20191_().m_82399_(), filter, fetchDistance);
    }

    @NotNull
    public static List<Entity> leashableInArea(Entity entity, Predicate<Entity> filter) {
        return LeashDataImpl.leashableInArea(entity, filter, 1024.0);
    }

    @NotNull
    public static List<Entity> leashableInArea(Entity holder) {
        return LeashDataImpl.leashableInArea(holder, (Entity i) -> LeashDataImpl.isLeashHolder(i, holder), 1024.0);
    }

    @Override
    public boolean canBeAttachedTo(Entity pEntity) {
        if (pEntity == this.entity) {
            return false;
        }
        Optional<ILeashData.LeashInfo> leashInfo = this.getLeashInfo(pEntity);
        return leashInfo.isEmpty() && (double)this.entity.m_20270_(pEntity) <= CommonEventHandler.leashConfigManager.getElasticDistance() * CommonEventHandler.leashConfigManager.getExtremeSnapFactor() && this.canBeLeashed();
    }

    public static boolean isLeashHolder(@NotNull Entity pEntity, Entity pTestHolder) {
        boolean bl;
        if (pTestHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)pTestHolder;
            bl = LeashDataImpl.isLeashHolder(pEntity, superLeashKnotEntity.m_31748_());
        } else {
            bl = LeashDataImpl.isLeashHolder(pEntity, pTestHolder.m_20148_());
        }
        return bl;
    }

    public static boolean isLeashHolder(@NotNull Entity pEntity, UUID pHolderUUID) {
        return LeashDataAPI.getLeashData(pEntity).map(leashData -> leashData.isLeashedBy(pHolderUUID)).orElse(false);
    }

    public static boolean isLeashHolder(@NotNull Entity pEntity, BlockPos pKnotPos) {
        return LeashDataAPI.getLeashData(pEntity).map(leashData -> leashData.isLeashedBy(pKnotPos)).orElse(false);
    }
}

