/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.capability.provider;

import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.content.capability.CapabilityHandler;
import top.r3944realms.superleadrope.content.capability.inter.IEternalPotato;
import top.r3944realms.superleadrope.content.item.EternalPotatoItem;
import top.r3944realms.superleadrope.core.potato.EternalPotatoFacade;

public class EternalPotatoProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final ResourceLocation ETERNAL_POTATO_DATA_REL = new ResourceLocation("superleadrope", "eternal_potato_data");
    private final UUID uuid;
    private volatile IEternalPotato instance;
    private final LazyOptional<IEternalPotato> optional;
    private final ItemStack stack;

    public EternalPotatoProvider(ItemStack stack) {
        this.stack = stack;
        this.uuid = EternalPotatoItem.getOrCreateItemUUID(stack);
        this.instance = null;
        this.optional = LazyOptional.of(this::resolveInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEternalPotato resolveInstance() {
        if (this.instance == null) {
            EternalPotatoProvider eternalPotatoProvider = this;
            synchronized (eternalPotatoProvider) {
                if (this.instance == null) {
                    this.instance = EternalPotatoFacade.getOrCreate(this.uuid);
                    this.instance.bindItemStackSync(() -> {
                        if (!this.stack.m_41619_()) {
                            this.stack.m_41751_(this.instance.serializeNBT());
                        }
                    });
                }
            }
        }
        return this.instance;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.ETERNAL_POTATO_CAP.orEmpty(cap, this.optional);
    }

    public CompoundTag serializeNBT() {
        return this.resolveInstance() != null ? this.resolveInstance().serializeNBT() : new CompoundTag();
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return;
        }
        if (this.instance == null) {
            IEternalPotato shared;
            UUID loaded = compoundTag.m_128403_("item_uuid") ? compoundTag.m_128342_("item_uuid") : UUID.randomUUID();
            this.instance = shared = EternalPotatoFacade.getOrCreate(loaded);
            shared.bindItemStackSync(() -> {
                if (!this.stack.m_41619_()) {
                    this.stack.m_41751_(shared.serializeNBT());
                }
            });
        }
    }
}

