/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.util.capability;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.content.capability.CapabilityHandler;
import top.r3944realms.superleadrope.content.capability.inter.ILeashData;

public final class LeashDataAPI {
    public static Optional<ILeashData> getLeashData(@NotNull Entity entity) {
        Objects.requireNonNull(entity, "Entity cannot be null");
        return entity.getCapability(CapabilityHandler.LEASH_DATA_CAP).resolve();
    }

    public static final class Utils {
        private Utils() {
        }

        public static boolean hasLeashData(Entity entity) {
            return LeashDataAPI.getLeashData(entity).isPresent();
        }
    }

    public static final class ManagementOperations {
        private ManagementOperations() {
        }

        public static Optional<UUID> occupyLeash(Entity entity) {
            return LeashDataAPI.getLeashData(entity).flatMap(ILeashData::occupyLeash);
        }

        public static void markForSync(Entity entity) {
            LeashDataAPI.getLeashData(entity).ifPresent(ILeashData::markForSync);
        }

        public static void immediateSync(Entity entity) {
            LeashDataAPI.getLeashData(entity).ifPresent(ILeashData::immediateSync);
        }

        public static void checkSync(Entity entity) {
            LeashDataAPI.getLeashData(entity).ifPresent(ILeashData::checkSync);
        }
    }

    public static final class QueryOperations {
        private QueryOperations() {
        }

        public static boolean hasLeash(Entity entity) {
            return LeashDataAPI.getLeashData(entity).map(ILeashData::hasLeash).orElse(false);
        }

        public static boolean hasKnotLeash(Entity entity) {
            return LeashDataAPI.getLeashData(entity).map(ILeashData::hasKnotLeash).orElse(false);
        }

        public static boolean hasHolderLeash(Entity entity) {
            return LeashDataAPI.getLeashData(entity).map(ILeashData::hasHolderLeash).orElse(false);
        }

        public static Collection<ILeashData.LeashInfo> getAllLeashes(Entity entity) {
            return LeashDataAPI.getLeashData(entity).map(ILeashData::getAllLeashes).orElse(Collections.emptyList());
        }

        public static boolean isLeashedBy(Entity entity, Entity holder) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.isLeashedBy(holder)).orElse(false);
        }

        public static boolean isLeashedBy(Entity entity, UUID holderUUID) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.isLeashedBy(holderUUID)).orElse(false);
        }

        public static boolean isLeashedBy(Entity entity, BlockPos knotPos) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.isLeashedBy(knotPos)).orElse(false);
        }

        public static boolean isInDelayedLeash(Entity entity, UUID holderUUID) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.isInDelayedLeash(holderUUID)).orElse(false);
        }

        public static Optional<ILeashData.LeashInfo> getLeashInfo(Entity entity, Entity holder) {
            return LeashDataAPI.getLeashData(entity).flatMap(data -> data.getLeashInfo(holder));
        }

        public static Optional<ILeashData.LeashInfo> getLeashInfo(Entity entity, UUID holderUUID) {
            return LeashDataAPI.getLeashData(entity).flatMap(data -> data.getLeashInfo(holderUUID));
        }

        public static Optional<ILeashData.LeashInfo> getLeashInfo(Entity entity, BlockPos knotPos) {
            return LeashDataAPI.getLeashData(entity).flatMap(data -> data.getLeashInfo(knotPos));
        }

        public static boolean canBeLeashed(Entity entity) {
            return LeashDataAPI.getLeashData(entity).map(ILeashData::canBeLeashed).orElse(false);
        }

        public static boolean canBeAttachedTo(Entity entity, Entity target) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.canBeAttachedTo(target)).orElse(false);
        }
    }

    public static final class TransferOperations {
        private TransferOperations() {
        }

        public static boolean transfer(Entity entity, Entity holder, Entity newHolder) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.transferLeash(holder, newHolder)).orElse(false);
        }

        public static boolean transfer(Entity entity, Entity holder, Entity newHolder, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.transferLeash(holder, newHolder, reserved)).orElse(false);
        }

        public static boolean transfer(Entity entity, UUID holderUUID, Entity newHolder) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.transferLeash(holderUUID, newHolder)).orElse(false);
        }

        public static boolean transfer(Entity entity, UUID holderUUID, Entity newHolder, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.transferLeash(holderUUID, newHolder, reserved)).orElse(false);
        }

        public static boolean transfer(Entity entity, BlockPos knotPos, Entity newHolder) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.transferLeash(knotPos, newHolder)).orElse(false);
        }

        public static boolean transfer(Entity entity, BlockPos knotPos, Entity newHolder, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.transferLeash(knotPos, newHolder, reserved)).orElse(false);
        }
    }

    public static final class PhysicsOperations {
        private PhysicsOperations() {
        }

        public static void applyForces(Entity entity) {
            LeashDataAPI.getLeashData(entity).ifPresent(ILeashData::applyLeashForces);
        }
    }

    public static final class PropertyOperations {
        private PropertyOperations() {
        }

        public static boolean setMaxDistance(Entity entity, Entity holder, double distance) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(holder, distance)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, Entity holder, double distance, int maxKeepTicks) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(holder, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, Entity holder, double distance, int maxKeepTicks, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(holder, distance, maxKeepTicks, reserved)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, UUID holderUUID, double distance) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(holderUUID, distance)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, UUID holderUUID, double distance, int maxKeepTicks) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(holderUUID, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, UUID holderUUID, double distance, int maxKeepTicks, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(holderUUID, distance, maxKeepTicks, reserved)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, BlockPos knotPos, double distance) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(knotPos, distance)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, BlockPos knotPos, double distance, int maxKeepTicks) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(knotPos, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, BlockPos knotPos, double distance, int maxKeepTicks, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setMaxDistance(knotPos, distance, maxKeepTicks, reserved)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, Entity holder, double distance) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(holder, distance)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, Entity holder, double distance, int maxKeepTicks) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(holder, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, Entity holder, double distance, int maxKeepTicks, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(holder, distance, maxKeepTicks, reserved)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, UUID holderUUID, double distance) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(holderUUID, distance)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, UUID holderUUID, double distance, int maxKeepTicks) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(holderUUID, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, UUID holderUUID, double distance, int maxKeepTicks, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(holderUUID, distance, maxKeepTicks, reserved)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, BlockPos knotPos, double distance) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(knotPos, distance)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, BlockPos knotPos, double distance, int maxKeepTicks) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(knotPos, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistance(Entity entity, BlockPos knotPos, double distance, int maxKeepTicks, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.setElasticDistance(knotPos, distance, maxKeepTicks, reserved)).orElse(false);
        }
    }

    public static final class LeashOperations {
        private LeashOperations() {
        }

        public static boolean attach(Entity entity, Entity holder) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.addLeash(holder)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.addLeash(holder, reserved)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, double maxDistance) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.addLeash(holder, maxDistance)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, double maxDistance, double elasticDistance, int maxKeepTicks) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.addLeash(holder, maxDistance, elasticDistance, maxKeepTicks)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, double maxDistance, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.addLeash(holder, maxDistance, reserved)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, double maxDistance, double elasticDistance, int maxKeepTicks, String reserved) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.addLeash(holder, maxDistance, elasticDistance, maxKeepTicks, reserved)).orElse(false);
        }

        public static void attachWithInfo(Entity entity, Entity holder, ILeashData.LeashInfo info) {
            LeashDataAPI.getLeashData(entity).ifPresent(data -> data.addLeash(holder, info));
        }

        public static void attachDelayed(Entity entity, Player holderPlayer) {
            LeashDataAPI.getLeashData(entity).ifPresent(data -> data.addDelayedLeash(holderPlayer));
        }

        public static void removeDelayed(Entity entity, UUID onceHolderPlayerUUID) {
            LeashDataAPI.getLeashData(entity).ifPresent(data -> data.removeDelayedLeash(onceHolderPlayerUUID));
        }

        public static boolean detach(Entity entity, Entity holder) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.removeLeash(holder)).orElse(false);
        }

        public static boolean detach(Entity entity, UUID holderUUID) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.removeLeash(holderUUID)).orElse(false);
        }

        public static boolean detach(Entity entity, BlockPos knotPos) {
            return LeashDataAPI.getLeashData(entity).map(data -> data.removeLeash(knotPos)).orElse(false);
        }

        public static void detachAll(Entity entity) {
            LeashDataAPI.getLeashData(entity).ifPresent(ILeashData::removeAllLeashes);
        }

        public static void detachAllHolders(Entity entity) {
            LeashDataAPI.getLeashData(entity).ifPresent(ILeashData::removeAllHolderLeashes);
        }

        public static void detachAllKnots(Entity entity) {
            LeashDataAPI.getLeashData(entity).ifPresent(ILeashData::removeAllKnotLeashes);
        }
    }
}

