/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.config.LeashCommonConfig;
import top.r3944realms.superleadrope.config.LeashConfigManager;
import top.r3944realms.superleadrope.content.capability.CapabilityHandler;
import top.r3944realms.superleadrope.content.capability.CapabilityRemainder;
import top.r3944realms.superleadrope.content.capability.impi.LeashDataImpl;
import top.r3944realms.superleadrope.content.capability.inter.IEternalPotato;
import top.r3944realms.superleadrope.content.capability.inter.ILeashData;
import top.r3944realms.superleadrope.content.capability.inter.ILeashState;
import top.r3944realms.superleadrope.content.command.MotionCommand;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.content.gamerule.server.TeleportWithLeashedEntities;
import top.r3944realms.superleadrope.content.item.EternalPotatoItem;
import top.r3944realms.superleadrope.content.item.SuperLeadRopeItem;
import top.r3944realms.superleadrope.core.leash.LeashInteractHandler;
import top.r3944realms.superleadrope.core.leash.LeashSyncManager;
import top.r3944realms.superleadrope.core.potato.EternalPotatoFacade;
import top.r3944realms.superleadrope.core.register.SLPGameruleRegistry;
import top.r3944realms.superleadrope.core.register.SLPItems;
import top.r3944realms.superleadrope.core.util.PotatoMode;
import top.r3944realms.superleadrope.core.util.PotatoModeHelper;
import top.r3944realms.superleadrope.datagen.data.SLPLangKeyValue;
import top.r3944realms.superleadrope.util.capability.LeashDataAPI;
import top.r3944realms.superleadrope.util.capability.LeashStateAPI;
import top.r3944realms.superleadrope.util.model.RidingRelationship;
import top.r3944realms.superleadrope.util.riding.RidingApplier;
import top.r3944realms.superleadrope.util.riding.RidingDismounts;
import top.r3944realms.superleadrope.util.riding.RidingFinder;
import top.r3944realms.superleadrope.util.riding.RidingSaver;

public class CommonEventHandler {
    public static volatile LeashConfigManager leashConfigManager;

    @Mod.EventBusSubscriber(modid="superleadrope", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Mod {
        @SubscribeEvent
        public static void onFMLCommonInit(FMLCommonSetupEvent event) {
            event.enqueueWork(Mod::checkAndSet);
            event.enqueueWork(SLPGameruleRegistry::register);
        }

        @SubscribeEvent
        public static void registerCapability(RegisterCapabilitiesEvent event) {
            CapabilityHandler.registerCapability(event);
        }

        @SubscribeEvent
        public static void onCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256869_) {
                event.accept(SLPItems.SUPER_LEAD_ROPE);
            }
        }

        @SubscribeEvent
        public void onConfigReloading(ModConfigEvent.Reloading event) {
            if (event.getConfig().getSpec() == LeashCommonConfig.SPEC) {
                SuperLeadRope.logger.debug("Config reloading detected...");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void checkAndSet() {
            if (leashConfigManager != null) return;
            Class<LeashConfigManager> clazz = LeashConfigManager.class;
            synchronized (LeashConfigManager.class) {
                if (leashConfigManager != null) return;
                leashConfigManager = new LeashConfigManager();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        @SubscribeEvent
        public void onConfigLoaded(ModConfigEvent.Loading event) {
            if (event.getConfig().getSpec() == LeashCommonConfig.SPEC) {
                Mod.checkAndSet();
                LeashConfigManager.loading(leashConfigManager);
            }
        }

        @SubscribeEvent
        public void onConfigReloaded(ModConfigEvent.Reloading event) {
            if (event.getConfig().getSpec() == LeashCommonConfig.SPEC) {
                Mod.checkAndSet();
                LeashConfigManager.reloading(leashConfigManager);
            }
        }

        @SubscribeEvent
        public void onConfigUnloaded(ModConfigEvent.Unloading event) {
            if (event.getConfig().getSpec() == LeashCommonConfig.SPEC) {
                LeashConfigManager.unloading(leashConfigManager);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="superleadrope", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Game {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity.m_9236_().f_46443_) {
                return;
            }
            if (entity instanceof LivingEntity || entity instanceof Boat || entity instanceof Minecart) {
                LeashDataAPI.getLeashData(entity).ifPresent(LeashSyncManager.Data::track);
                LeashStateAPI.getLeashState(entity).ifPresent(LeashSyncManager.State::track);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    LeashSyncManager.Data.forEach(i -> {
                        if (i.isLeashedBy((Entity)serverPlayer) && i.isInDelayedLeash(serverPlayer.m_20148_())) {
                            i.removeDelayedLeash(serverPlayer.m_20148_());
                        }
                    });
                }
            }
        }

        @SubscribeEvent
        public static void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity.m_9236_().f_46443_) {
                return;
            }
            if (entity instanceof LivingEntity || entity instanceof Boat || entity instanceof Minecart) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    LeashSyncManager.Data.forEach(i -> {
                        if (i.isLeashedBy((Entity)serverPlayer)) {
                            i.addDelayedLeash((Player)serverPlayer);
                        }
                    });
                }
                LeashDataAPI.getLeashData(entity).ifPresent(LeashSyncManager.Data::untrack);
                LeashStateAPI.getLeashState(entity).ifPresent(LeashSyncManager.State::untrack);
            }
        }

        @SubscribeEvent
        public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            for (ItemStack stack : player2.m_150109_().f_35974_) {
                if (!(stack.m_41720_() instanceof EternalPotatoItem)) continue;
                stack.getCapability(CapabilityHandler.ETERNAL_POTATO_CAP).ifPresent(cap -> {
                    if (cap.getOwnerUUID() != null && cap.getOwnerUUID().equals(player2.m_20148_())) {
                        cap.bindSyncContext((Player)player2);
                        cap.syncToClient((Player)player2);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void onPlayerRightHitOnBlock(PlayerInteractEvent.RightClickBlock event) {
            boolean shouldConsume;
            Level level = event.getLevel();
            BlockPos blockPos = event.getHitVec().m_82425_();
            BlockState blockState = level.m_8055_(blockPos);
            Player player = event.getEntity();
            ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
            if (SuperLeashKnotEntity.isSupportBlock(blockState) && (shouldConsume = SuperLeadRopeItem.bindToBlock(player, level, blockPos, event.getItemStack(), itemInHand.m_150930_((Item)SLPItems.SUPER_LEAD_ROPE.get())))) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onServerStarting(ServerStartingEvent event) {
            PotatoMode mode = PotatoModeHelper.getCurrentMode();
            EternalPotatoFacade.init(mode, true);
        }

        @SubscribeEvent
        public static void onWorldLoad(LevelEvent.Load event) {
            ServerLevel serverLevel;
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
                EternalPotatoFacade.initSavedData(serverLevel);
                RidingSaver.setEntityProvider(arg_0 -> ((ServerLevel)serverLevel).m_8791_(arg_0));
            }
        }

        @SubscribeEvent
        public static void onWorldUnload(LevelEvent.Unload event) {
            ServerLevel serverLevel;
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
                EternalPotatoFacade.clear();
            }
        }

        @SubscribeEvent
        public static void onServerStopping(ServerStoppingEvent event) {
            EternalPotatoFacade.clear();
        }

        @SubscribeEvent
        public static void onItemDrop(ItemTossEvent event) {
            Player player = event.getPlayer();
            ItemEntity entityItem = event.getEntity();
            ItemStack stack = entityItem.m_32055_();
            if (!(stack.m_41720_() instanceof EternalPotatoItem)) {
                return;
            }
            if (player.m_9236_().f_46443_) {
                return;
            }
            UUID uuid = EternalPotatoItem.getOrCreateItemUUID(stack);
            IEternalPotato cap = EternalPotatoFacade.getOrCreate(uuid);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                cap.bindSyncContext((Player)serverPlayer);
            }
            EternalPotatoItem.ensureItemInInventory(player, stack);
            BlockPos spawnPos = entityItem.m_9236_().m_220360_();
            entityItem.m_6034_((double)spawnPos.m_123341_(), -394.0, (double)spawnPos.m_123343_());
            if (cap.getOwnerUUID() != null && cap.getOwnerUUID().equals(player.m_20148_()) && !player.m_150110_().f_35937_) {
                cap.beginInit();
                cap.setPendingPunishments(cap.getPendingPunishments() + 2);
                cap.endInit();
                player.m_213846_((Component)Component.m_237110_((String)SLPLangKeyValue.EP_CANNOT_DROP.getKey(), (Object[])new Object[]{2}));
            }
        }

        @SubscribeEvent
        public static void onItemPickup(@NotNull PlayerEvent.ItemPickupEvent event) {
            Player player = event.getEntity();
            ItemStack stack = event.getStack();
            if (player.m_9236_().f_46443_) {
                return;
            }
            if (!(stack.m_41720_() instanceof EternalPotatoItem)) {
                return;
            }
            if (player.m_150110_().f_35937_) {
                return;
            }
            UUID uuid = EternalPotatoItem.getOrCreateItemUUID(stack);
            IEternalPotato cap = EternalPotatoFacade.getOrCreate(uuid);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                cap.bindSyncContext((Player)serverPlayer);
            }
            if (cap.getOwnerUUID() != null && !cap.getOwnerUUID().equals(player.m_20148_())) {
                player.m_5661_((Component)Component.m_237115_((String)SLPLangKeyValue.EP_PICKUP_NOT_OWNER.getKey()), true);
            }
        }

        @SubscribeEvent
        public static void onEntityTeleport(EntityTeleportEvent event) {
            Entity telEntity = event.getEntity();
            Vec3 targetPos = event.getTarget();
            Level level = telEntity.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            List<Entity> entities = LeashDataImpl.leashableInArea(telEntity);
            if (!SLPGameruleRegistry.getGameruleBoolValue(event.getEntity().m_9236_(), TeleportWithLeashedEntities.ID)) {
                entities.forEach(entity -> LeashDataAPI.LeashOperations.detach(entity, telEntity));
                return;
            }
            for (Entity beLeashedEntity : entities) {
                Pose originalPose = beLeashedEntity.m_20089_();
                boolean originalIsSprinting = beLeashedEntity.m_20142_();
                float originalYaw = beLeashedEntity.m_146908_();
                float originalPitch = beLeashedEntity.m_146909_();
                Vec3 originalDeltaMovement = beLeashedEntity.m_20184_();
                AtomicReference originalLeashInfo = new AtomicReference();
                LeashDataAPI.getLeashData(beLeashedEntity).ifPresent(data -> {
                    originalLeashInfo.set(data.getLeashInfo(telEntity).orElse(null));
                    data.removeLeash(telEntity);
                });
                RidingRelationship originalRidingRelationship = RidingSaver.save(beLeashedEntity, true);
                List<Entity> allPassengers = RidingFinder.getEntityFromRidingShip(originalRidingRelationship, arg_0 -> ((ServerLevel)serverLevel).m_8791_(arg_0));
                RidingDismounts.dismountEntities(allPassengers);
                for (Entity entity2 : allPassengers) {
                    if (entity2.m_9236_() != serverLevel) {
                        entity2.m_264318_(serverLevel, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, Collections.emptySet(), originalYaw, originalPitch);
                        continue;
                    }
                    if (entity2 instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity2;
                        player.f_8906_.m_9780_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, originalYaw, originalPitch, Collections.emptySet());
                        continue;
                    }
                    entity2.m_264318_(serverLevel, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, Collections.emptySet(), originalYaw, originalPitch);
                }
                for (Entity entity2 : allPassengers) {
                    entity2.m_20256_(originalDeltaMovement);
                    entity2.m_6858_(originalIsSprinting);
                    entity2.m_20124_(originalPose);
                }
                ILeashData.LeashInfo leashInfo = Optional.ofNullable((ILeashData.LeashInfo)originalLeashInfo.get()).orElse(ILeashData.LeashInfo.EMPTY);
                LeashDataAPI.LeashOperations.attachWithInfo(beLeashedEntity, telEntity, leashInfo);
                RidingRelationship filteredRelationship = RidingSaver.filterByWhitelistRoot(originalRidingRelationship);
                RidingApplier.applyRidingRelationship(filteredRelationship, arg_0 -> ((ServerLevel)serverLevel).m_8791_(arg_0));
            }
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            CapabilityRemainder.onPlayerClone(event);
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                if (++tickCounter % 10 == 0) {
                    LeashSyncManager.Data.forEach(ILeashData::markForSync);
                    LeashSyncManager.State.forEach(ILeashState::markForSync);
                }
                LeashSyncManager.Data.forEach(ILeashData::checkSync);
                LeashSyncManager.State.forEach(ILeashState::checkSync);
                LeashSyncManager.Data.forEach(ILeashData::applyLeashForces);
            }
        }

        @SubscribeEvent
        public static void onEntityAttack(AttackEntityEvent event) {
            LeashInteractHandler.onEntityLeftInteract(event.getEntity().m_9236_(), event.getTarget(), event.getEntity(), event);
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            LeashInteractHandler.onEntityRightInteract(event.getLevel(), event.getHand(), event.getTarget(), event.getEntity(), event);
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<?> event) {
            CapabilityHandler.attachCapability(event);
        }

        @SubscribeEvent
        public static void onRegisterCommand(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            MotionCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        }
    }
}

