/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.config.LeashCommonConfig;

public class LeashConfigManager {
    private final Map<String, double[]> entityHolderOffsetMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> entityLeashOffsetMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> tagHolderOffsetMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> tagLeashOffsetMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> modHolderOffsetMap = new ConcurrentHashMap<String, double[]>();
    private final Map<String, double[]> modLeashOffsetMap = new ConcurrentHashMap<String, double[]>();
    private volatile List<String> teleportWhitelistCache;
    private volatile String commandPrefixCache;
    private volatile boolean enableCommandPrefixCache;
    private volatile double maxLeashLengthCache;
    private volatile double elasticDistanceCache;
    private volatile double extremeSnapFactorCache;
    private volatile double springDampeningCache;
    private volatile List<Double> axisSpecificElasticityCache;
    private volatile int maxLeashesPerEntityCache;

    public LeashConfigManager() {
        this.reloadAll();
    }

    public void parseOffsetConfig() {
        HashMap<String, double[]> holderEntityMap = new HashMap<String, double[]>();
        HashMap<String, double[]> holderTagMap = new HashMap<String, double[]>();
        HashMap<String, double[]> holderModMap = new HashMap<String, double[]>();
        List holderOffsets = (List)LeashCommonConfig.COMMON.defaultHolderLocationOffset.get();
        for (String offsetConfig : holderOffsets) {
            Matcher matcher = LeashCommonConfig.Common.OFFSET_PATTERN.matcher(offsetConfig);
            if (!matcher.matches()) continue;
            try {
                double x = Double.parseDouble(matcher.group(1).trim());
                double y = Double.parseDouble(matcher.group(2).trim());
                double z = Double.parseDouble(matcher.group(3).trim());
                double[] offset = new double[]{x, y, z};
                String entityList = matcher.group(4);
                for (String entity : entityList.split(",")) {
                    String trimmed = entity.trim();
                    if (trimmed.equals("*")) {
                        holderModMap.put("*", offset);
                        continue;
                    }
                    if (trimmed.startsWith("#")) {
                        String body = trimmed.substring(1).trim();
                        if (body.contains(":")) {
                            holderTagMap.put(body, offset);
                            continue;
                        }
                        holderModMap.put(body, offset);
                        continue;
                    }
                    holderEntityMap.put(trimmed, offset);
                }
            }
            catch (NumberFormatException e) {
                SuperLeadRope.logger.error("Invalid holder offset config: {}", (Object)offsetConfig);
            }
        }
        this.entityHolderOffsetMap.clear();
        this.entityHolderOffsetMap.putAll(holderEntityMap);
        this.tagHolderOffsetMap.clear();
        this.tagHolderOffsetMap.putAll(holderTagMap);
        this.modHolderOffsetMap.clear();
        this.modHolderOffsetMap.putAll(holderModMap);
        HashMap<String, double[]> leashEntityMap = new HashMap<String, double[]>();
        HashMap<String, double[]> leashTagMap = new HashMap<String, double[]>();
        HashMap<String, double[]> leashModMap = new HashMap<String, double[]>();
        List leashOffsets = (List)LeashCommonConfig.COMMON.defaultApplyEntityLocationOffset.get();
        for (String offsetConfig : leashOffsets) {
            Matcher matcher = LeashCommonConfig.Common.OFFSET_PATTERN.matcher(offsetConfig);
            if (!matcher.matches()) continue;
            try {
                double x = Double.parseDouble(matcher.group(1).trim());
                double y = Double.parseDouble(matcher.group(2).trim());
                double z = Double.parseDouble(matcher.group(3).trim());
                double[] offset = new double[]{x, y, z};
                String entityList = matcher.group(4);
                for (String entity : entityList.split(",")) {
                    String trimmed = entity.trim();
                    if (trimmed.equals("*")) {
                        leashModMap.put("*", offset);
                        continue;
                    }
                    if (trimmed.startsWith("#")) {
                        String body = trimmed.substring(1).trim();
                        if (body.contains(":")) {
                            leashTagMap.put(body, offset);
                            continue;
                        }
                        leashModMap.put(body, offset);
                        continue;
                    }
                    leashEntityMap.put(trimmed, offset);
                }
            }
            catch (NumberFormatException e) {
                SuperLeadRope.logger.error("Invalid leash offset config: {}", (Object)offsetConfig);
            }
        }
        this.entityLeashOffsetMap.clear();
        this.entityLeashOffsetMap.putAll(leashEntityMap);
        this.tagLeashOffsetMap.clear();
        this.tagLeashOffsetMap.putAll(leashTagMap);
        this.modLeashOffsetMap.clear();
        this.modLeashOffsetMap.putAll(leashModMap);
    }

    public void reloadAll() {
        this.parseOffsetConfig();
        this.teleportWhitelistCache = new ArrayList<String>((Collection)LeashCommonConfig.COMMON.teleportWhitelist.get());
        this.commandPrefixCache = (String)LeashCommonConfig.COMMON.SLPModCommandPrefix.get();
        this.enableCommandPrefixCache = (Boolean)LeashCommonConfig.COMMON.EnableSLPModCommandPrefix.get();
        this.maxLeashLengthCache = (Double)LeashCommonConfig.COMMON.maxLeashLength.get();
        this.elasticDistanceCache = (Double)LeashCommonConfig.COMMON.elasticDistance.get();
        this.extremeSnapFactorCache = (Double)LeashCommonConfig.COMMON.extremeSnapFactor.get();
        this.springDampeningCache = (Double)LeashCommonConfig.COMMON.springDampening.get();
        this.axisSpecificElasticityCache = new ArrayList<Double>((Collection)LeashCommonConfig.COMMON.axisSpecificElasticity.get());
        this.maxLeashesPerEntityCache = (Integer)LeashCommonConfig.COMMON.maxLeashesPerEntity.get();
        SuperLeadRope.logger.debug("All configs reloaded: {}", (Object)this.getStats());
    }

    public Vec3 getDefaultEntityOffset(EntityType<?> entityType) {
        String entityId = entityType.m_204041_().m_205785_().m_135782_().toString();
        String modId = entityId.split(":")[0];
        ArrayList<String> tagStrings = new ArrayList<String>();
        for (TagKey tag : entityType.m_204041_().m_203616_().toList()) {
            tagStrings.add(tag.f_203868_().toString());
        }
        double[] offset = this.getDefaultEntityOffset(entityId, modId, tagStrings);
        return offset != null ? new Vec3(offset[0], offset[1], offset[2]) : Vec3.f_82478_;
    }

    public Vec3 getDefaultEntityOffset(Entity entity) {
        return this.getDefaultEntityOffset(entity.m_6095_());
    }

    public double[] getDefaultEntityOffset(String entityId, String modId, List<String> tags) {
        if (this.entityLeashOffsetMap.containsKey(entityId)) {
            return this.entityLeashOffsetMap.get(entityId);
        }
        for (String tag : tags) {
            if (!this.tagLeashOffsetMap.containsKey(tag)) continue;
            return this.tagHolderOffsetMap.get(tag);
        }
        if (this.modLeashOffsetMap.containsKey(modId)) {
            return this.modLeashOffsetMap.get(modId);
        }
        if (this.modLeashOffsetMap.containsKey("*")) {
            return this.modLeashOffsetMap.get("*");
        }
        return null;
    }

    public Vec3 getDefaultHolderOffset(EntityType<?> entityType) {
        String entityId = entityType.m_204041_().m_205785_().m_135782_().toString();
        String modId = entityId.split(":")[0];
        ArrayList<String> tagStrings = new ArrayList<String>();
        for (TagKey tag : entityType.m_204041_().m_203616_().toList()) {
            tagStrings.add(tag.f_203868_().toString());
        }
        double[] offset = this.getDefaultHolderOffset(entityId, modId, tagStrings);
        return offset != null ? new Vec3(offset[0], offset[1], offset[2]) : Vec3.f_82478_;
    }

    public Vec3 getDefaultHolderOffset(Entity entity) {
        return this.getDefaultHolderOffset(entity.m_6095_());
    }

    public double[] getDefaultHolderOffset(String entityId, String modId, List<String> tags) {
        if (this.entityHolderOffsetMap.containsKey(entityId)) {
            return this.entityHolderOffsetMap.get(entityId);
        }
        for (String tag : tags) {
            if (!this.tagHolderOffsetMap.containsKey(tag)) continue;
            return this.tagHolderOffsetMap.get(tag);
        }
        if (this.modHolderOffsetMap.containsKey(modId)) {
            return this.modHolderOffsetMap.get(modId);
        }
        if (this.modLeashOffsetMap.containsKey("*")) {
            return this.modHolderOffsetMap.get("*");
        }
        return null;
    }

    public List<String> getTeleportWhitelist() {
        return Collections.unmodifiableList(this.teleportWhitelistCache);
    }

    public boolean isEntityTeleportAllowed(EntityType<?> entityType) {
        String entityId = entityType.m_204041_().m_205785_().m_135782_().toString();
        String modid = entityId.split(":")[0];
        for (String entry : this.teleportWhitelistCache) {
            if (entry.startsWith("#")) {
                String body = entry.substring(1);
                if (!body.contains(":")) {
                    if (!modid.equals(body)) continue;
                    return true;
                }
                ResourceLocation tagId = new ResourceLocation(body);
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagId);
                if (!entityType.m_204041_().m_203656_(tag)) continue;
                return true;
            }
            if (!entry.equals(entityId)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntityTeleportAllowed(String entityId) {
        String modid = entityId.contains(":") ? entityId.split(":")[0] : "minecraft";
        for (String entry : this.teleportWhitelistCache) {
            String body;
            if (!(entry.startsWith("#") ? !(body = entry.substring(1)).contains(":") && modid.equals(body) : entry.equals(entityId))) continue;
            return true;
        }
        return false;
    }

    private boolean matchesTeleportPattern(String pattern, String entityId) {
        if (pattern.startsWith("#")) {
            String body = pattern.substring(1);
            if (body.contains(":")) {
                String patternModId = body.split(":")[0];
                String entityModId = entityId.split(":")[0];
                return entityModId.equals(patternModId);
            }
            String entityModId = entityId.split(":")[0];
            return entityModId.equals(body);
        }
        return entityId.equals(pattern);
    }

    public boolean isEntityTeleportAllowed(Entity entity) {
        return this.isEntityTeleportAllowed(entity.m_6095_());
    }

    public String getCommandPrefix() {
        return this.commandPrefixCache;
    }

    public boolean isCommandPrefixEnabled() {
        return this.enableCommandPrefixCache;
    }

    public String getFullCommand(String subCommand) {
        return this.isCommandPrefixEnabled() ? this.getCommandPrefix() + " " + subCommand : subCommand;
    }

    public double getMaxLeashLength() {
        return this.maxLeashLengthCache;
    }

    public double getElasticDistance() {
        return this.elasticDistanceCache;
    }

    public double getExtremeSnapFactor() {
        return this.extremeSnapFactorCache;
    }

    public double getBreakDistance() {
        return this.getMaxLeashLength() * this.getExtremeSnapFactor();
    }

    public double getSpringDampening() {
        return this.springDampeningCache;
    }

    public List<Double> getAxisSpecificElasticity() {
        return Collections.unmodifiableList(this.axisSpecificElasticityCache);
    }

    public double getXElasticity() {
        return !this.axisSpecificElasticityCache.isEmpty() ? this.axisSpecificElasticityCache.get(0) : 0.8;
    }

    public double getYElasticity() {
        return this.axisSpecificElasticityCache.size() > 1 ? this.axisSpecificElasticityCache.get(1) : 0.2;
    }

    public double getZElasticity() {
        return this.axisSpecificElasticityCache.size() > 2 ? this.axisSpecificElasticityCache.get(2) : 0.8;
    }

    public int getMaxLeashesPerEntity() {
        return this.maxLeashesPerEntityCache;
    }

    public boolean canEntityAcceptMoreLeashes(Entity entity, int currentLeashCount) {
        return currentLeashCount < this.getMaxLeashesPerEntity();
    }

    public void reload() {
        this.reloadAll();
    }

    public void clear() {
        this.entityHolderOffsetMap.clear();
        this.entityLeashOffsetMap.clear();
        this.tagHolderOffsetMap.clear();
        this.tagLeashOffsetMap.clear();
        this.modHolderOffsetMap.clear();
        this.modLeashOffsetMap.clear();
        this.teleportWhitelistCache = Collections.emptyList();
    }

    public String getStats() {
        return String.format("Holder: Entities: %d, Tags: %d, Mods: %d \n Leash: Entities: %d, Tags: %d, Mods: %d, TeleportWhitelist: %d", this.entityHolderOffsetMap.size(), this.tagHolderOffsetMap.size(), this.modHolderOffsetMap.size(), this.entityLeashOffsetMap.size(), this.tagLeashOffsetMap.size(), this.modLeashOffsetMap.size(), this.teleportWhitelistCache.size());
    }

    public static void loading(LeashConfigManager manager) {
        manager.reloadAll();
    }

    public static void reloading(LeashConfigManager manager) {
        manager.reloadAll();
    }

    public static void unloading(LeashConfigManager manager) {
        if (manager != null) {
            manager.clear();
        }
    }
}

