/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.core.leash;

import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import top.r3944realms.superleadrope.content.capability.impi.LeashDataImpl;
import top.r3944realms.superleadrope.content.capability.inter.ILeashData;
import top.r3944realms.superleadrope.content.item.SuperLeadRopeItem;
import top.r3944realms.superleadrope.core.register.SLPItems;
import top.r3944realms.superleadrope.core.register.SLPSoundEvents;
import top.r3944realms.superleadrope.util.capability.LeashDataAPI;

public class LeashInteractHandler {
    public static void onEntityRightInteract(Level level, InteractionHand hand, Entity target, Player player, PlayerInteractEvent.EntityInteract event) {
        if (level.f_46443_) {
            if (hand == InteractionHand.MAIN_HAND && (player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)SLPItems.SUPER_LEAD_ROPE.get()) || player.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)SLPItems.SUPER_LEAD_ROPE.get()))) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return;
        }
        if (!LeashDataImpl.isLeashable(target)) {
            return;
        }
        Optional<ILeashData> LeashCap = LeashDataAPI.getLeashData(target);
        if (LeashCap.isEmpty()) {
            return;
        }
        ItemStack mainHandItem = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandItem = player.m_21120_(InteractionHand.OFF_HAND);
        if (mainHandItem.m_41619_() && offHandItem.m_41619_() && target.m_6084_() && player.m_36341_() && LeashCap.map(ILeashData::canBeLeashed).orElse(false).booleanValue()) {
            boolean isSuccess = SuperLeadRopeItem.bindToEntity(target, player, player.m_9236_(), player.m_20097_());
            if (isSuccess) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        } else {
            if (LeashDataImpl.isLeashHolder(target, (Entity)player)) {
                LeashCap.ifPresent(iLeashDataCapability -> iLeashDataCapability.removeLeash(player.m_20148_()));
                target.m_146852_(GameEvent.f_223708_, (Entity)player);
                level.m_247517_(null, target.m_20097_(), (SoundEvent)SLPSoundEvents.LEAD_UNTIED.get(), SoundSource.PLAYERS);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
            ItemStack itemStack = mainHandItem.m_150930_((Item)SLPItems.SUPER_LEAD_ROPE.get()) && SuperLeadRopeItem.canUse(mainHandItem) ? mainHandItem : (offHandItem.m_150930_((Item)SLPItems.SUPER_LEAD_ROPE.get()) && SuperLeadRopeItem.canUse(offHandItem) ? offHandItem : ItemStack.f_41583_);
            if (!itemStack.m_41619_() && itemStack.m_41720_() == SLPItems.SUPER_LEAD_ROPE.get()) {
                LeashCap.ifPresent(iLeashDataCapability -> {
                    boolean success;
                    if (iLeashDataCapability.canBeAttachedTo((Entity)player) && (success = iLeashDataCapability.addLeash((Entity)player))) {
                        if (!player.m_7500_()) {
                            itemStack.m_41622_(24, (LivingEntity)player, e -> e.m_9236_().m_247517_(null, player.m_20097_(), SoundEvents.f_12018_, SoundSource.PLAYERS));
                        }
                        level.m_247517_(null, target.m_20097_(), (SoundEvent)SLPSoundEvents.LEAD_TIED.get(), SoundSource.PLAYERS);
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                    }
                });
            }
        }
    }

    public static void onEntityLeftInteract(Level level, Entity target, Player player, AttackEntityEvent event) {
        boolean flag;
        boolean bl = flag = LeashDataImpl.isLeashable(target) && player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)SLPItems.SUPER_LEAD_ROPE.get());
        if (level.f_46443_) {
            if (flag) {
                event.setCanceled(true);
            }
        } else if (flag) {
            LeashDataAPI.getLeashData(target).ifPresent(leashDataCapability -> {
                if (leashDataCapability.hasLeash()) {
                    int size = leashDataCapability.getAllLeashes().size();
                    if (player.m_36341_()) {
                        leashDataCapability.removeAllLeashes();
                    } else {
                        leashDataCapability.removeAllKnotLeashes();
                    }
                    if (size > leashDataCapability.getAllLeashes().size()) {
                        level.m_247517_(null, target.m_20097_(), (SoundEvent)SLPSoundEvents.LEAD_UNTIED.get(), SoundSource.PLAYERS);
                    }
                }
                event.setCanceled(true);
            });
        }
    }
}

