/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.core.potato;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.content.capability.impi.EternalPotatoImpl;
import top.r3944realms.superleadrope.content.capability.inter.IEternalPotato;
import top.r3944realms.superleadrope.core.potato.IEternalPotatoManager;

class SyncedEternalPotatoManager
implements IEternalPotatoManager {
    private final Map<UUID, EternalPotatoImpl> GLOBAL_DATA = new ConcurrentHashMap<UUID, EternalPotatoImpl>();
    private final boolean isServer;

    public SyncedEternalPotatoManager(boolean isServer) {
        this.isServer = isServer;
    }

    @Override
    public IEternalPotato getOrCreate(UUID uuid) {
        return this.GLOBAL_DATA.computeIfAbsent(uuid, k -> {
            EternalPotatoImpl impl = new EternalPotatoImpl();
            impl.setItemUUID(uuid);
            return impl;
        });
    }

    @Override
    public void remove(UUID uuid) {
        this.GLOBAL_DATA.remove(uuid);
    }

    @Override
    public void clear() {
        this.GLOBAL_DATA.clear();
    }

    @Override
    public CompoundTag saveAll() {
        if (!this.isServer) {
            return new CompoundTag();
        }
        CompoundTag root = new CompoundTag();
        this.GLOBAL_DATA.forEach((uuid, impl) -> root.m_128365_(uuid.toString(), (Tag)impl.serializeNBT()));
        return root;
    }

    @Override
    public void loadAll(CompoundTag tag) {
        this.GLOBAL_DATA.clear();
        for (String key : tag.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(key);
                EternalPotatoImpl impl = new EternalPotatoImpl();
                impl.deserializeNBT(tag.m_128469_(key));
                impl.setItemUUID(uuid);
                this.GLOBAL_DATA.put(uuid, impl);
            }
            catch (IllegalArgumentException e) {
                SuperLeadRope.logger.error("Could not load UUID: {}", (Object)key, (Object)e);
            }
        }
    }

    public boolean isServer() {
        return this.isServer;
    }
}

