/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.util.riding;

import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import top.r3944realms.superleadrope.CommonEventHandler;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.core.exception.RidingCycleException;
import top.r3944realms.superleadrope.util.model.RidingRelationship;
import top.r3944realms.superleadrope.util.riding.RidingSerializer;
import top.r3944realms.superleadrope.util.riding.RidingValidator;

public class RidingApplier {
    public static int applyRidingRelationship(RidingRelationship relationship, Function<UUID, Entity> entityProvider) {
        if (relationship == null || entityProvider == null) {
            return 0;
        }
        int appliedCount = 0;
        LinkedList<RidingRelationship> queue = new LinkedList<RidingRelationship>();
        queue.offer(relationship);
        while (!queue.isEmpty()) {
            Entity vehicle;
            RidingRelationship current = (RidingRelationship)queue.poll();
            UUID entityId = current.getEntityId();
            UUID vehicleId = current.getVehicleId();
            Entity entity = entityProvider.apply(entityId);
            Entity entity2 = vehicle = vehicleId != null ? entityProvider.apply(vehicleId) : null;
            if (entity == null) continue;
            if (!CommonEventHandler.leashConfigManager.isEntityTeleportAllowed(entity)) {
                if (vehicle == null) continue;
                for (RidingRelationship child : current.getPassengers()) {
                    child.setVehicleId(vehicle.m_20148_());
                    queue.offer(child);
                }
                continue;
            }
            ++appliedCount;
            if (entity.m_20202_() != null) {
                entity.m_8127_();
            }
            if (vehicle != null && CommonEventHandler.leashConfigManager.isEntityTeleportAllowed(vehicle)) {
                if (RidingValidator.wouldCreateCycle(entity, vehicle)) {
                    throw new RidingCycleException(entityId, vehicleId);
                }
                boolean success = entity.m_7998_(vehicle, true);
                if (!success) {
                    SuperLeadRope.logger.error("Failed to mount entity {} to vehicle {}", (Object)entityId, (Object)vehicleId);
                }
            }
            queue.addAll(current.getPassengers());
        }
        return appliedCount;
    }

    public static void applyRidingRelationships(Collection<RidingRelationship> relationships, Function<UUID, Entity> entityProvider) {
        if (relationships == null || relationships.isEmpty()) {
            return;
        }
        for (RidingRelationship relationship : relationships) {
            try {
                RidingApplier.applyRidingRelationship(relationship, entityProvider);
            }
            catch (RidingCycleException e) {
                SuperLeadRope.logger.warn("Cyclic riding reference detected and skipped: {}", (Object)e.getMessage());
            }
        }
    }

    public static int applyRidingRelationshipFromJson(String json, Function<UUID, Entity> entityProvider) {
        RidingRelationship relationship = RidingSerializer.deserialize(json);
        return RidingApplier.applyRidingRelationship(relationship, entityProvider);
    }
}

