/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.util.riding;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.CommonEventHandler;
import top.r3944realms.superleadrope.network.NetworkHandler;
import top.r3944realms.superleadrope.network.toClient.UpdatePlayerMovementPacket;
import top.r3944realms.superleadrope.util.riding.RidingDismounts;
import top.r3944realms.superleadrope.util.riding.RidingFinder;

public class RindingLeash {
    @Nullable
    public static Entity getSafeWhitelistRoot(Entity entity) {
        if (entity == null) {
            return null;
        }
        Entity root = RidingFinder.findRootVehicle(entity);
        if (root == null) {
            return null;
        }
        for (Entity current = root; current != null; current = current.m_20202_()) {
            if (!CommonEventHandler.leashConfigManager.isEntityTeleportAllowed(current.m_6095_())) continue;
            return current;
        }
        return null;
    }

    public static Entity getFinalEntityForLeashIfForce(Entity entity, boolean hasForce) {
        if (!hasForce || entity == null) {
            return entity;
        }
        Entity root = RidingFinder.findRootVehicle(entity);
        if (root == null) {
            return entity;
        }
        for (Entity current = root; current != null; current = current.m_20202_()) {
            if (!CommonEventHandler.leashConfigManager.isEntityTeleportAllowed(current.m_6095_())) continue;
            return current;
        }
        RidingDismounts.dismountRootEntity(entity);
        return entity;
    }

    public static void protectAnimalMovement(Entity entity, boolean hasLeash) {
        if (entity instanceof Animal) {
            Animal mob = (Animal)entity;
            if (hasLeash) {
                mob.f_21345_.m_25355_(Goal.Flag.MOVE);
                entity.m_183634_();
            } else {
                mob.f_21345_.m_25374_(Goal.Flag.MOVE);
            }
        }
    }

    public static void applyForceToPlayer(ServerPlayer player, Vec3 force) {
        NetworkHandler.sendToPlayer(new UpdatePlayerMovementPacket(UpdatePlayerMovementPacket.Operation.ADD, force), player);
    }
}

