/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.api.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.api.type.capabilty.LeashHolder;
import top.r3944realms.superleadrope.api.type.capabilty.LeashInfo;

public abstract class SuperLeadRopeEvent
extends Event
implements IModBusEvent {
    private final Entity LeashedEntity;
    protected boolean hasModified;

    public boolean isModified() {
        return this.hasModified;
    }

    public void markModified() {
        this.hasModified = true;
    }

    protected SuperLeadRopeEvent(Entity leashedEntity) {
        this.LeashedEntity = leashedEntity;
    }

    public Entity getLeashedEntity() {
        return this.LeashedEntity;
    }

    @Cancelable
    public static class teleportWithHolder
    extends SuperLeadRopeEvent {
        private final Entity holderEntity;
        private final Level originalLevel;
        private final Level newLevel;
        private final Vec3 originalPosition;
        private final Vec3 newPosition;

        public teleportWithHolder(Entity leashedEntity, Entity holderEntity, Level originalLevel, Level newLevel, Vec3 originalPosition, Vec3 newPosition) {
            super(leashedEntity);
            this.holderEntity = holderEntity;
            this.originalLevel = originalLevel;
            this.newLevel = newLevel;
            this.originalPosition = originalPosition;
            this.newPosition = newPosition;
        }

        public Entity getHolderEntity() {
            return this.holderEntity;
        }

        public Vec3 getOriginalPosition() {
            return this.originalPosition;
        }

        public Level getOriginalLevel() {
            return this.originalLevel;
        }

        public Level getNewLevel() {
            return this.newLevel;
        }

        public Vec3 getNewPosition() {
            return this.newPosition;
        }
    }

    public static class keepNotBreakTick
    extends SuperLeadRopeEvent {
        private final int remainedTicks;
        private final Entity holderEntity;
        private final Map.Entry<?, LeashInfo> entry;

        public keepNotBreakTick(Entity leashedEntity, int remainedTicks, Entity holderEntity, Map.Entry<?, LeashInfo> entry) {
            super(leashedEntity);
            this.remainedTicks = remainedTicks;
            this.holderEntity = holderEntity;
            this.entry = entry;
        }

        public Entity getHolderEntity() {
            return this.holderEntity;
        }

        public int getRemainedTicks() {
            return this.remainedTicks;
        }

        public void resetRemainedTicks() {
            this.entry.setValue(this.entry.getValue().resetKeepTicks());
        }

        public int getMaxKeepTicks() {
            return this.entry.getValue().maxKeepLeashTicks();
        }
    }

    @Cancelable
    public static class hasFocus
    extends SuperLeadRopeEvent {
        private final Map<UUID, LeashInfo> vaildLeashHolders;
        private final Map<BlockPos, LeashInfo> vaildLeashKnots;
        private final Entity finalForceTarget;
        private Vec3 combinedForce;

        public hasFocus(Entity leashedEntity, Entity finalForceTarget, Vec3 combinedForce, Map<UUID, LeashInfo> vaildLeashHolders, Map<BlockPos, LeashInfo> vaildLeashKnots) {
            super(leashedEntity);
            this.finalForceTarget = finalForceTarget;
            this.combinedForce = combinedForce;
            this.vaildLeashHolders = new HashMap<UUID, LeashInfo>(vaildLeashHolders);
            this.vaildLeashKnots = new HashMap<BlockPos, LeashInfo>(vaildLeashKnots);
        }

        public Entity getFinalForceTarget() {
            return this.finalForceTarget;
        }

        public Vec3 getCombinedForce() {
            return this.combinedForce;
        }

        public void setCombinedForce(Vec3 combinedForce) {
            this.markModified();
            this.combinedForce = combinedForce;
        }

        public Map<UUID, LeashInfo> getVaildLeashHolders() {
            return this.vaildLeashHolders;
        }

        public Map<BlockPos, LeashInfo> getVaildLeashKnots() {
            return this.vaildLeashKnots;
        }
    }

    @Cancelable
    public static class ModifyValue<T>
    extends SuperLeadRopeEvent {
        @Nullable
        private final LeashHolder holder;
        @Nullable
        private final T oldValue;
        @Nullable
        private T newValue;
        private final Type type;
        private final Scope scope;

        public ModifyValue(Entity leashedEntity, UUID holderUUID, @Nullable T oldValue, @Nullable T newValue, Type type) {
            super(leashedEntity);
            this.holder = new LeashHolder(holderUUID);
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.type = type;
            this.scope = Scope.INSTANCE;
        }

        public ModifyValue(Entity leashedEntity, BlockPos knotBlockpos, @Nullable T oldValue, @Nullable T newValue, Type type) {
            super(leashedEntity);
            this.holder = new LeashHolder(knotBlockpos);
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.type = type;
            this.scope = Scope.INSTANCE;
        }

        public ModifyValue(Entity leashedEntity, @Nullable T oldValue, @Nullable T newValue, Type type) {
            super(leashedEntity);
            this.holder = null;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.type = type;
            this.scope = Scope.STATIC;
        }

        public <R> R getOldValueAs(Class<R> clazz) {
            if (clazz.isInstance(this.oldValue)) {
                return (R)this.oldValue;
            }
            return null;
        }

        public <R> R getNewValueAs(Class<R> clazz) {
            if (clazz.isInstance(this.newValue)) {
                return (R)this.newValue;
            }
            return null;
        }

        public T getOldValue() {
            return (T)this.getOldValueAs(this.type.valueType);
        }

        public T getNewValue() {
            return (T)this.getNewValueAs(this.type.valueType);
        }

        public void setNewValue(@Nullable T newValue) {
            if (newValue != null && !this.type.valueType.isInstance(newValue)) {
                throw new IllegalArgumentException("Expected value of type " + this.type.valueType + ", but got " + newValue.getClass());
            }
            this.markModified();
            this.newValue = newValue;
        }

        public static enum Type {
            MAX_DISTANCE(Double.class),
            ELASTIC_DISTANCE_SCALE(Double.class),
            MAX_KEEP_LEASH_TICKS(Integer.class),
            CUSTOM_DATA(String.class);

            private final Class<?> valueType;

            private Type(Class<?> valueType) {
                this.valueType = valueType;
            }

            public Class<?> getValueType() {
                return this.valueType;
            }
        }

        public static enum Scope {
            INSTANCE,
            STATIC;

        }
    }

    @Cancelable
    public static class TransferLeash
    extends SuperLeadRopeEvent {
        private final LeashHolder oldLeashHolder;
        private final Entity newLeashHolder;
        private int maxKeepLeashTicks;

        public TransferLeash(Entity leashedEntity, UUID holderEntity, Entity newLeashHolder, int maxKeepLeashTicks) {
            this(leashedEntity, holderEntity, null, false, newLeashHolder, maxKeepLeashTicks);
        }

        public TransferLeash(Entity leashedEntity, BlockPos holderKnot, Entity newLeashHolder, int maxKeepLeashTicks) {
            this(leashedEntity, null, holderKnot, true, newLeashHolder, maxKeepLeashTicks);
        }

        private TransferLeash(Entity leashedEntity, @Nullable UUID holderEntity, @Nullable BlockPos holderPos, boolean isSuperLeadRopeKnot, Entity newLeashHolder, int maxKeepLeashTicks) {
            super(leashedEntity);
            this.oldLeashHolder = isSuperLeadRopeKnot ? new LeashHolder(holderPos) : new LeashHolder(holderEntity);
            this.newLeashHolder = newLeashHolder;
            this.maxKeepLeashTicks = maxKeepLeashTicks;
        }

        public Entity getNewLeashHolder() {
            return this.newLeashHolder;
        }

        public LeashHolder getOldLeashHolder() {
            return this.oldLeashHolder;
        }

        public void setMaxKeepLeashTicks(int maxKeepLeashTicks) {
            if (maxKeepLeashTicks < 0) {
                return;
            }
            this.markModified();
            this.maxKeepLeashTicks = maxKeepLeashTicks;
        }

        public int getMaxKeepLeashTicks() {
            return this.maxKeepLeashTicks;
        }
    }

    @Cancelable
    public static class RemoveLeash
    extends SuperLeadRopeEvent {
        private final LeashHolder leashHolder;

        public RemoveLeash(Entity leashedEntity, UUID holderEntity) {
            this(leashedEntity, holderEntity, null, false);
        }

        public RemoveLeash(Entity leashedEntity, BlockPos holderKnot) {
            this(leashedEntity, null, holderKnot, true);
        }

        private RemoveLeash(Entity leashedEntity, @Nullable UUID holderEntity, @Nullable BlockPos holderPos, boolean isSuperLeadRopeKnot) {
            super(leashedEntity);
            this.leashHolder = isSuperLeadRopeKnot ? new LeashHolder(holderPos) : new LeashHolder(holderEntity);
        }

        public LeashHolder getLeashHolder() {
            return this.leashHolder;
        }
    }

    @Cancelable
    public static class AddLeash
    extends SuperLeadRopeEvent {
        private final Entity holderEntity;
        @Nullable
        private Double maxLeashDistance;
        @Nullable
        private Double elasticDistanceScale;
        private int maxKeepLeashTicks;

        public AddLeash(Entity leashedEntity, Entity holderEntity, int maxKeepLeashTicks) {
            this(leashedEntity, holderEntity, null, null, maxKeepLeashTicks);
        }

        public AddLeash(Entity leashedEntity, Entity holderEntity, @Nullable Double maxLeashDistance, @Nullable Double elasticDistanceScale, int maxKeepLeashTicks) {
            super(leashedEntity);
            this.holderEntity = holderEntity;
            this.maxLeashDistance = maxLeashDistance;
            this.elasticDistanceScale = elasticDistanceScale;
            this.maxKeepLeashTicks = maxKeepLeashTicks;
        }

        public void setElasticDistanceScale(@Nullable Double elasticDistanceScale) {
            this.markModified();
            this.elasticDistanceScale = elasticDistanceScale;
        }

        public void setMaxLeashDistance(@Nullable Double maxLeashDistance) {
            this.markModified();
            this.maxLeashDistance = maxLeashDistance;
        }

        public void setMaxKeepLeashTicks(int maxKeepLeashTicks) {
            if (maxKeepLeashTicks < 0) {
                return;
            }
            this.markModified();
            this.maxKeepLeashTicks = maxKeepLeashTicks;
        }

        public int getMaxKeepLeashTicks() {
            return this.maxKeepLeashTicks;
        }

        public Entity getHolderEntity() {
            return this.holderEntity;
        }

        @Nullable
        public Double getMaxLeashDistance() {
            return this.maxLeashDistance;
        }

        @Nullable
        public Double getElasticDistanceScale() {
            return this.elasticDistanceScale;
        }
    }
}

