/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.api.type.capabilty;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import top.r3944realms.superleadrope.api.SuperLeadRopeApi;

public record LeashInfo(Optional<BlockPos> blockPosOpt, Optional<UUID> holderUUIDOpt, Optional<Integer> holderIdOpt, Set<String> marks, String reserved, Double maxDistance, Double elasticDistanceScale, int keepLeashTicks, int maxKeepLeashTicks) {
    public static final String MARK_NOT_UPDATE = "NOT_UPDATE";
    public static final String MARK_ONLY_NOT_UPDATE_MAX_DISTANCE = "NOT_UPDATE_MAX_DISTANCE";
    public static final String MARK_ONLY_NOT_UPDATE_ELASTIC_DISTANCE_SCALE = "NOT_UPDATE_ELASTIC_DISTANCE_SCALE";
    public static final LeashInfo EMPTY = new LeashInfo(Optional.empty(), Optional.empty(), Optional.empty(), Set.of(), "", 12.0, 6.0, 0, 0);

    public LeashInfo(UUID holderUUID, int holderId, String reserved, Double maxDistance, Double elasticDistanceScale, int keepTicks, int maxKeepTicks) {
        this(Optional.empty(), Optional.of(holderUUID), Optional.of(holderId), Set.of(), reserved, maxDistance, elasticDistanceScale, keepTicks, maxKeepTicks);
    }

    public LeashInfo(UUID holderUUID, int holderId, Set<String> marks, String reserved, Double maxDistance, Double elasticDistanceScale, int keepTicks, int maxKeepTicks) {
        this(Optional.empty(), Optional.of(holderUUID), Optional.of(holderId), marks, reserved, maxDistance, elasticDistanceScale, keepTicks, maxKeepTicks);
    }

    public LeashInfo(BlockPos knotPos, int holderId, String reserved, Double maxDistance, Double elasticDistanceScale, int keepTicks, int maxKeepTicks) {
        this(Optional.of(knotPos), Optional.empty(), Optional.of(holderId), Set.of(), reserved, maxDistance, elasticDistanceScale, keepTicks, maxKeepTicks);
    }

    public LeashInfo(BlockPos knotPos, int holderId, Set<String> marks, String reserved, Double maxDistance, Double elasticDistanceScale, int keepTicks, int maxKeepTicks) {
        this(Optional.of(knotPos), Optional.empty(), Optional.of(holderId), marks, reserved, maxDistance, elasticDistanceScale, keepTicks, maxKeepTicks);
    }

    public static LeashInfo create(Entity entity, Set<String> marks, String reserved, Double maxDistance, Double elasticDistanceScale, int keepTicks, int maxKeepTicks) {
        return SuperLeadRopeApi.isSuperLeadKnot(entity) ? new LeashInfo(SuperLeadRopeApi.getSuperLeadKnotPos(entity), entity.m_19879_(), marks, reserved, maxDistance, elasticDistanceScale, keepTicks, maxKeepTicks) : new LeashInfo(entity.m_20148_(), entity.m_19879_(), marks, reserved, maxDistance, elasticDistanceScale, keepTicks, maxKeepTicks);
    }

    public static LeashInfo create(Entity entity, String reserved, Double maxDistance, Double elasticDistanceScale, int keepTicks, int maxKeepTicks) {
        return LeashInfo.create(entity, Set.of(), reserved, maxDistance, elasticDistanceScale, keepTicks, maxKeepTicks);
    }

    public LeashInfo decrementKeepTicks() {
        return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, this.marks, this.reserved, this.maxDistance, this.elasticDistanceScale, Math.max(0, this.keepLeashTicks - 1), this.maxKeepLeashTicks);
    }

    public LeashInfo resetKeepTicks() {
        return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, this.marks, this.reserved, this.maxDistance, this.elasticDistanceScale, this.maxKeepLeashTicks, this.maxKeepLeashTicks);
    }

    public LeashInfo transferHolder(Entity entity) {
        return this.transferHolder(entity, this.reserved);
    }

    public LeashInfo transferHolder(Entity entity, String newReserved) {
        boolean isKnot = SuperLeadRopeApi.isSuperLeadKnot(entity);
        return new LeashInfo(isKnot ? Optional.of(SuperLeadRopeApi.getSuperLeadKnotPos(entity)) : Optional.empty(), !isKnot ? Optional.of(entity.m_20148_()) : Optional.empty(), Optional.of(entity.m_19879_()), this.marks, newReserved, this.maxDistance, this.elasticDistanceScale, this.maxKeepLeashTicks, this.maxKeepLeashTicks);
    }

    public LeashInfo transferHolder(Entity entity, int maxKeepLeashTicks) {
        return this.transferHolder(entity, maxKeepLeashTicks, this.reserved);
    }

    public LeashInfo transferHolder(Entity entity, int maxKeepLeashTicks, String newReserved) {
        boolean isKnot = SuperLeadRopeApi.isSuperLeadKnot(entity);
        return new LeashInfo(isKnot ? Optional.of(SuperLeadRopeApi.getSuperLeadKnotPos(entity)) : Optional.empty(), !isKnot ? Optional.of(entity.m_20148_()) : Optional.empty(), Optional.of(entity.m_19879_()), this.marks, newReserved, this.maxDistance, this.elasticDistanceScale, maxKeepLeashTicks, maxKeepLeashTicks);
    }

    public LeashInfo withReserved(String newReserved) {
        return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, this.marks, newReserved, this.maxDistance, this.elasticDistanceScale, this.keepLeashTicks, this.maxKeepLeashTicks);
    }

    public LeashInfo withMarks(Set<String> newMarks) {
        return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, Set.copyOf(newMarks), this.reserved, this.maxDistance, this.elasticDistanceScale, this.keepLeashTicks, this.maxKeepLeashTicks);
    }

    public LeashInfo markNotUpdate() {
        return this.hasMark(MARK_NOT_UPDATE) ? this : this.addMark(MARK_NOT_UPDATE);
    }

    public LeashInfo markNotUpdateDistance() {
        if (this.hasMark(MARK_NOT_UPDATE)) {
            return this;
        }
        if (this.hasMark(MARK_ONLY_NOT_UPDATE_MAX_DISTANCE)) {
            return this;
        }
        if (this.hasMark(MARK_ONLY_NOT_UPDATE_ELASTIC_DISTANCE_SCALE)) {
            return this.removeMark(MARK_ONLY_NOT_UPDATE_ELASTIC_DISTANCE_SCALE).addMark(MARK_NOT_UPDATE);
        }
        return this.addMark(MARK_ONLY_NOT_UPDATE_MAX_DISTANCE);
    }

    public LeashInfo markNotUpdateScale() {
        if (this.hasMark(MARK_NOT_UPDATE)) {
            return this;
        }
        if (this.hasMark(MARK_ONLY_NOT_UPDATE_ELASTIC_DISTANCE_SCALE)) {
            return this;
        }
        if (this.hasMark(MARK_ONLY_NOT_UPDATE_MAX_DISTANCE)) {
            return this.removeMark(MARK_ONLY_NOT_UPDATE_MAX_DISTANCE).addMark(MARK_NOT_UPDATE);
        }
        return this.addMark(MARK_ONLY_NOT_UPDATE_ELASTIC_DISTANCE_SCALE);
    }

    public LeashInfo unmarkNotUpdate() {
        return this.removeMarks(MARK_NOT_UPDATE, MARK_ONLY_NOT_UPDATE_MAX_DISTANCE, MARK_ONLY_NOT_UPDATE_ELASTIC_DISTANCE_SCALE);
    }

    public LeashInfo unmarkNotUpdateDistance() {
        return this.removeMarks(MARK_NOT_UPDATE, MARK_ONLY_NOT_UPDATE_MAX_DISTANCE);
    }

    public LeashInfo unmarkNotUpdateScale() {
        return this.removeMarks(MARK_NOT_UPDATE, MARK_ONLY_NOT_UPDATE_ELASTIC_DISTANCE_SCALE);
    }

    public boolean isNotUpdate() {
        return this.hasMark(MARK_NOT_UPDATE);
    }

    public boolean isNeedUpdateDistance() {
        return !this.isNotUpdate() && !this.hasMark(MARK_ONLY_NOT_UPDATE_MAX_DISTANCE);
    }

    public boolean isNeedUpdateScale() {
        return !this.isNotUpdate() && !this.hasMark(MARK_ONLY_NOT_UPDATE_ELASTIC_DISTANCE_SCALE);
    }

    public LeashInfo addMark(String mark) {
        if (this.marks.contains(mark)) {
            return this;
        }
        HashSet<String> newMarks = new HashSet<String>(this.marks);
        newMarks.add(mark);
        return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, newMarks, this.reserved, this.maxDistance, this.elasticDistanceScale, this.keepLeashTicks, this.maxKeepLeashTicks);
    }

    public LeashInfo addMarks(String ... marksToAdd) {
        HashSet<String> newMarks = new HashSet<String>(this.marks);
        boolean changed = false;
        for (String mark : marksToAdd) {
            if (!newMarks.add(mark)) continue;
            changed = true;
        }
        return changed ? new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, newMarks, this.reserved, this.maxDistance, this.elasticDistanceScale, this.keepLeashTicks, this.maxKeepLeashTicks) : this;
    }

    public LeashInfo addMarks(@NotNull Collection<String> marksToAdd) {
        return this.addMarks(marksToAdd.toArray(new String[0]));
    }

    public LeashInfo removeMark(String mark) {
        if (!this.marks.contains(mark)) {
            return this;
        }
        HashSet<String> newMarks = new HashSet<String>(this.marks);
        newMarks.remove(mark);
        return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, newMarks, this.reserved, this.maxDistance, this.elasticDistanceScale, this.keepLeashTicks, this.maxKeepLeashTicks);
    }

    public LeashInfo removeMarks(String ... marksToRemove) {
        HashSet<String> newMarks = new HashSet<String>(this.marks);
        boolean changed = false;
        for (String mark : marksToRemove) {
            if (!newMarks.remove(mark)) continue;
            changed = true;
        }
        return changed ? new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, newMarks, this.reserved, this.maxDistance, this.elasticDistanceScale, this.keepLeashTicks, this.maxKeepLeashTicks) : this;
    }

    public LeashInfo removeMarks(@NotNull Collection<String> marksToRemove) {
        return this.removeMarks(marksToRemove.toArray(new String[0]));
    }

    public boolean hasMark(String mark) {
        return this.marks.contains(mark);
    }

    @Contract(pure=true)
    public boolean hasAllMarks(String ... marksToCheck) {
        for (String mark : marksToCheck) {
            if (this.marks.contains(mark)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public boolean hasAnyMark(String ... marksToCheck) {
        for (String mark : marksToCheck) {
            if (!this.marks.contains(mark)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public @Unmodifiable Set<String> getMarks() {
        return Set.copyOf(this.marks);
    }

    public LeashInfo clearAllMarks() {
        if (this.marks.isEmpty()) {
            return this;
        }
        return new LeashInfo(this.blockPosOpt, this.holderUUIDOpt, this.holderIdOpt, Set.of(), this.reserved, this.maxDistance, this.elasticDistanceScale, this.keepLeashTicks, this.maxKeepLeashTicks);
    }
}

