/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.client;

import java.io.IOException;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import top.r3944realms.superleadrope.client.model.SuperLeashKnotModel;
import top.r3944realms.superleadrope.client.model.geom.SLPModelLayers;
import top.r3944realms.superleadrope.client.renderer.LeashRenderHandler;
import top.r3944realms.superleadrope.client.renderer.SLPShaderRegistry;
import top.r3944realms.superleadrope.client.renderer.entity.SuperLeashKnotRenderer;
import top.r3944realms.superleadrope.core.potato.EternalPotatoFacade;
import top.r3944realms.superleadrope.core.register.SLPEntityTypes;
import top.r3944realms.superleadrope.core.register.SLPItems;
import top.r3944realms.superleadrope.core.util.PotatoMode;
import top.r3944realms.superleadrope.core.util.PotatoModeHelper;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {

    @Mod.EventBusSubscriber(modid="superleadrope", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Mod {
        @SubscribeEvent
        public static void onClientInitializer(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemProperties.register((Item)((Item)SLPItems.SUPER_LEAD_ROPE.get()), (ResourceLocation)new ResourceLocation("superleadrope", "broken"), (itemStack, clientLevel, livingEntity, i) -> {
                    if (!itemStack.m_41763_()) {
                        return 0.0f;
                    }
                    return itemStack.m_41773_() > 991 ? 1.0f : 0.0f;
                });
                PotatoMode mode = PotatoModeHelper.getCurrentMode();
                EternalPotatoFacade.init(mode, false);
            });
        }

        @SubscribeEvent
        public static void onRegisterModelLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(SLPModelLayers.SUPER_LEASH_KNOT, SuperLeashKnotModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void onRegisterRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)SLPEntityTypes.SUPER_LEAD_KNOT.get(), SuperLeashKnotRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterShaders(RegisterShadersEvent event) throws IOException {
            SLPShaderRegistry.registerShaders(event);
        }
    }

    @Mod.EventBusSubscriber(modid="superleadrope", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Game {
        @SubscribeEvent
        public static void onLevelRenderer(RenderLevelStageEvent event) {
            if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                return;
            }
            LeashRenderHandler.onRenderLevelStage(event.getPoseStack(), event.getPartialTick());
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
            EternalPotatoFacade.clear();
        }
    }
}

