/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.api.type.capabilty.LeashInfo;
import top.r3944realms.superleadrope.client.renderer.SuperLeashRenderer;
import top.r3944realms.superleadrope.client.renderer.resolver.SuperLeashStateResolver;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.util.capability.LeashDataInnerAPI;

public class LeashRenderHandler {
    public static void onRenderLevelStage(PoseStack poseStack, float partialTick) {
        LeashRenderHandler.renderAllCustomLeashes(poseStack, partialTick);
    }

    private static void renderAllCustomLeashes(PoseStack poseStack, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Entity cameraEntity = minecraft.m_91288_();
        if (level == null || cameraEntity == null) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        for (Entity entity : level.m_45976_(Entity.class, cameraEntity.m_20191_().m_82400_(512.0))) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(leashData -> {
                for (LeashInfo leashInfo : leashData.getAllLeashes()) {
                    LeashRenderHandler.renderLeashFromInfo(entity, leashInfo, poseStack, (MultiBufferSource)bufferSource, partialTick);
                }
            });
        }
    }

    private static void renderLeashFromInfo(Entity entity, LeashInfo leashInfo, PoseStack poseStack, MultiBufferSource bufferSource, float partialTick) {
        try {
            Optional<Entity> holderOpt = LeashRenderHandler.getHolderFromLeashInfo(entity.m_9236_(), leashInfo);
            if (holderOpt.isEmpty()) {
                return;
            }
            Entity holder = holderOpt.get();
            SuperLeashStateResolver.resolve(holder, entity, leashInfo, partialTick).ifPresent(leashRenderState -> SuperLeashRenderer.renderLeash(leashRenderState, poseStack, bufferSource));
        }
        catch (Exception e) {
            SuperLeadRope.logger.error("Failed to render leash", (Throwable)e);
        }
    }

    private static Optional<Entity> getHolderFromLeashInfo(Level level, LeashInfo leashInfo) {
        if (leashInfo.blockPosOpt().isPresent()) {
            BlockPos pos = leashInfo.blockPosOpt().get();
            return SuperLeashKnotEntity.get(level, pos).map(Entity.class::cast);
        }
        if (leashInfo.holderUUIDOpt().isPresent()) {
            UUID holderUUID = leashInfo.holderUUIDOpt().get();
            for (Entity e : ((ClientLevel)level).m_104735_()) {
                if (!e.m_20148_().equals(holderUUID)) continue;
                return Optional.of(e);
            }
        }
        return Optional.empty();
    }
}

