/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.client.renderer.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashData;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashState;
import top.r3944realms.superleadrope.api.type.capabilty.LeashInfo;
import top.r3944realms.superleadrope.client.renderer.state.SuperLeashRenderState;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.util.capability.LeashDataInnerAPI;
import top.r3944realms.superleadrope.util.capability.LeashStateInnerAPI;

public class SuperLeashStateResolver {
    private static final float MAX_TENSION = 1.5f;
    private static final float THICKNESS_BASE = 0.1f;
    private static final float THICKNESS_TENSION = 0.15f;
    private static final Map<UUID, FrameCache> frameCacheMap = new HashMap<UUID, FrameCache>();

    public static Optional<SuperLeashRenderState> resolve(Entity holder, Entity leashedEntity, LeashInfo leashInfo, float partialTicks) {
        Vec3 currentHolderPos;
        boolean isFirstPerson;
        if (holder == null || leashedEntity == null) {
            return Optional.empty();
        }
        Optional<ILeashState> leashedEntityStateOpt = LeashStateInnerAPI.getLeashState(leashedEntity);
        if (leashedEntityStateOpt.isEmpty()) {
            return Optional.empty();
        }
        ILeashData leashData = LeashDataInnerAPI.getLeashData(leashedEntity).orElse(null);
        ILeashState leashedEntityState = leashedEntityStateOpt.get();
        Optional<ILeashState.LeashState> leashStateOpt = leashedEntityState.getLeashState(holder);
        if (leashStateOpt.isEmpty()) {
            return Optional.empty();
        }
        ILeashState.LeashState leashState = leashStateOpt.get();
        Vec3 currentEntityOffset = SuperLeashStateResolver.getEntityLeashOffset(leashedEntity, leashState);
        Vec3 holderOffset = SuperLeashStateResolver.getHolderOffset(holder, leashState);
        boolean bl = isFirstPerson = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
        if (holder instanceof Player) {
            Player player = (Player)holder;
            currentHolderPos = isFirstPerson && player == Minecraft.m_91087_().f_91074_ ? SuperLeashStateResolver.getFirstPersonLeashPos(player, partialTicks) : SuperLeashStateResolver.getEntityLeashHolderPos((Entity)player, Minecraft.m_91087_().f_91074_ == holder ? holderOffset : holderOffset.m_82520_(0.0, 0.0, 0.4), partialTicks);
        } else {
            currentHolderPos = holder instanceof SuperLeashKnotEntity ? SuperLeashStateResolver.getInterpolatedPosition(holder, partialTicks) : SuperLeashStateResolver.getEntityLeashHolderPos(holder, holderOffset, partialTicks);
        }
        Vec3 currentEntityPos = SuperLeashStateResolver.applyOffsetWithRotation(leashedEntity, currentEntityOffset, partialTicks);
        FrameCache cache = frameCacheMap.get(leashedEntity.m_20148_());
        Vec3 lastHolderPos = cache != null ? cache.lastStartPos() : currentHolderPos;
        Vec3 lastEntityPos = cache != null ? cache.lastEndPos() : currentEntityPos;
        float lastAngle = cache != null ? cache.lastSwingAngle() : 0.0f;
        float lastSpeed = cache != null ? cache.lastSwingSpeed() : 0.0f;
        double distance = currentHolderPos.m_82554_(currentEntityPos);
        double maxDistance = 6.0;
        double elasticDistanceScale = 1.0;
        if (leashData != null) {
            maxDistance = leashInfo.maxDistance() == null ? leashData.getCurrentMaxDistance() : leashInfo.maxDistance().doubleValue();
            elasticDistanceScale = leashInfo.elasticDistanceScale() == null ? leashData.getCurrentElasticDistanceScale() : leashInfo.elasticDistanceScale().doubleValue();
        }
        float tension = SuperLeashStateResolver.calculateTension(distance, maxDistance, elasticDistanceScale);
        float stretchRatio = (float)(distance / maxDistance);
        boolean isCritical = distance > maxDistance * elasticDistanceScale * 1.5;
        SwingDynamics swing = SuperLeashStateResolver.calculateSwingDynamics(currentHolderPos, currentEntityPos, lastHolderPos, lastEntityPos, lastAngle, lastSpeed, tension);
        frameCacheMap.put(leashedEntity.m_20148_(), new FrameCache(currentHolderPos, currentEntityPos, swing.angle(), swing.speed()));
        return Optional.of(new SuperLeashRenderState(currentHolderPos, currentEntityPos, lastHolderPos, lastEntityPos, tension, stretchRatio, isCritical, leashInfo.keepLeashTicks(), SuperLeashStateResolver.selectColor(tension, isCritical), 0.1f + tension * 0.15f, swing.angle(), swing.speed(), maxDistance, isFirstPerson, holder.m_20183_()));
    }

    @NotNull
    private static Vec3 getEntityLeashOffset(Entity entity, @NotNull ILeashState.LeashState leashState) {
        Optional<ILeashState> entityStateOpt = LeashStateInnerAPI.getLeashState(entity);
        Vec3 baseOffset = entityStateOpt.map(eState -> eState.getLeashApplyEntityLocationOffset().orElse(eState.getDefaultLeashApplyEntityLocationOffset())).orElse(Vec3.f_82478_);
        return baseOffset.m_82549_(leashState.applyEntityLocationOffset());
    }

    private static Vec3 getHolderOffset(Entity holder, ILeashState.LeashState leashState) {
        Optional<ILeashState> holderStateOpt;
        if (LeashStateInnerAPI.Query.hasLeashState(holder) && (holderStateOpt = LeashStateInnerAPI.getLeashState(holder)).isPresent()) {
            ILeashState holderState = holderStateOpt.get();
            return holderState.getLeashApplyEntityLocationOffset().orElse(holderState.getDefaultLeashApplyEntityLocationOffset());
        }
        return Optional.ofNullable(leashState.holderLocationOffset()).orElse(leashState.defaultHolderLocationOffset());
    }

    @NotNull
    public static Vec3 applyOffsetWithRotation(Entity entity, Vec3 localOffset, float partialTicks) {
        Player player;
        Vec3 centerPos = SuperLeashStateResolver.getInterpolatedPosition(entity, partialTicks);
        float yaw = Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.f_19859_) * ((float)Math.PI / 180);
        float roll = 0.0f;
        if (entity instanceof Player && ((player = (Player)entity).m_21255_() || player.m_21209_())) {
            roll = SuperLeashStateResolver.getRoll(player, partialTicks, roll);
        }
        boolean isFirstPerson = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
        Vec3 rotatedOffset = localOffset;
        if (!isFirstPerson && entity instanceof Player) {
            rotatedOffset = rotatedOffset.m_82520_(0.0, 0.0, 0.2);
        }
        rotatedOffset = rotatedOffset.m_82524_(-yaw).m_82535_(-roll);
        return centerPos.m_82549_(rotatedOffset);
    }

    @NotNull
    private static Vec3 getFirstPersonLeashPos(@NotNull Player player, float partialTicks) {
        float yaw = Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()) * ((float)Math.PI / 180);
        float roll = 0.0f;
        if (player.m_21255_() || player.m_21209_()) {
            roll = SuperLeashStateResolver.getRoll(player, partialTicks, roll);
        }
        double side = player.m_5737_() == HumanoidArm.RIGHT ? -1.0 : 1.0;
        Vec3 localPos = new Vec3(0.39 * side, -0.6, -0.5);
        Vec3 rotatedPos = localPos.m_82524_(-yaw).m_82535_(-roll);
        return player.m_20299_(partialTicks).m_82549_(rotatedPos);
    }

    private static float getRoll(@NotNull Player player, float partialTicks, float roll) {
        Vec3 view = player.m_20252_(partialTicks);
        Vec3 motion = player.m_20184_();
        double motionLenSq = motion.m_165925_();
        double viewLenSq = view.m_165925_();
        if (motionLenSq > 0.0 && viewLenSq > 0.0) {
            double dot = (motion.f_82479_ * view.f_82479_ + motion.f_82481_ * view.f_82481_) / Math.sqrt(motionLenSq * viewLenSq);
            double cross = motion.f_82479_ * view.f_82481_ - motion.f_82481_ * view.f_82479_;
            roll = (float)(Math.signum(cross) * Math.acos(dot));
        }
        return roll;
    }

    public static Vec3 getEntityLeashHolderPos(Entity entity, Vec3 baseOffset, float partialTicks) {
        Vec3 pos = entity.m_20299_(partialTicks);
        double xOffset = baseOffset.m_7096_();
        double yOffset = baseOffset.m_7098_();
        double zOffset = baseOffset.m_7094_();
        float yaw = Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.f_19859_) * ((float)Math.PI / 180);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            xOffset += 0.19 * (player.m_5737_() == HumanoidArm.RIGHT ? -1.0 : 1.0);
        }
        pos = pos.m_82549_(new Vec3(xOffset, yOffset, zOffset).m_82524_(-yaw));
        return pos;
    }

    private static Vec3 getInterpolatedPosition(Entity entity, float partialTicks) {
        return entity.m_20299_(partialTicks);
    }

    private static SwingDynamics calculateSwingDynamics(Vec3 currentStart, Vec3 currentEnd, Vec3 lastStart, Vec3 lastEnd, float lastAngle, float lastSpeed, float tension) {
        Vec3 currentDir = currentEnd.m_82546_(currentStart).m_82541_();
        Vec3 lastDir = lastEnd.m_82546_(lastStart).m_82541_();
        Vec3 cross = lastDir.m_82537_(currentDir);
        float angleChange = (float)Math.acos(Math.min(1.0, lastDir.m_82526_(currentDir)));
        float newSpeed = lastSpeed * 0.9f + (angleChange *= (float)Math.signum(cross.f_82480_)) * 0.5f * tension;
        float newAngle = lastAngle + newSpeed;
        if (tension > 0.3f) {
            newSpeed += (float)((Math.random() - 0.5) * 0.05 * (double)tension);
        }
        return new SwingDynamics(newAngle, newSpeed);
    }

    private static float calculateTension(double distance, double maxDistance, double elasticDistanceScale) {
        double elasticDistance = maxDistance * elasticDistanceScale;
        if (distance <= elasticDistance) {
            return 0.0f;
        }
        double ratio = (distance - elasticDistance) / elasticDistance;
        return SuperLeashStateResolver.easeOutQuad(Math.min((float)ratio, 1.5f));
    }

    private static float easeOutQuad(float x) {
        return 1.0f - (1.0f - x) * (1.0f - x);
    }

    private static int selectColor(float tension, boolean isCritical) {
        if (isCritical) {
            return -5227986;
        }
        return tension > 0.7f ? -2514842 : -9744850;
    }

    private record FrameCache(Vec3 lastStartPos, Vec3 lastEndPos, float lastSwingAngle, float lastSwingSpeed) {
    }

    private record SwingDynamics(float angle, float speed) {
    }
}

