/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.capability.impi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.CommonEventHandler;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.api.event.SuperLeadRopeEvent;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashData;
import top.r3944realms.superleadrope.api.type.capabilty.LeashInfo;
import top.r3944realms.superleadrope.compat.CurtainCompat;
import top.r3944realms.superleadrope.config.LeashConfigManager;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.core.register.SLPSoundEvents;
import top.r3944realms.superleadrope.network.NetworkHandler;
import top.r3944realms.superleadrope.network.toClient.LeashDataSyncPacket;
import top.r3944realms.superleadrope.util.capability.LeashStateInnerAPI;
import top.r3944realms.superleadrope.util.riding.RindingLeash;

public class LeashDataImpl
implements ILeashData {
    private final Entity entity;
    private boolean needsSync = false;
    private long lastSyncTime;
    @Nullable
    private Double staticMaxDistance;
    private double defaultMaxDistance = 6.0;
    @Nullable
    private Double staticElasticDistanceScale;
    private double defaultElasticDistanceScale = 1.0;
    private final Set<UUID> delayedHolders = new CopyOnWriteArraySet<UUID>();
    private final Map<UUID, LeashInfo> leashHolders = new ConcurrentHashMap<UUID, LeashInfo>();
    private final Map<BlockPos, LeashInfo> leashKnots = new ConcurrentHashMap<BlockPos, LeashInfo>();

    public LeashDataImpl(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void markForSync() {
        if (!this.entity.m_9236_().f_46443_) {
            this.needsSync = true;
            this.immediateSync();
        }
    }

    @Override
    public void immediateSync() {
        this.syncNow();
    }

    @Override
    public void checkSync() {
        if (!this.needsSync || this.entity.m_9236_().f_46443_) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSyncTime > 2000L) {
            this.syncNow();
        }
    }

    private void syncNow() {
        CompoundTag currentData = this.serializeNBT();
        NetworkHandler.sendToPlayer(new LeashDataSyncPacket(this.entity.m_19879_(), currentData), this.entity, PacketDistributor.TRACKING_ENTITY_AND_SELF);
        this.lastSyncTime = System.currentTimeMillis();
        this.needsSync = false;
    }

    @Override
    public Entity self() {
        return this.entity;
    }

    @Override
    @Nullable
    public Double getStaticMaxDistance() {
        return this.staticMaxDistance;
    }

    @Override
    public void setStaticMaxDistance(@Nullable Double distance) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(distance)) {
            return;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, this.getStaticMaxDistance(), distance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return;
        }
        this.staticMaxDistance = distance;
    }

    @Override
    public double getDefaultMaxDistance() {
        boolean isNotClient;
        boolean bl = isNotClient = !this.entity.m_9236_().m_5776_();
        if (isNotClient) {
            this.defaultMaxDistance = CommonEventHandler.leashConfigManager.getMaxLeashLength();
        }
        return this.defaultMaxDistance;
    }

    @Override
    public double getCurrentMaxDistance() {
        return this.staticMaxDistance != null ? this.staticMaxDistance : this.defaultMaxDistance;
    }

    @Override
    public void updateAllMaxDistance() {
        this.leashHolders.forEach((uuid, leashInfo) -> {
            if (leashInfo.isNeedUpdateDistance()) {
                this.setMaxDistanceInner((UUID)uuid, (Double)this.getCurrentMaxDistance());
            }
        });
        this.leashKnots.forEach((blockPos, leashInfo) -> {
            if (leashInfo.isNeedUpdateDistance()) {
                this.setMaxDistanceInner((BlockPos)blockPos, (Double)this.getCurrentMaxDistance());
            }
        });
        this.markForSync();
    }

    @Override
    @Nullable
    public Double getStaticElasticDistanceScale() {
        return this.staticElasticDistanceScale;
    }

    @Override
    public void setStaticElasticDistanceScale(@Nullable Double scale) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, this.getStaticElasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return;
        }
        this.staticElasticDistanceScale = scale;
    }

    @Override
    public double getDefaultElasticDistanceScale() {
        boolean isNotClient;
        boolean bl = isNotClient = !this.entity.m_9236_().m_5776_();
        if (isNotClient) {
            this.defaultElasticDistanceScale = CommonEventHandler.leashConfigManager.getElasticDistanceScale();
        }
        return this.defaultElasticDistanceScale;
    }

    @Override
    public double getCurrentElasticDistanceScale() {
        return this.staticElasticDistanceScale != null ? this.staticElasticDistanceScale : this.defaultElasticDistanceScale;
    }

    @Override
    public void updateAllElasticDistanceScale() {
        this.leashHolders.forEach((uuid, leashInfo) -> {
            if (leashInfo.isNeedUpdateScale()) {
                this.setElasticDistanceScaleInner((UUID)uuid, (Double)this.getCurrentElasticDistanceScale());
            }
        });
        this.leashKnots.forEach((blockPos, leashInfo) -> {
            if (leashInfo.isNeedUpdateScale()) {
                this.setElasticDistanceScaleInner((BlockPos)blockPos, (Double)this.getCurrentMaxDistance());
            }
        });
        this.markForSync();
    }

    @Override
    public boolean addLeash(Entity holder) {
        return this.addLeash(holder, (Double)null);
    }

    @Override
    public boolean addLeash(Entity holder, String reserved) {
        return this.addLeash(holder, null, reserved);
    }

    @Override
    public boolean addLeash(Entity holder, Double maxDistance) {
        return this.addLeash(holder, maxDistance, null, 0, "");
    }

    @Override
    public boolean addLeash(Entity holder, Double maxDistance, Double elasticDistanceScale) {
        return this.addLeash(holder, maxDistance, elasticDistanceScale, 0);
    }

    @Override
    public boolean addLeash(Entity holder, Double maxDistance, Double elasticDistanceScale, int maxKeepLeashTicks) {
        return this.addLeash(holder, maxDistance, elasticDistanceScale, maxKeepLeashTicks, "");
    }

    @Override
    public boolean addLeash(Entity holder, Double maxDistance, Double elasticDistanceScale, String reserved) {
        return this.addLeash(holder, maxDistance, elasticDistanceScale, 0, reserved);
    }

    @Override
    public boolean addLeash(Entity holder, Double maxDistance, String reserved) {
        return this.addLeash(holder, maxDistance, null, 0, reserved);
    }

    @Override
    public boolean addLeash(Entity holder, Double maxDistance, Double elasticDistanceScale, int maxKeepLeashTicks, String reserved) {
        if (holder == this.entity) {
            return false;
        }
        boolean isSuperKnot = holder instanceof SuperLeashKnotEntity;
        if (!isSuperKnot && this.leashHolders.containsKey(holder.m_20148_()) || isSuperKnot && this.leashKnots.containsKey(((SuperLeashKnotEntity)holder).m_31748_())) {
            return false;
        }
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(maxDistance) || !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(elasticDistanceScale)) {
            return false;
        }
        SuperLeadRopeEvent.AddLeash event = new SuperLeadRopeEvent.AddLeash(this.entity, holder, maxDistance, elasticDistanceScale, maxKeepLeashTicks);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.isModified() && (!LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getMaxLeashDistance()) || !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getElasticDistanceScale()))) {
            return false;
        }
        if (!this.canBeLeashed()) {
            Optional<UUID> uuidOptional = this.occupyLeash();
            if (uuidOptional.isEmpty()) {
                return false;
            }
            this.removeLeash(uuidOptional.get());
        }
        LeashInfo info = LeashInfo.create(holder, reserved, event.getMaxLeashDistance(), event.getElasticDistanceScale(), event.getMaxKeepLeashTicks(), maxKeepLeashTicks);
        if (isSuperKnot) {
            this.leashKnots.put(((SuperLeashKnotEntity)holder).m_31748_(), info);
        } else {
            this.leashHolders.put(holder.m_20148_(), info);
        }
        LeashStateInnerAPI.Offset.setHolderFor(this.entity, holder);
        this.markForSync();
        return true;
    }

    @Override
    public void addLeash(Entity holder, @NotNull LeashInfo leashInfo) {
        this.addLeash(holder, leashInfo.maxDistance(), leashInfo.elasticDistanceScale(), leashInfo.maxKeepLeashTicks(), leashInfo.reserved());
    }

    @Override
    public void addDelayedLeash(@NotNull Player holderPlayer) {
        this.delayedHolders.add(holderPlayer.m_20148_());
    }

    @Override
    public void removeDelayedLeash(UUID onceHolderUUID) {
        this.delayedHolders.remove(onceHolderUUID);
    }

    private <K> boolean updateLeashInfo(@NotNull Map<K, LeashInfo> map, K key, Function<LeashInfo, LeashInfo> updater) {
        LeashInfo old = map.get(key);
        if (old == null || old.holderIdOpt().isEmpty()) {
            return false;
        }
        LeashInfo updated = updater.apply(old);
        if (updated == null) {
            return false;
        }
        map.put(key, updated);
        this.markForSync();
        return true;
    }

    private <K> void updateLeashInfoInner(@NotNull Map<K, LeashInfo> map, K key, Function<LeashInfo, LeashInfo> updater) {
        LeashInfo old = map.get(key);
        if (old == null || old.holderIdOpt().isEmpty()) {
            return;
        }
        LeashInfo updated = updater.apply(old);
        if (updated == null) {
            return;
        }
        map.put(key, updated);
    }

    @Override
    public boolean setMaxDistance(Entity holder, @Nullable Double newMaxDistance) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setMaxDistance(superLeashKnotEntity.m_31748_(), newMaxDistance);
        } else {
            bl = this.setMaxDistance(holder.m_20148_(), newMaxDistance);
        }
        return bl;
    }

    @Override
    public boolean setMaxDistance(Entity holder, Double distance, String reserved) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setMaxDistance(superLeashKnotEntity.m_31748_(), distance, reserved);
        } else {
            bl = this.setMaxDistance(holder.m_20148_(), distance, reserved);
        }
        return bl;
    }

    @Override
    public boolean setMaxDistance(Entity holder, @Nullable Double newMaxDistance, int newMaxKeepLeashTicks) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setMaxDistance(superLeashKnotEntity.m_31748_(), newMaxDistance, newMaxKeepLeashTicks);
        } else {
            bl = this.setMaxDistance(holder.m_20148_(), newMaxDistance, newMaxKeepLeashTicks);
        }
        return bl;
    }

    @Override
    public boolean setMaxDistance(Entity holder, @Nullable Double newMaxDistance, int maxKeepTicks, String reserved) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setMaxDistance(superLeashKnotEntity.m_31748_(), newMaxDistance, maxKeepTicks, reserved);
        } else {
            bl = this.setMaxDistance(holder.m_20148_(), newMaxDistance, maxKeepTicks, reserved);
        }
        return bl;
    }

    @Override
    public boolean setMaxDistance(UUID holderUUID, @Nullable Double newMaxDistance) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), (Double)event.getNewValue(), old.elasticDistanceScale(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setMaxDistance(UUID holderUUID, Double newMaxDistance, String reserved) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), reserved, (Double)event.getNewValue(), old.elasticDistanceScale(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    public void setMaxDistanceInner(UUID holderUUID, @Nullable Double newMaxDistance) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return;
        }
        this.updateLeashInfoInner(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), (Double)event.getNewValue(), old.elasticDistanceScale(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setMaxDistance(UUID holderUUID, @Nullable Double newMaxDistance, int newMaxKeepLeashTicks) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), (Double)event.getNewValue(), old.elasticDistanceScale(), Math.min(old.keepLeashTicks(), newMaxKeepLeashTicks), newMaxKeepLeashTicks));
    }

    @Override
    public boolean setMaxDistance(UUID holderUUID, @Nullable Double newMaxDistance, int maxKeepTicks, String reserved) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), reserved, (Double)event.getNewValue(), old.elasticDistanceScale(), Math.min(old.keepLeashTicks(), maxKeepTicks), maxKeepTicks));
    }

    @Override
    public boolean setMaxDistance(BlockPos knotPos, @Nullable Double newMaxDistance) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), (Double)event.getNewValue(), old.elasticDistanceScale(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setMaxDistance(BlockPos knotPos, Double newMaxDistance, String reserved) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), reserved, (Double)event.getNewValue(), old.elasticDistanceScale(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    public void setMaxDistanceInner(BlockPos knotPos, @Nullable Double newMaxDistance) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return;
        }
        this.updateLeashInfoInner(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), (Double)event.getNewValue(), old.elasticDistanceScale(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setMaxDistance(BlockPos knotPos, @Nullable Double newMaxDistance, int newMaxKeepLeashTicks) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), (Double)event.getNewValue(), old.elasticDistanceScale(), Math.min(old.keepLeashTicks(), newMaxKeepLeashTicks), newMaxKeepLeashTicks));
    }

    @Override
    public boolean setMaxDistance(BlockPos knotPos, @Nullable Double newMaxDistance, int maxKeepTicks, String reserved) {
        if (!LeashConfigManager.MAX_DISTANCE_CHECK.test(newMaxDistance)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).maxDistance(), newMaxDistance, SuperLeadRopeEvent.ModifyValue.Type.MAX_DISTANCE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.MAX_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), reserved, (Double)event.getNewValue(), old.elasticDistanceScale(), Math.min(old.keepLeashTicks(), maxKeepTicks), maxKeepTicks));
    }

    @Override
    public boolean setElasticDistanceScale(Entity holder, @Nullable Double scale) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setElasticDistanceScale(superLeashKnotEntity.m_31748_(), scale);
        } else {
            bl = this.setElasticDistanceScale(holder.m_20148_(), scale);
        }
        return bl;
    }

    @Override
    public boolean setElasticDistanceScale(UUID holderUUID, @Nullable Double scale) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).elasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), old.maxDistance(), (Double)event.getNewValue(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    public void setElasticDistanceScaleInner(UUID holderUUID, @Nullable Double scale) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).elasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return;
        }
        this.updateLeashInfoInner(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), old.maxDistance(), (Double)event.getNewValue(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setElasticDistanceScale(BlockPos knotPos, @Nullable Double scale) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).elasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), old.maxDistance(), (Double)event.getNewValue(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    public void setElasticDistanceScaleInner(BlockPos knotPos, @Nullable Double scale) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).elasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return;
        }
        this.updateLeashInfoInner(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), old.maxDistance(), (Double)event.getNewValue(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setElasticDistanceScale(Entity holder, @Nullable Double scale, int newMaxKeepLeashTicks) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setElasticDistanceScale(superLeashKnotEntity.m_31748_(), scale, newMaxKeepLeashTicks);
        } else {
            bl = this.setElasticDistanceScale(holder.m_20148_(), scale, newMaxKeepLeashTicks);
        }
        return bl;
    }

    @Override
    public boolean setElasticDistanceScale(Entity holder, @Nullable Double scale, int maxKeepTicks, String reserved) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setElasticDistanceScale(superLeashKnotEntity.m_31748_(), scale, maxKeepTicks, reserved);
        } else {
            bl = this.setElasticDistanceScale(holder.m_20148_(), scale, maxKeepTicks, reserved);
        }
        return bl;
    }

    @Override
    public boolean setElasticDistanceScale(UUID holderUUID, @Nullable Double scale, int newMaxKeepLeashTicks) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).elasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), old.maxDistance(), (Double)event.getNewValue(), Math.min(old.keepLeashTicks(), newMaxKeepLeashTicks), newMaxKeepLeashTicks));
    }

    @Override
    public boolean setElasticDistanceScale(UUID holderUUID, @Nullable Double scale, int maxKeepTicks, String reserved) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, holderUUID, this.leashHolders.get(holderUUID).elasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), reserved, old.maxDistance(), (Double)event.getNewValue(), Math.min(old.keepLeashTicks(), maxKeepTicks), maxKeepTicks));
    }

    @Override
    public boolean setElasticDistanceScale(BlockPos knotPos, @Nullable Double scale, int newMaxKeepLeashTicks) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).elasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), old.maxDistance(), (Double)event.getNewValue(), old.keepLeashTicks(), old.maxKeepLeashTicks()));
    }

    @Override
    public boolean setElasticDistanceScale(BlockPos knotPos, @Nullable Double scale, int newMaxKeepLeashTicks, String reserved) {
        if (!LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(scale)) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Double> event = new SuperLeadRopeEvent.ModifyValue<Double>(this.entity, knotPos, this.leashKnots.get(knotPos).elasticDistanceScale(), scale, SuperLeadRopeEvent.ModifyValue.Type.ELASTIC_DISTANCE_SCALE);
        if (MinecraftForge.EVENT_BUS.post(event) || event.isModified() && !LeashConfigManager.ELASTIC_DISTANCE_CHECK.test(event.getNewValue())) {
            return false;
        }
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new LeashInfo(old.blockPosOpt().get(), (int)old.holderIdOpt().get(), old.marks(), reserved, old.maxDistance(), (Double)event.getNewValue(), Math.min(old.keepLeashTicks(), newMaxKeepLeashTicks), newMaxKeepLeashTicks));
    }

    @Override
    public void applyLeashForces() {
        Vec3 force;
        Vec3 combinedForce = Vec3.f_82478_;
        Vec3 combinedDirection = Vec3.f_82478_;
        int validLeashes = 0;
        HashMap<UUID, LeashInfo> vaildLeashHolders = new HashMap<UUID, LeashInfo>();
        HashMap<BlockPos, LeashInfo> vaildLeashKnots = new HashMap<BlockPos, LeashInfo>();
        for (Map.Entry<UUID, LeashInfo> entry : this.leashHolders.entrySet()) {
            force = this.calculateLeashForceForUUID(entry);
            if (force == null) continue;
            combinedForce = combinedForce.m_82549_(force);
            combinedDirection = combinedDirection.m_82549_(force.m_82541_());
            ++validLeashes;
            vaildLeashHolders.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<UUID, LeashInfo> entry : this.leashKnots.entrySet()) {
            force = this.calculateLeashForceForBlockPos(entry);
            if (force == null) continue;
            combinedForce = combinedForce.m_82549_(force);
            combinedDirection = combinedDirection.m_82549_(force.m_82541_());
            ++validLeashes;
            vaildLeashKnots.put((BlockPos)entry.getKey(), entry.getValue());
        }
        boolean hasForce = !combinedForce.equals((Object)Vec3.f_82478_);
        Entity entity = RindingLeash.getFinalEntityForLeashIfForce(this.entity, hasForce);
        if (entity != null && hasForce) {
            ServerPlayer player;
            SuperLeadRopeEvent.hasFocus hasFocus2 = new SuperLeadRopeEvent.hasFocus(this.entity, entity, combinedForce, vaildLeashHolders, vaildLeashKnots);
            if (MinecraftForge.EVENT_BUS.post((Event)hasFocus2)) {
                return;
            }
            combinedForce = hasFocus2.getCombinedForce();
            if (entity instanceof ServerPlayer && CurtainCompat.isNotFakePlayer((Player)(player = (ServerPlayer)entity))) {
                RindingLeash.applyForceToPlayer(player, combinedForce, CommonEventHandler.leashConfigManager.getPlayerSpringFactor(), 0.0, CommonEventHandler.leashConfigManager.getMaxForce());
            } else {
                this.applyForceToNonPlayerEntity(entity, combinedForce, validLeashes, combinedDirection);
            }
        }
        RindingLeash.protectAnimalMovement(entity, hasForce);
    }

    private void applyForceToNonPlayerEntity(@NotNull Entity entity, Vec3 combinedForce, int validLeashes, Vec3 combinedDirection) {
        entity.m_20256_(entity.m_20184_().m_82549_(combinedForce));
        entity.f_19864_ = true;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.f_19797_ % 5 == 0) {
                if (validLeashes > 0 && this.canMobMove(mob)) {
                    this.moveMobTowardsCombinedDirection(mob, combinedDirection, combinedForce.m_82553_());
                } else {
                    mob.m_21573_().m_26573_();
                }
            }
        }
    }

    private boolean canMobMove(@NotNull Mob mob) {
        return !mob.m_21224_() && mob.m_21515_() && mob.m_20184_().m_82556_() < 25.0;
    }

    private void moveMobTowardsCombinedDirection(Mob mob, @NotNull Vec3 combinedDirection, double forceMagnitude) {
        if (combinedDirection.equals((Object)Vec3.f_82478_) || !this.canMobMove(mob)) {
            return;
        }
        Vec3 averageDirection = combinedDirection.m_82541_();
        double speed = this.calculateMobSpeed(mob, forceMagnitude);
        Vec3 targetPos = mob.m_20182_().m_82549_(averageDirection.m_82490_(2.0));
        if (this.isPositionQuickReachable(mob, targetPos)) {
            mob.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, speed);
            if (mob.f_19797_ % 10 == 0) {
                mob.m_21563_().m_24964_(targetPos);
            }
        }
    }

    private boolean isPositionQuickReachable(@NotNull Mob mob, Vec3 targetPos) {
        double distance = mob.m_20182_().m_82554_(targetPos);
        if (distance > 10.0) {
            return false;
        }
        double heightDiff = Math.abs(targetPos.f_82480_ - mob.m_20182_().f_82480_);
        if (heightDiff > 2.0) {
            return false;
        }
        if (mob.m_9236_().m_46749_(BlockPos.m_274446_((Position)targetPos))) {
            BlockHitResult hitResult = mob.m_9236_().m_45547_(new ClipContext(mob.m_20182_(), targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob));
            return hitResult.m_6662_() == HitResult.Type.MISS;
        }
        return true;
    }

    private double calculateMobSpeed(Mob mob, double forceMagnitude) {
        double baseSpeed = mob instanceof Llama ? 1.5 : 1.0;
        double forceFactor = Math.min(forceMagnitude * 0.3, 1.5);
        return baseSpeed * (1.0 + forceFactor);
    }

    @Nullable
    private Vec3 calculateLeashForceForUUID(@NotNull Map.Entry<UUID, LeashInfo> entry) {
        UUID uuid = entry.getKey();
        Entity uuidHolder = ((ServerLevel)this.entity.m_9236_()).m_8791_(uuid);
        if (uuidHolder != null) {
            return this.calculateLeashForce(uuidHolder, entry);
        }
        if (!this.delayedHolders.contains(uuid)) {
            SuperLeadRope.logger.warn("Could not apply leash forces for {}, because it is not found(it will be removed from list).", (Object)uuid);
            this.leashHolders.remove(uuid);
        }
        return null;
    }

    private Vec3 calculateLeashForceForBlockPos(@NotNull Map.Entry<BlockPos, LeashInfo> entry) {
        SuperLeashKnotEntity orCreateKnot = SuperLeashKnotEntity.getOrCreateKnot(this.entity.m_9236_(), entry.getKey());
        return this.calculateLeashForce((Entity)orCreateKnot, entry);
    }

    @Nullable
    private Vec3 calculateLeashForce(@NotNull Entity holder, @NotNull Map.Entry<?, LeashInfo> entry) {
        Vec3 holderPos = holder.m_20182_().m_82520_(0.0, (double)holder.m_20206_() * 0.7, 0.0);
        LeashInfo info = entry.getValue();
        Vec3 entityPos = this.entity.m_20182_();
        double distance = holderPos.m_82554_(entityPos);
        double maxDistance = info.maxDistance() == null ? this.getCurrentMaxDistance() : info.maxDistance().doubleValue();
        double extremeSnapDist = maxDistance * CommonEventHandler.leashConfigManager.getExtremeSnapFactor();
        double elasticDistanceScale = info.elasticDistanceScale() == null ? this.getCurrentElasticDistanceScale() : info.elasticDistanceScale().doubleValue();
        double elasticLimitDistance = maxDistance * elasticDistanceScale;
        if (distance > extremeSnapDist) {
            if (info.keepLeashTicks() >= 0) {
                Vec3 pullForce = this.calculateCriticalPullForce(holderPos, entityPos, distance, maxDistance, elasticLimitDistance);
                entry.setValue(info.decrementKeepTicks());
                MinecraftForge.EVENT_BUS.post((Event)new SuperLeadRopeEvent.keepNotBreakTick(this.entity, entry.getValue().keepLeashTicks(), holder, entry));
                if (entry.getValue().keepLeashTicks() > 0) {
                    return pullForce;
                }
            }
            this.removeLeash(holder);
            this.entity.m_9236_().m_247517_(null, holder.m_20097_(), (SoundEvent)SLPSoundEvents.LEAD_BREAK.get(), SoundSource.PLAYERS);
            return null;
        }
        Vec3 pullForce = Vec3.f_82478_;
        if (distance > elasticLimitDistance) {
            pullForce = this.calculatePullForce(holderPos, entityPos, distance, maxDistance, elasticLimitDistance);
        }
        if (distance <= extremeSnapDist && info.keepLeashTicks() < info.maxKeepLeashTicks()) {
            entry.setValue(info.resetKeepTicks());
        }
        return pullForce;
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    private Vec3 calculatePullForce(@NotNull Vec3 holderPos, Vec3 entityPos, double distance, double maxDistance, double elasticLimitDistance) {
        double extremeSnapDistance = maxDistance * CommonEventHandler.leashConfigManager.getExtremeSnapFactor();
        if (distance <= elasticLimitDistance) {
            return this.calculateNormalPullForce(holderPos, entityPos, distance, elasticLimitDistance);
        }
        if (distance <= extremeSnapDistance) {
            return this.calculateEnhancedPullForce(holderPos, entityPos, distance, elasticLimitDistance, extremeSnapDistance);
        }
        return this.calculateCriticalPullForce(holderPos, entityPos, distance, elasticLimitDistance, extremeSnapDistance);
    }

    @NotNull
    private Vec3 calculateNormalPullForce(@NotNull Vec3 holderPos, Vec3 entityPos, double distance, double elasticLimitDistance) {
        Vec3 pullDirection = holderPos.m_82546_(entityPos).m_82541_();
        double basePullStrength = 0.2;
        double excessDistance = Math.max(0.0, distance - elasticLimitDistance * 0.8);
        Vec3 pullForce = pullDirection.m_82490_(excessDistance * basePullStrength * CommonEventHandler.leashConfigManager.getSpringDampening());
        return this.applyElasticityFactors(pullForce);
    }

    @NotNull
    private Vec3 calculateEnhancedPullForce(@NotNull Vec3 holderPos, Vec3 entityPos, double distance, double elasticLimitDistance, double extremeSnapDistance) {
        Vec3 pullDirection = holderPos.m_82546_(entityPos).m_82541_();
        double excessRatio = (distance - elasticLimitDistance) / (extremeSnapDistance - elasticLimitDistance);
        double pullStrength = 0.5 + excessRatio * 1.5;
        double excessDistance = distance - elasticLimitDistance;
        Vec3 pullForce = pullDirection.m_82490_(excessDistance * pullStrength * CommonEventHandler.leashConfigManager.getSpringDampening());
        return this.applyElasticityFactors(pullForce);
    }

    @NotNull
    private Vec3 calculateCriticalPullForce(@NotNull Vec3 holderPos, Vec3 entityPos, double distance, double elasticLimitDistance, double extremeSnapDistance) {
        Vec3 pullDirection = holderPos.m_82546_(entityPos).m_82541_();
        double criticalExcessRatio = (distance - extremeSnapDistance) / extremeSnapDistance;
        double pullStrength = 2.0 + criticalExcessRatio * 3.0;
        double excessDistance = distance - elasticLimitDistance;
        Vec3 pullForce = pullDirection.m_82490_(excessDistance * pullStrength * CommonEventHandler.leashConfigManager.getSpringDampening());
        return this.applyElasticityFactors(pullForce);
    }

    @NotNull
    private Vec3 applyElasticityFactors(@NotNull Vec3 force) {
        return new Vec3(force.f_82479_ * CommonEventHandler.leashConfigManager.getXElasticity(), force.f_82480_ * CommonEventHandler.leashConfigManager.getYElasticity(), force.f_82481_ * CommonEventHandler.leashConfigManager.getZElasticity());
    }

    @Override
    public boolean removeLeash(Entity holder) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.removeLeash(superLeashKnotEntity.m_31748_());
        } else {
            bl = this.removeLeash(holder.m_20148_());
        }
        return bl;
    }

    @Override
    public boolean removeLeash(UUID holderUUID) {
        boolean removed;
        if (MinecraftForge.EVENT_BUS.post((Event)new SuperLeadRopeEvent.RemoveLeash(this.entity, holderUUID))) {
            return false;
        }
        boolean bl = removed = this.leashHolders.remove(holderUUID) != null;
        if (removed) {
            LeashStateInnerAPI.Operations.detach(this.entity, holderUUID);
            this.markForSync();
        }
        return removed;
    }

    private void removeLeashInner(BlockPos knotPos) {
        boolean removed;
        if (MinecraftForge.EVENT_BUS.post((Event)new SuperLeadRopeEvent.RemoveLeash(this.entity, knotPos))) {
            return;
        }
        boolean bl = removed = this.leashKnots.remove(knotPos) != null;
        if (removed) {
            LeashStateInnerAPI.Operations.detach(this.entity, knotPos);
        }
    }

    private void removeLeashInner(UUID holderUUID) {
        boolean removed;
        if (MinecraftForge.EVENT_BUS.post((Event)new SuperLeadRopeEvent.RemoveLeash(this.entity, holderUUID))) {
            return;
        }
        boolean bl = removed = this.leashHolders.remove(holderUUID) != null;
        if (removed) {
            LeashStateInnerAPI.Operations.detach(this.entity, holderUUID);
        }
    }

    @Override
    public boolean removeLeash(BlockPos knotPos) {
        boolean removed;
        if (MinecraftForge.EVENT_BUS.post((Event)new SuperLeadRopeEvent.RemoveLeash(this.entity, knotPos))) {
            return false;
        }
        boolean bl = removed = this.leashKnots.remove(knotPos) != null;
        if (removed) {
            LeashStateInnerAPI.Operations.detach(this.entity, knotPos);
        }
        return removed;
    }

    @Override
    public void removeAllLeashes() {
        this.removeAllHolderLeashesInner();
        this.removeAllKnotLeashes();
        this.markForSync();
    }

    private void removeAllHolderLeashesInner() {
        this.leashHolders.forEach((uuid, leashHolder) -> this.removeLeashInner((UUID)uuid));
    }

    private void removeAllKnotLeashesInner() {
        this.leashKnots.forEach((blockPos, leashHolder) -> this.removeLeashInner((BlockPos)blockPos));
    }

    @Override
    public void removeAllHolderLeashes() {
        this.removeAllHolderLeashesInner();
        this.markForSync();
    }

    @Override
    public void removeAllKnotLeashes() {
        this.removeAllKnotLeashesInner();
        this.markForSync();
    }

    @Override
    public boolean transferLeash(Entity holder, Entity newHolder) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.transferLeash(superLeashKnotEntity.m_31748_(), newHolder);
        } else {
            bl = this.transferLeash(holder.m_20148_(), newHolder);
        }
        return bl;
    }

    @Override
    public boolean transferLeash(Entity holder, Entity newHolder, String reserved) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.transferLeash(superLeashKnotEntity.m_31748_(), newHolder, reserved);
        } else {
            bl = this.transferLeash(holder.m_20148_(), newHolder, reserved);
        }
        return bl;
    }

    @Override
    public boolean transferLeash(UUID oldHolderUUID, Entity newHolder) {
        LeashInfo preInfo = this.leashHolders.get(oldHolderUUID);
        if (preInfo == null) {
            return false;
        }
        SuperLeadRopeEvent.TransferLeash event = new SuperLeadRopeEvent.TransferLeash(this.entity, oldHolderUUID, newHolder, preInfo.maxKeepLeashTicks());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        LeashInfo info = this.leashHolders.remove(oldHolderUUID);
        if (info == null || newHolder == null) {
            return false;
        }
        if (newHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)newHolder;
            LeashInfo leashInfo = info.transferHolder((Entity)superLeashKnotEntity, event.getMaxKeepLeashTicks());
            this.leashKnots.put(superLeashKnotEntity.m_31748_(), leashInfo);
        } else {
            LeashInfo leashInfo = info.transferHolder(newHolder, event.getMaxKeepLeashTicks());
            this.leashHolders.put(newHolder.m_20148_(), leashInfo);
        }
        LeashStateInnerAPI.Operations.transfer(this.entity, oldHolderUUID, newHolder);
        this.markForSync();
        return true;
    }

    @Override
    public boolean transferLeash(UUID oldHolderUUID, Entity newHolder, String reserved) {
        LeashInfo preInfo = this.leashHolders.get(oldHolderUUID);
        if (preInfo == null) {
            return false;
        }
        SuperLeadRopeEvent.TransferLeash event = new SuperLeadRopeEvent.TransferLeash(this.entity, oldHolderUUID, newHolder, preInfo.maxKeepLeashTicks());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        LeashInfo info = this.leashHolders.remove(oldHolderUUID);
        if (info == null || newHolder == null) {
            return false;
        }
        if (newHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)newHolder;
            LeashInfo leashInfo = info.transferHolder((Entity)superLeashKnotEntity, event.getMaxKeepLeashTicks(), reserved);
            this.leashKnots.put(superLeashKnotEntity.m_31748_(), leashInfo);
        } else {
            LeashInfo leashInfo = info.transferHolder(newHolder, event.getMaxKeepLeashTicks(), reserved);
            this.leashHolders.put(newHolder.m_20148_(), leashInfo);
        }
        LeashStateInnerAPI.Operations.transfer(this.entity, oldHolderUUID, newHolder);
        this.markForSync();
        return true;
    }

    @Override
    public boolean transferLeash(BlockPos knotPos, Entity newHolder) {
        LeashInfo preInfo = this.leashKnots.get(knotPos);
        if (preInfo == null) {
            return false;
        }
        SuperLeadRopeEvent.TransferLeash event = new SuperLeadRopeEvent.TransferLeash(this.entity, knotPos, newHolder, preInfo.maxKeepLeashTicks());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        LeashInfo info = this.leashKnots.remove(knotPos);
        if (info == null || newHolder == null) {
            return false;
        }
        if (newHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)newHolder;
            LeashInfo leashInfo = info.transferHolder((Entity)superLeashKnotEntity, event.getMaxKeepLeashTicks());
            this.leashKnots.put(superLeashKnotEntity.m_31748_(), leashInfo);
        } else {
            LeashInfo leashInfo = info.transferHolder(newHolder, event.getMaxKeepLeashTicks());
            this.leashHolders.put(newHolder.m_20148_(), leashInfo);
        }
        LeashStateInnerAPI.Operations.transfer(this.entity, knotPos, newHolder);
        this.markForSync();
        return true;
    }

    @Override
    public boolean transferLeash(BlockPos knotPos, Entity newHolder, String reserved) {
        LeashInfo preInfo = this.leashKnots.get(knotPos);
        if (preInfo == null) {
            return false;
        }
        SuperLeadRopeEvent.TransferLeash event = new SuperLeadRopeEvent.TransferLeash(this.entity, knotPos, newHolder, preInfo.maxKeepLeashTicks());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        LeashInfo info = this.leashKnots.remove(knotPos);
        if (info == null || newHolder == null) {
            return false;
        }
        if (newHolder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)newHolder;
            LeashInfo leashInfo = info.transferHolder((Entity)superLeashKnotEntity, event.getMaxKeepLeashTicks(), reserved);
            this.leashKnots.put(superLeashKnotEntity.m_31748_(), leashInfo);
        } else {
            LeashInfo leashInfo = info.transferHolder(newHolder, event.getMaxKeepLeashTicks(), reserved);
            this.leashHolders.put(newHolder.m_20148_(), leashInfo);
        }
        LeashStateInnerAPI.Operations.transfer(this.entity, knotPos, newHolder);
        this.markForSync();
        return true;
    }

    @Override
    public boolean setMaxKeepTicks(Entity holder, int maxKeepTicks) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.setMaxKeepTicks(superLeashKnotEntity.m_31748_(), maxKeepTicks);
        } else {
            bl = this.setMaxKeepTicks(holder.m_20148_(), maxKeepTicks);
        }
        return bl;
    }

    @Override
    public boolean setMaxKeepTicks(UUID holderUUID, int maxKeepTicks) {
        if (maxKeepTicks < 0) {
            return false;
        }
        LeashInfo info = this.leashHolders.get(holderUUID);
        if (info == null) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Integer> event = new SuperLeadRopeEvent.ModifyValue<Integer>(this.entity, holderUUID, Integer.valueOf(info.keepLeashTicks()), Integer.valueOf(maxKeepTicks), SuperLeadRopeEvent.ModifyValue.Type.MAX_KEEP_LEASH_TICKS);
        if (MinecraftForge.EVENT_BUS.post(event) && (event.getNewValue() == null || event.getNewValue() < 0)) {
            return false;
        }
        return this.updateLeashInfo(this.leashHolders, holderUUID, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), old.maxDistance(), old.elasticDistanceScale(), (int)((Integer)event.getNewValue()), (int)((Integer)event.getNewValue())));
    }

    @Override
    public boolean setMaxKeepTicks(BlockPos knotPos, int maxKeepTicks) {
        if (maxKeepTicks < 0) {
            return false;
        }
        LeashInfo info = this.leashKnots.get(knotPos);
        if (info == null) {
            return false;
        }
        SuperLeadRopeEvent.ModifyValue<Integer> event = new SuperLeadRopeEvent.ModifyValue<Integer>(this.entity, knotPos, Integer.valueOf(info.keepLeashTicks()), Integer.valueOf(maxKeepTicks), SuperLeadRopeEvent.ModifyValue.Type.MAX_KEEP_LEASH_TICKS);
        if (MinecraftForge.EVENT_BUS.post(event) && (event.getNewValue() == null || event.getNewValue() < 0)) {
            return false;
        }
        return this.updateLeashInfo(this.leashKnots, knotPos, old -> new LeashInfo(old.holderUUIDOpt().get(), (int)old.holderIdOpt().get(), old.marks(), old.reserved(), old.maxDistance(), old.elasticDistanceScale(), (int)((Integer)event.getNewValue()), (int)((Integer)event.getNewValue())));
    }

    @Override
    public int getMaxKeepTicks(Entity holder) {
        int n;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            n = this.getMaxKeepTicks(superLeashKnotEntity.m_31748_());
        } else {
            n = this.getMaxKeepTicks(holder.m_20148_());
        }
        return n;
    }

    @Override
    public int getMaxKeepTicks(UUID holderUUID) {
        return Optional.ofNullable(this.leashHolders.get(holderUUID)).map(LeashInfo::maxKeepLeashTicks).orElse(-1);
    }

    @Override
    public int getMaxKeepTicks(BlockPos knotPos) {
        return Optional.ofNullable(this.leashKnots.get(knotPos)).map(LeashInfo::maxKeepLeashTicks).orElse(-1);
    }

    @Override
    public boolean hasLeash() {
        return !this.leashKnots.isEmpty() || !this.leashHolders.isEmpty();
    }

    @Override
    public boolean hasKnotLeash() {
        return !this.leashKnots.isEmpty();
    }

    @Override
    public boolean hasHolderLeash() {
        return !this.leashHolders.isEmpty();
    }

    public static boolean isLeashable(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof Boat || entity instanceof AbstractMinecart;
    }

    @Override
    public Collection<LeashInfo> getAllLeashes() {
        return Stream.concat(this.leashHolders.values().stream(), this.leashKnots.values().stream()).collect(Collectors.toList());
    }

    @Override
    public Collection<LeashInfo> getAllHolderLeashes() {
        return Collections.unmodifiableCollection(this.leashHolders.values());
    }

    @Override
    public Collection<LeashInfo> getAllKnotLeashes() {
        return Collections.unmodifiableCollection(this.leashKnots.values());
    }

    @Override
    public boolean isLeashedBy(Entity holder) {
        boolean bl;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            bl = this.isLeashedBy(superLeashKnotEntity.m_31748_());
        } else {
            bl = this.isLeashedBy(holder.m_20148_());
        }
        return bl;
    }

    @Override
    public boolean isLeashedBy(UUID holderUUID) {
        return this.leashHolders.containsKey(holderUUID);
    }

    @Override
    public boolean isLeashedBy(BlockPos knotPos) {
        return this.leashKnots.containsKey(knotPos);
    }

    @Override
    public boolean isInDelayedLeash(UUID holderUUID) {
        return this.delayedHolders.contains(holderUUID);
    }

    @Override
    public Optional<LeashInfo> getLeashInfo(Entity holder) {
        Optional<LeashInfo> optional;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity superLeashKnotEntity = (SuperLeashKnotEntity)holder;
            optional = this.getLeashInfo(superLeashKnotEntity.m_31748_());
        } else {
            optional = this.getLeashInfo(holder.m_20148_());
        }
        return optional;
    }

    @Override
    public Optional<LeashInfo> getLeashInfo(UUID holderUUID) {
        return Optional.ofNullable(this.leashHolders.get(holderUUID));
    }

    @Override
    public Optional<LeashInfo> getLeashInfo(BlockPos knotPos) {
        return Optional.ofNullable(this.leashKnots.get(knotPos));
    }

    public CompoundTag serializeNBT() {
        CompoundTag infoTag;
        CompoundTag tag = new CompoundTag();
        ListTag holdersList = new ListTag();
        ListTag delayedHolderList = new ListTag();
        if (this.staticMaxDistance != null) {
            tag.m_128347_("StaticMaxDistance", this.staticMaxDistance.doubleValue());
        }
        tag.m_128347_("DefaultMaxDistance", this.getDefaultMaxDistance());
        if (this.staticElasticDistanceScale != null) {
            tag.m_128347_("StaticElasticDistanceScale", this.staticElasticDistanceScale.doubleValue());
        }
        tag.m_128347_("DefaultElasticDistanceScale", this.getDefaultElasticDistanceScale());
        for (LeashInfo info : this.leashHolders.values()) {
            infoTag = LeashDataImpl.generateCompoundTagFromUUIDLeashInfo(info);
            holdersList.add((Object)infoTag);
        }
        for (LeashInfo info : this.leashKnots.values()) {
            infoTag = LeashDataImpl.generateCompoundTagFromBlockPosLeashInfo(info);
            holdersList.add((Object)infoTag);
        }
        for (UUID uuid : this.delayedHolders) {
            infoTag = LeashDataImpl.generateCompoundTagFromUUID(uuid);
            delayedHolderList.add((Object)infoTag);
        }
        tag.m_128365_("LeashHolders", (Tag)holdersList);
        tag.m_128365_("DelayedHolders", (Tag)delayedHolderList);
        return tag;
    }

    @NotNull
    private static CompoundTag generateCompoundTagFromUUID(@NotNull UUID uuid) {
        CompoundTag infoTag = new CompoundTag();
        infoTag.m_128362_("DelayHolderUUID", uuid);
        return infoTag;
    }

    @NotNull
    private static CompoundTag generateCompoundTagFromUUIDLeashInfo(@NotNull LeashInfo info) {
        CompoundTag infoTag = new CompoundTag();
        if (info.holderUUIDOpt().isEmpty()) {
            throw new IllegalArgumentException("LeashInfo.holderUUIDOpt is empty");
        }
        infoTag.m_128362_("HolderUUID", info.holderUUIDOpt().get());
        return LeashDataImpl.getCommonCompoundTag(info, infoTag);
    }

    @NotNull
    private static CompoundTag generateCompoundTagFromBlockPosLeashInfo(@NotNull LeashInfo info) {
        CompoundTag infoTag = new CompoundTag();
        if (info.blockPosOpt().isEmpty()) {
            throw new IllegalArgumentException("LeashInfo.blockPos is empty");
        }
        BlockPos blockPos = info.blockPosOpt().get();
        infoTag.m_128365_("KnotBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        return LeashDataImpl.getCommonCompoundTag(info, infoTag);
    }

    @NotNull
    private static CompoundTag getCommonCompoundTag(@NotNull LeashInfo info, CompoundTag infoTag) {
        if (info.holderIdOpt().isEmpty()) {
            throw new IllegalArgumentException("LeashInfo.intId is empty");
        }
        infoTag.m_128405_("HolderID", info.holderIdOpt().get().intValue());
        CompoundTag marks = new CompoundTag();
        Set<String> markSet = info.marks();
        if (!markSet.isEmpty()) {
            marks.m_128405_("MarkSize", markSet.size());
            int i = 0;
            for (String mark : markSet) {
                marks.m_128359_("Mark" + i++, mark);
            }
            infoTag.m_128365_("Marks", (Tag)marks);
        }
        infoTag.m_128359_("Reserved", info.reserved());
        if (info.maxDistance() != null) {
            infoTag.m_128347_("MaxDistance", info.maxDistance().doubleValue());
        }
        if (info.elasticDistanceScale() != null) {
            infoTag.m_128347_("ElasticDistanceScale", info.elasticDistanceScale().doubleValue());
        }
        infoTag.m_128405_("KeepLeashTicks", info.keepLeashTicks());
        infoTag.m_128405_("MaxKeepLeashTicks", info.maxKeepLeashTicks());
        return infoTag;
    }

    public void deserializeNBT(@NotNull CompoundTag nbt) {
        CompoundTag infoTag;
        int i;
        this.leashHolders.clear();
        this.leashKnots.clear();
        this.delayedHolders.clear();
        if (nbt.m_128441_("DefaultMaxDistance")) {
            this.defaultMaxDistance = nbt.m_128459_("DefaultMaxDistance");
            this.staticMaxDistance = nbt.m_128441_("StaticMaxDistance") ? Double.valueOf(nbt.m_128459_("StaticMaxDistance")) : null;
        } else {
            this.defaultMaxDistance = CommonEventHandler.leashConfigManager.getMaxLeashLength();
        }
        if (nbt.m_128441_("DefaultElasticDistanceScale")) {
            this.defaultElasticDistanceScale = nbt.m_128459_("DefaultElasticDistanceScale");
            this.staticElasticDistanceScale = nbt.m_128441_("StaticElasticDistanceScale") ? Double.valueOf(nbt.m_128459_("StaticElasticDistanceScale")) : null;
        } else {
            this.defaultElasticDistanceScale = CommonEventHandler.leashConfigManager.getElasticDistanceScale();
        }
        if (nbt.m_128425_("LeashHolders", 9)) {
            ListTag holdersList = nbt.m_128437_("LeashHolders", 10);
            for (i = 0; i < holdersList.size(); ++i) {
                infoTag = holdersList.m_128728_(i);
                if (infoTag.m_128441_("HolderUUID")) {
                    LeashInfo uuidLeashDataFormListTag = LeashDataImpl.getUUIDLeashDataFormListTag(infoTag);
                    this.leashHolders.put(uuidLeashDataFormListTag.holderUUIDOpt().orElseThrow(), uuidLeashDataFormListTag);
                    continue;
                }
                LeashInfo blockPosLeashDataFormListTag = LeashDataImpl.getBlockPosLeashDataFormListTag(infoTag);
                this.leashKnots.put(blockPosLeashDataFormListTag.blockPosOpt().orElseThrow(), blockPosLeashDataFormListTag);
            }
        }
        if (nbt.m_128425_("DelayedHolders", 9)) {
            ListTag delayedHolderList = nbt.m_128437_("DelayedHolders", 10);
            for (i = 0; i < delayedHolderList.size(); ++i) {
                infoTag = delayedHolderList.m_128728_(i);
                UUID delayedUUIDFormListTag = LeashDataImpl.getDelayedUUIDFormListTag(infoTag);
                this.delayedHolders.add(delayedUUIDFormListTag);
            }
        }
    }

    @NotNull
    private static UUID getDelayedUUIDFormListTag(@NotNull CompoundTag infoTag) {
        if (infoTag.m_128441_("DelayHolderUUID")) {
            return infoTag.m_128342_("DelayHolderUUID");
        }
        throw new IllegalArgumentException("LeashInfo.intId is empty");
    }

    @Contract(value="_ -> new")
    @NotNull
    private static LeashInfo getUUIDLeashDataFormListTag(@NotNull CompoundTag infoTag) {
        if (infoTag.m_128441_("HolderUUID")) {
            if (infoTag.m_128441_("Marks")) {
                return new LeashInfo(infoTag.m_128342_("HolderUUID"), infoTag.m_128451_("HolderID"), LeashDataImpl.getMarks(infoTag), infoTag.m_128461_("Reserved"), infoTag.m_128441_("MaxDistance") ? Double.valueOf(infoTag.m_128459_("MaxDistance")) : null, infoTag.m_128441_("ElasticDistanceScale") ? Double.valueOf(infoTag.m_128459_("ElasticDistanceScale")) : null, infoTag.m_128451_("KeepLeashTicks"), infoTag.m_128441_("MaxKeepLeashTicks") ? infoTag.m_128451_("MaxKeepLeashTicks") : 20);
            }
            return new LeashInfo(infoTag.m_128342_("HolderUUID"), infoTag.m_128451_("HolderID"), infoTag.m_128461_("Reserved"), infoTag.m_128441_("MaxDistance") ? Double.valueOf(infoTag.m_128459_("MaxDistance")) : null, infoTag.m_128441_("ElasticDistanceScale") ? Double.valueOf(infoTag.m_128459_("ElasticDistanceScale")) : null, infoTag.m_128451_("KeepLeashTicks"), infoTag.m_128441_("MaxKeepLeashTicks") ? infoTag.m_128451_("MaxKeepLeashTicks") : 20);
        }
        throw new IllegalArgumentException("Unknown LeashInfo");
    }

    private static Set<String> getMarks(@NotNull CompoundTag infoTag) {
        if (infoTag.m_128441_("Marks")) {
            CompoundTag marks = infoTag.m_128469_("Marks");
            int size = marks.m_128451_("MarkSize");
            HashSet<String> markSet = new HashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                markSet.add(marks.m_128461_("Mark" + i));
            }
            return markSet;
        }
        return Set.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    private static LeashInfo getBlockPosLeashDataFormListTag(@NotNull CompoundTag infoTag) {
        if (infoTag.m_128441_("KnotBlockPos")) {
            if (infoTag.m_128441_("Marks")) {
                return new LeashInfo(NbtUtils.m_129239_((CompoundTag)infoTag.m_128469_("KnotBlockPos")), infoTag.m_128451_("HolderID"), LeashDataImpl.getMarks(infoTag), infoTag.m_128461_("Reserved"), infoTag.m_128441_("MaxDistance") ? Double.valueOf(infoTag.m_128459_("MaxDistance")) : null, infoTag.m_128441_("ElasticDistanceScale") ? Double.valueOf(infoTag.m_128459_("ElasticDistanceScale")) : null, infoTag.m_128451_("KeepLeashTicks"), infoTag.m_128441_("MaxKeepLeashTicks") ? infoTag.m_128451_("MaxKeepLeashTicks") : 20);
            }
            return new LeashInfo(NbtUtils.m_129239_((CompoundTag)infoTag.m_128469_("KnotBlockPos")), infoTag.m_128451_("HolderID"), infoTag.m_128461_("Reserved"), infoTag.m_128441_("MaxDistance") ? Double.valueOf(infoTag.m_128459_("MaxDistance")) : null, infoTag.m_128441_("ElasticDistanceScale") ? Double.valueOf(infoTag.m_128459_("ElasticDistanceScale")) : null, infoTag.m_128451_("KeepLeashTicks"), infoTag.m_128441_("MaxKeepLeashTicks") ? infoTag.m_128451_("MaxKeepLeashTicks") : 20);
        }
        throw new IllegalArgumentException("Unknown LeashInfo");
    }

    @Override
    public boolean canBeLeashed() {
        return this.leashHolders.size() + this.leashKnots.size() <= CommonEventHandler.leashConfigManager.getMaxLeashesPerEntity();
    }

    @Override
    public Optional<UUID> occupyLeash() {
        if (this.canBeLeashed() || this.delayedHolders.isEmpty()) {
            return Optional.empty();
        }
        int size = this.delayedHolders.size();
        int index = (int)(Math.random() * (double)size);
        UUID selected = null;
        int i = 0;
        for (UUID uuid : this.delayedHolders) {
            if (i == index) {
                selected = uuid;
                break;
            }
            ++i;
        }
        if (selected != null) {
            this.delayedHolders.remove(selected);
            return Optional.of(selected);
        }
        return Optional.empty();
    }

    @Override
    public boolean canBeAttachedTo(Entity pEntity) {
        if (pEntity == this.entity) {
            return false;
        }
        Optional<LeashInfo> leashInfo = this.getLeashInfo(pEntity);
        return leashInfo.isEmpty() && (double)this.entity.m_20270_(pEntity) <= CommonEventHandler.leashConfigManager.getMaxLeashLength() * CommonEventHandler.leashConfigManager.getExtremeSnapFactor() && this.canBeLeashed();
    }
}

