/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.core.potato;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.content.capability.impi.EternalPotatoImpl;
import top.r3944realms.superleadrope.content.capability.inter.IEternalPotato;
import top.r3944realms.superleadrope.core.potato.IEternalPotatoManager;

class LocalEternalPotatoManager
implements IEternalPotatoManager {
    private final Map<UUID, EternalPotatoImpl> LOCAL_DATA = new ConcurrentHashMap<UUID, EternalPotatoImpl>();

    LocalEternalPotatoManager() {
    }

    @Override
    public IEternalPotato getOrCreate(UUID uuid) {
        return this.LOCAL_DATA.computeIfAbsent(uuid, k -> {
            EternalPotatoImpl impl = new EternalPotatoImpl();
            impl.setItemUUID(uuid);
            return impl;
        });
    }

    @Override
    public void remove(UUID uuid) {
        this.LOCAL_DATA.remove(uuid);
    }

    @Override
    public void clear() {
        this.LOCAL_DATA.clear();
    }

    @Override
    public CompoundTag saveAll() {
        CompoundTag root = new CompoundTag();
        this.LOCAL_DATA.forEach((uuid, impl) -> root.m_128365_(uuid.toString(), (Tag)impl.serializeNBT()));
        return root;
    }

    @Override
    public void loadAll(CompoundTag tag) {
        this.LOCAL_DATA.clear();
        for (String key : tag.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(key);
                EternalPotatoImpl impl = new EternalPotatoImpl();
                impl.deserializeNBT(tag.m_128469_(key));
                impl.setItemUUID(uuid);
                this.LOCAL_DATA.put(uuid, impl);
            }
            catch (IllegalArgumentException e) {
                SuperLeadRope.logger.error("Could not load UUID: {}", (Object)key, (Object)e);
            }
        }
    }
}

