/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.core.punishment;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.r3944realms.superleadrope.content.SLPDamageTypes;
import top.r3944realms.superleadrope.content.capability.CapabilityHandler;
import top.r3944realms.superleadrope.core.punishment.PunishmentDefinition;
import top.r3944realms.superleadrope.datagen.data.SLPLangKeyValue;

public class DailyPunishmentHandler {
    private static long lastProcessedDay = -1L;
    private static final int COUNTDOWN_SECONDS = 10;
    private static final Map<UUID, Integer> countdownMap = new ConcurrentHashMap<UUID, Integer>();

    public static void onServerTick() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        for (ServerLevel level : server.m_129785_()) {
            long currentDay = level.m_46468_() / 24000L;
            if (currentDay != lastProcessedDay) {
                lastProcessedDay = currentDay;
                for (ServerPlayer player : level.m_8795_(p -> !p.m_7500_() && !p.m_5833_())) {
                    player.m_150109_().f_35974_.stream().filter(stack -> !stack.m_41619_()).forEach(stack -> stack.getCapability(CapabilityHandler.ETERNAL_POTATO_CAP).ifPresent(cap -> {
                        UUID playerId;
                        int dailyObl = cap.getDailyObligations();
                        if (dailyObl > 0) {
                            cap.beginInit();
                            cap.setPendingPunishments(cap.getPendingPunishments() + dailyObl);
                            cap.setDailyObligations(0);
                            cap.endInit();
                        }
                        if (cap.getPendingPunishments() > cap.getGracePunishments() && !countdownMap.containsKey(playerId = player.m_20148_())) {
                            countdownMap.put(playerId, 200);
                        }
                    }));
                }
            }
            countdownMap.forEach((uuid, ticksLeft) -> {
                ServerPlayer player = (ServerPlayer)level.m_46003_(uuid);
                if (player == null) {
                    return;
                }
                player.m_150109_().f_35974_.stream().filter(stack -> !stack.m_41619_()).forEach(stack -> stack.getCapability(CapabilityHandler.ETERNAL_POTATO_CAP).ifPresent(cap -> {
                    if (cap.getPendingPunishments() <= cap.getGracePunishments() || player.m_7500_() || player.m_5833_()) {
                        countdownMap.remove(uuid);
                        return;
                    }
                    int newTicksLeft = ticksLeft - 1;
                    countdownMap.put((UUID)uuid, newTicksLeft);
                    int secondsLeft = (newTicksLeft + 19) / 20;
                    int color = secondsLeft > 6 ? 0xFF5555 : (secondsLeft > 3 ? 0xFFFF55 : 0x55FF55);
                    player.m_5661_((Component)Component.m_237110_((String)SLPLangKeyValue.EP_OBLIGATION_COUNTDOWN.getKey(), (Object[])new Object[]{secondsLeft}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)color))), true);
                    if (newTicksLeft <= 0) {
                        PunishmentDefinition punishment = cap.getPunishment();
                        if (punishment != null) {
                            punishment.execute(player, new DamageSource(Holder.m_205709_((Object)SLPDamageTypes.ETERNAL_POTATO_NOT_COMPLETE), (Entity)player));
                        }
                        cap.beginInit();
                        cap.setPendingPunishments(Math.max(0, cap.getPendingPunishments() - 2));
                        cap.endInit();
                        countdownMap.remove(uuid);
                    }
                }));
            });
        }
    }
}

