/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.util.capability;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.api.SLPCapability;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashData;
import top.r3944realms.superleadrope.api.type.capabilty.LeashInfo;

@ApiStatus.Internal
public final class LeashDataInnerAPI {
    @NotNull
    public static Optional<ILeashData> getLeashData(@NotNull Entity entity) {
        Objects.requireNonNull(entity, "Entity cannot be null");
        return entity.getCapability(SLPCapability.LEASH_DATA_CAP).resolve();
    }

    public static final class Utils {
        private Utils() {
        }

        public static boolean hasLeashData(Entity entity) {
            return LeashDataInnerAPI.getLeashData(entity).isPresent();
        }
    }

    public static final class ManagementOperations {
        private ManagementOperations() {
        }

        public static Optional<UUID> occupyLeash(Entity entity) {
            return LeashDataInnerAPI.getLeashData(entity).flatMap(ILeashData::occupyLeash);
        }

        public static void markForSync(Entity entity) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(ILeashData::markForSync);
        }

        public static void immediateSync(Entity entity) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(ILeashData::immediateSync);
        }

        public static void checkSync(Entity entity) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(ILeashData::checkSync);
        }
    }

    public static final class QueryOperations {
        private QueryOperations() {
        }

        public static boolean hasLeash(Entity entity) {
            return LeashDataInnerAPI.getLeashData(entity).map(ILeashData::hasLeash).orElse(false);
        }

        public static boolean hasKnotLeash(Entity entity) {
            return LeashDataInnerAPI.getLeashData(entity).map(ILeashData::hasKnotLeash).orElse(false);
        }

        public static boolean hasHolderLeash(Entity entity) {
            return LeashDataInnerAPI.getLeashData(entity).map(ILeashData::hasHolderLeash).orElse(false);
        }

        public static Collection<LeashInfo> getAllLeashes(Entity entity) {
            return LeashDataInnerAPI.getLeashData(entity).map(ILeashData::getAllLeashes).orElse(Collections.emptyList());
        }

        public static boolean isLeashedBy(Entity entity, Entity holder) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.isLeashedBy(holder)).orElse(false);
        }

        public static boolean isLeashedBy(Entity entity, UUID holderUUID) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.isLeashedBy(holderUUID)).orElse(false);
        }

        public static boolean isLeashedBy(Entity entity, BlockPos knotPos) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.isLeashedBy(knotPos)).orElse(false);
        }

        public static boolean isInDelayedLeash(Entity entity, UUID holderUUID) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.isInDelayedLeash(holderUUID)).orElse(false);
        }

        public static Optional<LeashInfo> getLeashInfo(Entity entity, Entity holder) {
            return LeashDataInnerAPI.getLeashData(entity).flatMap(data -> data.getLeashInfo(holder));
        }

        public static Optional<LeashInfo> getLeashInfo(Entity entity, UUID holderUUID) {
            return LeashDataInnerAPI.getLeashData(entity).flatMap(data -> data.getLeashInfo(holderUUID));
        }

        public static Optional<LeashInfo> getLeashInfo(Entity entity, BlockPos knotPos) {
            return LeashDataInnerAPI.getLeashData(entity).flatMap(data -> data.getLeashInfo(knotPos));
        }

        public static boolean canBeLeashed(Entity entity) {
            return LeashDataInnerAPI.getLeashData(entity).map(ILeashData::canBeLeashed).orElse(false);
        }

        public static boolean canBeAttachedTo(Entity entity, Entity target) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.canBeAttachedTo(target)).orElse(false);
        }
    }

    public static final class TransferOperations {
        private TransferOperations() {
        }

        public static boolean transfer(Entity entity, Entity holder, Entity newHolder) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.transferLeash(holder, newHolder)).orElse(false);
        }

        public static boolean transfer(Entity entity, Entity holder, Entity newHolder, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.transferLeash(holder, newHolder, reserved) : data.transferLeash(holder, newHolder)).orElse(false);
        }

        public static boolean transfer(Entity entity, UUID holderUUID, Entity newHolder) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.transferLeash(holderUUID, newHolder)).orElse(false);
        }

        public static boolean transfer(Entity entity, UUID holderUUID, Entity newHolder, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.transferLeash(holderUUID, newHolder, reserved) : data.transferLeash(holderUUID, newHolder)).orElse(false);
        }

        public static boolean transfer(Entity entity, BlockPos knotPos, Entity newHolder) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.transferLeash(knotPos, newHolder)).orElse(false);
        }

        public static boolean transfer(Entity entity, BlockPos knotPos, Entity newHolder, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.transferLeash(knotPos, newHolder, reserved) : data.transferLeash(knotPos, newHolder)).orElse(false);
        }
    }

    public static final class PhysicsOperations {
        private PhysicsOperations() {
        }

        public static void applyForces(Entity entity) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(ILeashData::applyLeashForces);
        }
    }

    public static final class PropertyOperations {
        private PropertyOperations() {
        }

        public static void setStaticMaxDistance(Entity entity, @Nullable Double distance) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(data -> data.setStaticMaxDistance(distance));
        }

        public static void setElasticDistanceScale(Entity entity, @Nullable Double distance) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(data -> data.setStaticElasticDistanceScale(distance));
        }

        public static boolean setMaxDistance(Entity entity, Entity holder, @Nullable Double distance) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setMaxDistance(holder, distance)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, Entity holder, @Nullable Double distance, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.setMaxDistance(holder, distance, reserved) : data.setMaxDistance(holder, distance)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, Entity holder, @Nullable Double distance, int maxKeepTicks) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setMaxDistance(holder, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, Entity holder, @Nullable Double distance, int maxKeepTicks, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.setMaxDistance(holder, distance, maxKeepTicks, reserved) : data.setMaxDistance(holder, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, UUID holderUUID, @Nullable Double distance) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setMaxDistance(holderUUID, distance)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, UUID holderUUID, @Nullable Double distance, int maxKeepTicks) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setMaxDistance(holderUUID, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, UUID holderUUID, @Nullable Double distance, int maxKeepTicks, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.setMaxDistance(holderUUID, distance, maxKeepTicks, reserved) : data.setMaxDistance(holderUUID, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, BlockPos knotPos, @Nullable Double distance) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setMaxDistance(knotPos, distance)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, BlockPos knotPos, @Nullable Double distance, int maxKeepTicks) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setMaxDistance(knotPos, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setMaxDistance(Entity entity, BlockPos knotPos, @Nullable Double distance, int maxKeepTicks, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.setMaxDistance(knotPos, distance, maxKeepTicks, reserved) : data.setMaxDistance(knotPos, distance, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, Entity holder, @Nullable Double scale) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setElasticDistanceScale(holder, scale)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, Entity holder, @Nullable Double scale, int maxKeepTicks) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setElasticDistanceScale(holder, scale, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, Entity holder, @Nullable Double scale, int maxKeepTicks, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.setElasticDistanceScale(holder, scale, maxKeepTicks, reserved) : data.setElasticDistanceScale(holder, scale, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, UUID holderUUID, @Nullable Double scale) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setElasticDistanceScale(holderUUID, scale)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, UUID holderUUID, @Nullable Double scale, int maxKeepTicks) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setElasticDistanceScale(holderUUID, scale, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, UUID holderUUID, @Nullable Double scale, int maxKeepTicks, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.setElasticDistanceScale(holderUUID, scale, maxKeepTicks, reserved) : data.setElasticDistanceScale(holderUUID, scale, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, BlockPos knotPos, @Nullable Double scale) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setElasticDistanceScale(knotPos, scale)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, BlockPos knotPos, @Nullable Double scale, int maxKeepTicks) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.setElasticDistanceScale(knotPos, scale, maxKeepTicks)).orElse(false);
        }

        public static boolean setElasticDistanceScale(Entity entity, BlockPos knotPos, @Nullable Double scale, int maxKeepTicks, @Nullable String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> reserved != null ? data.setElasticDistanceScale(knotPos, scale, maxKeepTicks, reserved) : data.setElasticDistanceScale(knotPos, scale, maxKeepTicks)).orElse(false);
        }
    }

    public static final class LeashOperations {
        private LeashOperations() {
        }

        public static boolean attach(Entity entity, Entity holder) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.addLeash(holder)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.addLeash(holder, reserved)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, @Nullable Double maxDistance) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.addLeash(holder, maxDistance)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, @Nullable Double maxDistance, @Nullable Double elasticdDistanceScale, int maxKeepTicks) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.addLeash(holder, maxDistance, elasticdDistanceScale, maxKeepTicks)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, @Nullable Double maxDistance, String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.addLeash(holder, maxDistance, reserved)).orElse(false);
        }

        public static boolean attach(Entity entity, Entity holder, @Nullable Double maxDistance, @Nullable Double elasticDistanceScale, int maxKeepTicks, String reserved) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.addLeash(holder, maxDistance, elasticDistanceScale, maxKeepTicks, reserved)).orElse(false);
        }

        public static void attachWithInfo(Entity entity, Entity holder, LeashInfo info) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(data -> data.addLeash(holder, info));
        }

        public static void attachDelayed(Entity entity, Player holderPlayer) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(data -> data.addDelayedLeash(holderPlayer));
        }

        public static void removeDelayed(Entity entity, UUID onceHolderPlayerUUID) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(data -> data.removeDelayedLeash(onceHolderPlayerUUID));
        }

        public static boolean detach(Entity entity, Entity holder) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.removeLeash(holder)).orElse(false);
        }

        public static boolean detach(Entity entity, UUID holderUUID) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.removeLeash(holderUUID)).orElse(false);
        }

        public static boolean detach(Entity entity, BlockPos knotPos) {
            return LeashDataInnerAPI.getLeashData(entity).map(data -> data.removeLeash(knotPos)).orElse(false);
        }

        public static void detachAll(Entity entity) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(ILeashData::removeAllLeashes);
        }

        public static void detachAllHolders(Entity entity) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(ILeashData::removeAllHolderLeashes);
        }

        public static void detachAllKnots(Entity entity) {
            LeashDataInnerAPI.getLeashData(entity).ifPresent(ILeashData::removeAllKnotLeashes);
        }
    }
}

