/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.util.capability;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.superleadrope.api.SLPCapability;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashState;

@ApiStatus.Internal
public final class LeashStateInnerAPI {
    private LeashStateInnerAPI() {
    }

    @NotNull
    public static Optional<ILeashState> getLeashState(@NotNull Entity entity) {
        Objects.requireNonNull(entity, "Entity cannot be null");
        return entity.getCapability(SLPCapability.LEASH_STATE_CAP).resolve();
    }

    public static final class Operations {
        private Operations() {
        }

        public static void attach(Entity leashed, Entity holder) {
            LeashStateInnerAPI.getLeashState(leashed).ifPresent(state -> state.setLeashHolderLocationOffset(holder, null));
        }

        public static void detach(Entity leashed, Entity holder) {
            Offset.removeHolderFor(leashed, holder);
        }

        public static void detach(Entity leashed, UUID holderUUID) {
            Offset.removeHolderFor(leashed, holderUUID);
        }

        public static void detach(Entity leashed, BlockPos knotPos) {
            Offset.removeHolderFor(leashed, knotPos);
        }

        public static void transfer(Entity leashed, Entity oldHolder, Entity newHolder) {
            LeashStateInnerAPI.getLeashState(leashed).ifPresent(state -> {
                state.removeLeashHolderLocationOffset(oldHolder);
                state.setLeashHolderLocationOffset(newHolder, null);
            });
        }

        public static void transfer(Entity leashed, UUID oldHolderUUID, Entity newHolder) {
            LeashStateInnerAPI.getLeashState(leashed).ifPresent(state -> {
                state.removeLeashHolderLocationOffset(oldHolderUUID);
                state.setLeashHolderLocationOffset(newHolder, null);
            });
        }

        public static void transfer(Entity leashed, BlockPos oldKnotPos, Entity newHolder) {
            LeashStateInnerAPI.getLeashState(leashed).ifPresent(state -> {
                state.removeLeashHolderLocationOffset(oldKnotPos);
                state.setLeashHolderLocationOffset(newHolder, null);
            });
        }

        public static void copy(Entity source, Entity target) {
            LeashStateInnerAPI.getLeashState(source).ifPresent(sourceState -> LeashStateInnerAPI.getLeashState(target).ifPresent(targetState -> targetState.copy((ILeashState)sourceState, target)));
        }
    }

    public static final class Sync {
        private Sync() {
        }

        public static void mark(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::markForSync);
        }

        public static void immediate(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::immediateSync);
        }

        public static void check(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::checkSync);
        }
    }

    public static final class Offset {
        private Offset() {
        }

        public static void resetAllHolder(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::resetAllLeashHolderLocationsOffset);
        }

        public static void resetHolderFor(Entity entity, Entity holder) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.resetLeashHolderLocationOffset(holder));
        }

        public static void resetHolderFor(Entity entity, UUID holderUUID) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.resetLeashHolderLocationOffset(holderUUID));
        }

        public static void resetHolderFor(Entity entity, BlockPos knotPos) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.resetLeashHolderLocationOffset(knotPos));
        }

        public static void setHolderFor(Entity entity, Entity holder, Vec3 offset) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.setLeashHolderLocationOffset(holder, offset));
        }

        public static void setHolderFor(Entity entity, UUID holderUUID, Vec3 offset) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.setLeashHolderLocationOffset(holderUUID, offset));
        }

        public static void setHolderFor(Entity entity, BlockPos knotPos, Vec3 offset) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.setLeashHolderLocationOffset(knotPos, offset));
        }

        public static void setHolderFor(Entity entity, BlockPos knotPos) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.setLeashHolderLocationOffset(knotPos, null));
        }

        public static void setHolderFor(Entity entity, Entity holder) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.setLeashHolderLocationOffset(holder, null));
        }

        public static void setHolderFor(Entity entity, UUID holderUUID) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.setLeashHolderLocationOffset(holderUUID, null));
        }

        public static void addHolderTo(Entity entity, Entity holder, Vec3 offset) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.addLeashHolderLocationOffset(holder, offset));
        }

        public static void addHolderTo(Entity entity, UUID holderUUID, Vec3 offset) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.addLeashHolderLocationOffset(holderUUID, offset));
        }

        public static void addHolderTo(Entity entity, BlockPos knotPos, Vec3 offset) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.addLeashHolderLocationOffset(knotPos, offset));
        }

        public static void removeHolderFor(Entity entity, Entity holder) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.removeLeashHolderLocationOffset(holder));
        }

        public static void removeHolderFor(Entity entity, UUID holderUUID) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.removeLeashHolderLocationOffset(holderUUID));
        }

        public static void removeHolderFor(Entity entity, BlockPos knotPos) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.removeLeashHolderLocationOffset(knotPos));
        }

        public static void removeHolderAll(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::removeAllLeashHolderLocationOffset);
        }

        public static void removeAllHolderUUIDs(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::removeAllLeashHolderUUIDLocationOffset);
        }

        public static void removeAllHolderBlockPoses(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::removeAllLeashHolderBlockPosLocationOffset);
        }

        public static Optional<Vec3> getApplyEntityOffset(Entity entity) {
            return LeashStateInnerAPI.getLeashState(entity).flatMap(ILeashState::getLeashApplyEntityLocationOffset);
        }

        public static Vec3 getDefaultApplyEntityOffset(Entity entity) {
            return LeashStateInnerAPI.getLeashState(entity).map(ILeashState::getDefaultLeashApplyEntityLocationOffset).orElse(Vec3.f_82478_);
        }

        public static void resetApplyEntityAll(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::resetAllLeashApplyEntityLocationsOffset);
        }

        public static void removeApplyEntity(Entity entity) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(ILeashState::removeLeashApplyEntityLocationOffset);
        }

        public static void setApplyEntity(Entity entity, Vec3 offset) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.setLeashApplyEntityLocationOffset(offset));
        }

        public static void addApplyEntity(Entity entity, Vec3 offset) {
            LeashStateInnerAPI.getLeashState(entity).ifPresent(state -> state.addLeashApplyEntityLocationOffset(offset));
        }
    }

    public static final class Query {
        private Query() {
        }

        public static boolean hasLeashState(Entity entity) {
            return LeashStateInnerAPI.getLeashState(entity).map(ILeashState::hasLeashState).orElse(false);
        }

        public static Map<UUID, ILeashState.LeashState> getAllUUIDStates(Entity entity) {
            return LeashStateInnerAPI.getLeashState(entity).map(ILeashState::getHolderLeashStates).orElse(Map.of());
        }

        public static Map<BlockPos, ILeashState.LeashState> getAllBlockPosStates(Entity entity) {
            return LeashStateInnerAPI.getLeashState(entity).map(ILeashState::getKnotLeashStates).orElse(Map.of());
        }

        public static Optional<ILeashState.LeashState> getState(Entity entity, Entity holder) {
            return LeashStateInnerAPI.getLeashState(entity).flatMap(state -> state.getLeashState(holder));
        }

        public static Optional<ILeashState.LeashState> getState(Entity entity, UUID holderUUID) {
            return LeashStateInnerAPI.getLeashState(entity).flatMap(state -> state.getLeashState(holderUUID));
        }

        public static Optional<ILeashState.LeashState> getState(Entity entity, BlockPos knotPos) {
            return LeashStateInnerAPI.getLeashState(entity).flatMap(state -> state.getLeashState(knotPos));
        }

        public static boolean hasState(Entity entity) {
            return LeashStateInnerAPI.getLeashState(entity).isPresent();
        }

        public static boolean hasStateFor(Entity entity, Entity holder) {
            return Query.getState(entity, holder).isPresent();
        }

        public static boolean hasStateFor(Entity entity, UUID holderUUID) {
            return Query.getState(entity, holderUUID).isPresent();
        }

        public static boolean hasStateFor(Entity entity, BlockPos knotPos) {
            return Query.getState(entity, knotPos).isPresent();
        }
    }
}

