/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.workspace;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import top.r3944realms.superleadrope.CommonEventHandler;
import top.r3944realms.superleadrope.api.SLPCapability;
import top.r3944realms.superleadrope.api.SuperLeadRopeApi;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashData;
import top.r3944realms.superleadrope.api.type.util.ILeashHelper;
import top.r3944realms.superleadrope.util.capability.LeashDataInnerAPI;

public class LeashHelper
implements ILeashHelper {
    @Override
    public ILeashHelper.IHolder getHolderHelper(final Entity holder) {
        return new ILeashHelper.IHolder(){

            @Override
            public Entity getHolderEntity() {
                return holder;
            }

            @Override
            public Set<ILeashData> getAllLeash() {
                return SuperLeadRopeApi.leashableInArea(this.getHolderEntity()).stream().map(i -> i.getCapability(SLPCapability.LEASH_DATA_CAP).resolve()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            }

            @Override
            public <T extends Entity> Set<ILeashData> getLeash(Class<T> clazz, AABB box, Predicate<T> filter) {
                return SuperLeadRopeApi.leashableInArea(this.getHolderEntity(), clazz, box, filter).stream().map(i -> i.getCapability(SLPCapability.LEASH_DATA_CAP).resolve()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            }

            @Override
            public boolean leashEntity(UUID uuid) {
                Entity entity = CommonEventHandler.Game.getServerLevel().m_8791_(uuid);
                if (entity != null && SuperLeadRopeApi.isLeashable(entity)) {
                    return LeashDataInnerAPI.getLeashData(entity).map(i -> i.addLeash(entity)).orElse(false);
                }
                return false;
            }

            @Override
            public boolean unleashEntity(UUID uuid) {
                Entity entity = CommonEventHandler.Game.getServerLevel().m_8791_(uuid);
                if (entity != null && SuperLeadRopeApi.isLeashable(entity)) {
                    return LeashDataInnerAPI.getLeashData(entity).map(i -> i.removeLeash(entity)).orElse(false);
                }
                return false;
            }
        };
    }

    @Override
    public ILeashHelper.ILeashed getLeashedHelper(Entity leashed) {
        return () -> LeashDataInnerAPI.getLeashData(leashed).orElseThrow();
    }
}

