/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.workspace;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashData;
import top.r3944realms.superleadrope.api.type.capabilty.ILeashState;
import top.r3944realms.superleadrope.api.type.util.ILeashHelper;
import top.r3944realms.superleadrope.api.workspace.IWorkSpaceHelper;
import top.r3944realms.superleadrope.content.capability.impi.LeashDataImpl;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.util.capability.LeashDataInnerAPI;
import top.r3944realms.superleadrope.util.capability.LeashStateInnerAPI;
import top.r3944realms.superleadrope.workspace.LeashHelper;

public class WorkSpaceHelper
implements IWorkSpaceHelper {
    @Override
    @NotNull
    public List<Entity> leashableInArea(@NotNull Level pLevel, Vec3 pPos, @Nullable Predicate<Entity> filter, double fetchDistance) {
        AABB box = AABB.m_165882_((Vec3)pPos, (double)fetchDistance, (double)fetchDistance, (double)fetchDistance);
        return pLevel.m_6443_(Entity.class, box, e -> LeashDataImpl.isLeashable(e) && Objects.requireNonNullElse(filter, entity -> true).test((Entity)e));
    }

    @Override
    @NotNull
    public <T extends Entity> List<T> leashableInArea(@NotNull Level pLevel, Class<T> clazz, @Nullable Predicate<T> filter, AABB box) {
        return pLevel.m_6443_(clazz, box, e -> LeashDataImpl.isLeashable(e) && Objects.requireNonNullElse(filter, entity -> true).test((Entity)e));
    }

    @Override
    public ILeashHelper getLeashHelper() {
        return new LeashHelper();
    }

    @Override
    public boolean isSuperLeadKnot(Entity pEntity) {
        return pEntity instanceof SuperLeashKnotEntity;
    }

    @Override
    public BlockPos getSuperLeadPos(Entity pEntity) throws IllegalArgumentException {
        if (this.isSuperLeadKnot(pEntity)) {
            return ((SuperLeashKnotEntity)pEntity).m_31748_();
        }
        throw new IllegalArgumentException(pEntity.getClass().getName() + " is not a superlead knot");
    }

    @Override
    public boolean isLeashable(@NotNull Entity pEntity) {
        return LeashDataImpl.isLeashable(pEntity);
    }

    @Override
    public Optional<ILeashData> getLeashData(@NotNull Entity pEntity) {
        return LeashDataInnerAPI.getLeashData(pEntity);
    }

    @Override
    public Optional<ILeashState> getLeashState(@NotNull Entity pEntity) {
        return LeashStateInnerAPI.getLeashState(pEntity);
    }
}

