/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.client.renderer.SuperLeashRenderer;
import top.r3944realms.superleadrope.client.renderer.resolver.SuperLeashStateResolver;
import top.r3944realms.superleadrope.content.capability.inter.ILeashData;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.util.capability.LeashDataAPI;

public class LeashRenderHandler {
    public static void onRenderLevelStage(PoseStack poseStack, float partialTick) {
        LeashRenderHandler.renderAllCustomLeashes(poseStack, partialTick);
    }

    private static void renderAllCustomLeashes(PoseStack poseStack, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Entity cameraEntity = minecraft.m_91288_();
        if (level == null || cameraEntity == null) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        for (Entity entity : level.m_45976_(Entity.class, cameraEntity.m_20191_().m_82400_(100.0))) {
            LeashDataAPI.getLeashData(entity).ifPresent(leashData -> {
                for (ILeashData.LeashInfo leashInfo : leashData.getAllLeashes()) {
                    LeashRenderHandler.renderLeashFromInfo(entity, leashInfo, poseStack, (MultiBufferSource)bufferSource, partialTick);
                }
            });
        }
    }

    private static void renderLeashFromInfo(Entity entity, ILeashData.LeashInfo leashInfo, PoseStack poseStack, MultiBufferSource bufferSource, float partialTick) {
        try {
            Optional<Entity> holderOpt = LeashRenderHandler.getHolderFromLeashInfo(entity.m_9236_(), leashInfo);
            if (holderOpt.isEmpty()) {
                return;
            }
            Entity holder = holderOpt.get();
            SuperLeashStateResolver.resolve(holder, entity, leashInfo, partialTick).ifPresent(leashRenderState -> SuperLeashRenderer.renderLeash(leashRenderState, poseStack, bufferSource));
        }
        catch (Exception e) {
            SuperLeadRope.logger.error("Failed to render leash", (Throwable)e);
        }
    }

    private static Optional<Entity> getHolderFromLeashInfo(Level level, ILeashData.LeashInfo leashInfo) {
        if (leashInfo.blockPosOpt().isPresent()) {
            BlockPos pos = leashInfo.blockPosOpt().get();
            return Optional.of(SuperLeashKnotEntity.getOrCreateKnot(level, pos));
        }
        if (leashInfo.holderUUIDOpt().isPresent()) {
            UUID holderUUID = leashInfo.holderUUIDOpt().get();
            for (Entity e : ((ClientLevel)level).m_104735_()) {
                if (!e.m_20148_().equals(holderUUID)) continue;
                return Optional.of(e);
            }
        }
        return Optional.empty();
    }
}

