/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.client.renderer.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.r3944realms.superleadrope.SuperLeadRope;
import top.r3944realms.superleadrope.client.renderer.state.SuperLeashRenderState;
import top.r3944realms.superleadrope.content.capability.impi.LeashDataImpl;
import top.r3944realms.superleadrope.content.capability.inter.ILeashData;
import top.r3944realms.superleadrope.content.capability.inter.ILeashState;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.util.capability.LeashStateAPI;

public class SuperLeashStateResolver {
    private static final float MAX_TENSION = 1.5f;
    private static final float THICKNESS_BASE = 0.1f;
    private static final float THICKNESS_TENSION = 0.15f;
    private static final Map<UUID, FrameCache> frameCacheMap = new HashMap<UUID, FrameCache>();

    public static Optional<SuperLeashRenderState> resolve(Entity holder, Entity leashedEntity, ILeashData.LeashInfo leashInfo, float partialTicks) {
        Vec3 currentHolderPos;
        if (holder == null || leashedEntity == null) {
            return Optional.empty();
        }
        Optional<ILeashState> leashedEntityStateOpt = LeashStateAPI.getLeashState(leashedEntity);
        if (leashedEntityStateOpt.isEmpty()) {
            return Optional.empty();
        }
        ILeashState leashedEntityState = leashedEntityStateOpt.get();
        Optional<ILeashState.LeashState> leashStateOpt = leashedEntityState.getLeashState(holder);
        if (leashStateOpt.isEmpty()) {
            return Optional.empty();
        }
        ILeashState.LeashState leashState = leashStateOpt.get();
        Vec3 currentEntityOffset = SuperLeashStateResolver.getEntityLeashOffset(leashedEntity, leashState, partialTicks);
        Vec3 holderOffset = SuperLeashStateResolver.getHolderOffset(holder, leashState);
        if (holder instanceof Player) {
            Player player = (Player)holder;
            currentHolderPos = Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON ? SuperLeashStateResolver.getFirstPersonLeashPos(player, partialTicks) : SuperLeashStateResolver.getEntityLeashHolderPos((Entity)player, holderOffset, partialTicks);
        } else {
            currentHolderPos = holder instanceof SuperLeashKnotEntity ? SuperLeashStateResolver.getInterpolatedPosition(holder, partialTicks) : SuperLeashStateResolver.getEntityLeashHolderPos(holder, holderOffset, partialTicks);
        }
        Vec3 currentEntityPos = SuperLeashStateResolver.getInterpolatedPosition(leashedEntity, partialTicks).m_82549_(currentEntityOffset);
        FrameCache cache = frameCacheMap.get(leashedEntity.m_20148_());
        Vec3 lastHolderPos = cache != null ? cache.lastStartPos() : currentHolderPos;
        Vec3 lastEntityPos = cache != null ? cache.lastEndPos() : currentEntityPos;
        float lastAngle = cache != null ? cache.lastSwingAngle() : 0.0f;
        float lastSpeed = cache != null ? cache.lastSwingSpeed() : 0.0f;
        double distance = currentHolderPos.m_82554_(currentEntityPos);
        double maxDistance = leashInfo.maxDistance();
        double elasticDistance = leashInfo.elasticDistance();
        float tension = SuperLeashStateResolver.calculateTension(distance, maxDistance, elasticDistance);
        float stretchRatio = (float)(distance / maxDistance);
        boolean isCritical = distance > maxDistance * 1.5;
        SwingDynamics swing = SuperLeashStateResolver.calculateSwingDynamics(currentHolderPos, currentEntityPos, lastHolderPos, lastEntityPos, lastAngle, lastSpeed, tension);
        frameCacheMap.put(leashedEntity.m_20148_(), new FrameCache(currentHolderPos, currentEntityPos, swing.angle(), swing.speed()));
        return Optional.of(new SuperLeashRenderState(currentHolderPos, currentEntityPos, lastHolderPos, lastEntityPos, tension, stretchRatio, isCritical, leashInfo.keepLeashTicks(), SuperLeashStateResolver.selectColor(tension, isCritical), 0.1f + tension * 0.15f, swing.angle(), swing.speed(), (float)leashInfo.maxDistance()));
    }

    private static Vec3 getEntityLeashOffset(Entity entity, ILeashState.LeashState leashState, float partialTicks) {
        Player player;
        Optional<ILeashState> entityStateOpt = LeashStateAPI.getLeashState(entity);
        Vec3 baseOffset = entityStateOpt.map(eState -> eState.getLeashApplyEntityLocationOffset().orElse(eState.getDefaultLeashApplyEntityLocationOffset())).orElse(Vec3.f_82478_);
        baseOffset = baseOffset.m_82549_(leashState.applyEntityLocationOffset());
        float pitch = Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.f_19860_) * ((float)Math.PI / 180);
        float yaw = Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.f_19859_) * ((float)Math.PI / 180);
        float roll = 0.0f;
        if (entity instanceof Player && ((player = (Player)entity).m_21255_() || player.m_21209_())) {
            Vec3 view = player.m_20252_(partialTicks);
            Vec3 motion = player.m_20184_();
            double motionLenSq = motion.m_165925_();
            double viewLenSq = view.m_165925_();
            if (motionLenSq > 0.0 && viewLenSq > 0.0) {
                double dot = (motion.f_82479_ * view.f_82479_ + motion.f_82481_ * view.f_82481_) / Math.sqrt(motionLenSq * viewLenSq);
                double cross = motion.f_82479_ * view.f_82481_ - motion.f_82481_ * view.f_82479_;
                roll = (float)(Math.signum(cross) * Math.acos(dot));
            }
        }
        return baseOffset.m_82496_(-pitch).m_82524_(-yaw).m_82535_(-roll);
    }

    private static Vec3 getHolderOffset(Entity holder, ILeashState.LeashState leashState) {
        Optional<ILeashState> holderStateOpt;
        if (LeashStateAPI.Query.hasLeashState(holder) && (holderStateOpt = LeashStateAPI.getLeashState(holder)).isPresent()) {
            ILeashState holderState = holderStateOpt.get();
            return holderState.getLeashApplyEntityLocationOffset().orElse(holderState.getDefaultLeashApplyEntityLocationOffset());
        }
        return Optional.ofNullable(leashState.holderLocationOffset()).orElse(leashState.defaultHolderLocationOffset());
    }

    private static boolean holderHasLeashState(Entity holder) {
        if (LeashStateAPI.Query.hasLeashState(holder)) {
            Optional<ILeashState> holderStateOpt = LeashStateAPI.getLeashState(holder);
            return holderStateOpt.isPresent();
        }
        return false;
    }

    private static Vec3 getFirstPersonLeashPos(Player player, float partialTicks) {
        float yaw = Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()) * ((float)Math.PI / 180);
        float pitch = Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()) * ((float)Math.PI / 180);
        float roll = 0.0f;
        if (player.m_21255_() || player.m_21209_()) {
            Vec3 view = player.m_20252_(partialTicks);
            Vec3 motion = player.m_20184_();
            double motionLenSq = motion.m_165925_();
            double viewLenSq = view.m_165925_();
            if (motionLenSq > 0.0 && viewLenSq > 0.0) {
                double dot = (motion.f_82479_ * view.f_82479_ + motion.f_82481_ * view.f_82481_) / Math.sqrt(motionLenSq * viewLenSq);
                double cross = motion.f_82479_ * view.f_82481_ - motion.f_82481_ * view.f_82479_;
                roll = (float)(Math.signum(cross) * Math.acos(dot));
            }
        }
        double side = player.m_5737_() == HumanoidArm.RIGHT ? -1.0 : 1.0;
        Vec3 localPos = new Vec3(0.39 * side, -0.6, 0.3);
        Vec3 rotatedPos = localPos.m_82496_(-pitch).m_82524_(-yaw).m_82535_(-roll);
        return player.m_20299_(partialTicks).m_82549_(rotatedPos);
    }

    public static Vec3 getEntityLeashHolderPos(Entity entity, Vec3 baseOffset, float partialTicks) {
        Vec3 pos = entity.m_20318_(partialTicks);
        double xOffset = baseOffset.m_7096_();
        double yOffset = baseOffset.m_7098_();
        double zOffset = baseOffset.m_7094_();
        float pitch = Mth.m_14179_((float)partialTicks, (float)entity.m_146909_(), (float)entity.f_19860_) * ((float)Math.PI / 180);
        float yaw = Mth.m_14179_((float)partialTicks, (float)entity.m_146908_(), (float)entity.f_19859_) * ((float)Math.PI / 180);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            xOffset *= player.m_5737_() == HumanoidArm.RIGHT ? -1.0 : 1.0;
            if (!player.m_21255_() && !player.m_21209_()) {
                if (player.m_6067_()) {
                    pos = pos.m_82549_(new Vec3(xOffset, 0.2, -0.15).m_82496_(-pitch).m_82524_(-yaw));
                } else {
                    double yBase = player.m_20191_().m_82376_() - 1.0;
                    double yAdjust = player.m_6047_() ? -0.2 : 0.07;
                    pos = pos.m_82549_(new Vec3(xOffset, yBase, yAdjust).m_82524_(-yaw));
                }
            } else {
                Vec3 view = player.m_20252_(partialTicks);
                Vec3 motion = player.m_20184_();
                float roll = SuperLeashStateResolver.computeRoll(view, motion);
                pos = pos.m_82549_(new Vec3(xOffset, -0.11, 0.85).m_82535_(-roll).m_82496_(-pitch).m_82524_(-yaw));
            }
        } else {
            double yBase = (double)entity.m_20206_() * 0.5 + yOffset;
            pos = pos.m_82549_(new Vec3(xOffset, yBase, zOffset).m_82524_(-yaw).m_82496_(-pitch));
        }
        return pos;
    }

    private static float computeRoll(Vec3 view, Vec3 motion) {
        double d1 = motion.m_165925_();
        double d2 = view.m_165925_();
        if (d1 > 0.0 && d2 > 0.0) {
            double dot = (motion.f_82479_ * view.f_82479_ + motion.f_82481_ * view.f_82481_) / Math.sqrt(d1 * d2);
            double cross = motion.f_82479_ * view.f_82481_ - motion.f_82481_ * view.f_82479_;
            return (float)(Math.signum(cross) * Math.acos(dot));
        }
        return 0.0f;
    }

    private static Vec3 getInterpolatedPosition(Entity entity, float partialTicks) {
        return entity.m_20299_(partialTicks);
    }

    private static SwingDynamics calculateSwingDynamics(Vec3 currentStart, Vec3 currentEnd, Vec3 lastStart, Vec3 lastEnd, float lastAngle, float lastSpeed, float tension) {
        Vec3 currentDir = currentEnd.m_82546_(currentStart).m_82541_();
        Vec3 lastDir = lastEnd.m_82546_(lastStart).m_82541_();
        Vec3 cross = lastDir.m_82537_(currentDir);
        float angleChange = (float)Math.acos(Math.min(1.0, lastDir.m_82526_(currentDir)));
        angleChange = (float)((double)angleChange * Math.signum(cross.f_82480_));
        float newSpeed = lastSpeed * 0.9f + angleChange * 0.5f * tension;
        float newAngle = lastAngle + newSpeed;
        if (tension > 0.3f) {
            newSpeed = (float)((double)newSpeed + (Math.random() - 0.5) * 0.05 * (double)tension);
        }
        return new SwingDynamics(newAngle, newSpeed);
    }

    private static float calculateTension(double distance, double maxDistance, double elasticDistance) {
        if (distance <= elasticDistance) {
            return 0.0f;
        }
        double ratio = (distance - elasticDistance) / (maxDistance - elasticDistance);
        return SuperLeashStateResolver.easeOutQuad(Math.min((float)ratio, 1.5f));
    }

    private static float easeOutQuad(float x) {
        return 1.0f - (1.0f - x) * (1.0f - x);
    }

    private static int selectColor(float tension, boolean isCritical) {
        if (isCritical) {
            return -5227986;
        }
        return tension > 0.7f ? -2514842 : -9744850;
    }

    public static List<SuperLeashRenderState> resolveAll(Entity leashedEntity, LeashDataImpl leashData, float partialTicks) {
        ArrayList<SuperLeashRenderState> states = new ArrayList<SuperLeashRenderState>();
        Level level = leashedEntity.m_9236_();
        for (ILeashData.LeashInfo leashInfo : leashData.getAllLeashes()) {
            SuperLeashKnotEntity holder = null;
            if (leashInfo.blockPosOpt().isEmpty() && leashInfo.holderIdOpt().isPresent()) {
                holder = level.m_6815_(leashInfo.holderIdOpt().get().intValue());
            } else if (leashInfo.blockPosOpt().isPresent()) {
                holder = SuperLeashKnotEntity.getOrCreateKnot(level, leashInfo.blockPosOpt().get());
            }
            if (holder != null) {
                SuperLeashStateResolver.resolve((Entity)holder, leashedEntity, leashInfo, partialTicks).ifPresent(states::add);
                continue;
            }
            SuperLeadRope.logger.error("Holder not found for leash of " + String.valueOf(leashedEntity));
        }
        return states;
    }

    private record FrameCache(Vec3 lastStartPos, Vec3 lastEndPos, float lastSwingAngle, float lastSwingSpeed) {
    }

    private record SwingDynamics(float angle, float speed) {
    }
}

