/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.config;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.ForgeConfigSpec;

public class LeashCommonConfig {
    public static ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SPEC;
    public static final Common COMMON;

    static {
        BUILDER.comment("Leash Common Config");
        COMMON = new Common(BUILDER);
        SPEC = BUILDER.build();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> teleportWhitelist;
        public final ForgeConfigSpec.ConfigValue<String> SLPModCommandPrefix;
        public final ForgeConfigSpec.BooleanValue EnableSLPModCommandPrefix;
        public final ForgeConfigSpec.DoubleValue maxLeashLength;
        public final ForgeConfigSpec.DoubleValue elasticDistance;
        public final ForgeConfigSpec.DoubleValue extremeSnapFactor;
        public final ForgeConfigSpec.DoubleValue springDampening;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> axisSpecificElasticity;
        public final ForgeConfigSpec.IntValue maxLeashesPerEntity;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> defaultApplyEntityLocationOffset;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> defaultHolderLocationOffset;
        static final Pattern OFFSET_PATTERN = Pattern.compile("(?i)(?:vec3|vec3d|vector3|offset)\\s*\\(\\s*([-+]?[0-9]*\\.?[0-9]+)\\s*,\\s*([-+]?[0-9]*\\.?[0-9]+)\\s*,\\s*([-+]?[0-9]*\\.?[0-9]+)\\s*\\)\\s*:\\s*\\[\\s*([^]]+?)\\s*]\\s*");

        public Common(ForgeConfigSpec.Builder builder) {
            BUILDER.push("Command");
            this.EnableSLPModCommandPrefix = builder.comment("The prefix of this mod's commands").define("SLPModCommandPrefix", true);
            this.SLPModCommandPrefix = builder.comment(new String[]{"The prefix of this mod's commands", " [ Default:'slp'] "}).define("EnableSLPModCommandPrefix", (Object)"slp");
            BUILDER.pop();
            builder.push("Entity");
            this.teleportWhitelist = builder.comment(new String[]{"Entity teleport whitelist.", "Accepted formats:", " - #modid                 : allow teleporting to all entities from a specific mod", " - modid:entity_name      : allow teleporting to a specific entity", " - #modid:tag_name        : allow teleporting to all entities under a given entity type tag"}).defineListAllowEmpty(List.of("allowedTeleportEntities"), List.of("#minecraft", "modernlife:bicycle", "modernlife:motorboat"), o -> {
                String s;
                return o instanceof String && Common.isValidEntityRefFormat(s = (String)o);
            });
            builder.pop();
            builder.push("LeashSettings");
            this.maxLeashLength = builder.comment("Maximum leash distance (in blocks) for any entity").defineInRange("maxLeashLength", 12.0, 6.0, 256.0);
            this.elasticDistance = builder.comment("Default elastic distance for the Super Lead rope").defineInRange("elasticDistance", 6.0, 6.0, 128.0);
            this.extremeSnapFactor = builder.comment("Leash break factor = maxDistance * factor").defineInRange("extremeSnapFactor", 2.0, 1.0, 4.0);
            this.springDampening = builder.comment("Spring dampening coefficient").defineInRange("springDampening", 0.7, 0.0, 1.0);
            this.axisSpecificElasticity = builder.comment("Axis-specific elasticity coefficients for X,Y,Z axes").defineList("axisSpecificElasticity", List.of(Double.valueOf(0.8), Double.valueOf(0.2), Double.valueOf(0.8)), o -> o instanceof Double);
            this.maxLeashesPerEntity = builder.comment("Maximum number of leashes per entity").defineInRange("maxLeashesPerEntity", 6, 1, 24);
            builder.pop();
            builder.push("LeashStateSettings");
            this.defaultApplyEntityLocationOffset = builder.comment(new String[]{"Default leash attachment point offsets for entities.", "Reference point: the entity's eyeHeight (eye / head position).", "Format: vec3(x,y,z) : [entity_list]", "Optional names: vector3, vec3d, offset", "Entity list may contain:", " - modid:entity_id       : specific entity (e.g. minecraft:bee)", " - #modid:tag_name       : entity type tag (e.g. #minecraft:boats)", " - #modid                : all entities from a mod (e.g. #minecraft)", " - *                     : all entities", "Multiple entries can be separated by commas", "Example: vec3(0,0.2,0) : [minecraft:bee, minecraft:horse]", "Priority order: specific entity > tag > mod > *"}).defineListAllowEmpty(List.of("defaultApplyEntityLocationOffset"), List.of("vec3(0,-0.5,0) : [*]", "vec3(0,-0.42,0) : [minecraft:player]"), o -> {
                String s;
                return o instanceof String && Common.isValidOffsetRefFormat(s = (String)o);
            });
            this.defaultHolderLocationOffset = builder.comment(new String[]{"Default leash holder attachment point offsets (where the leash attaches to the holder).", "Reference point: the entity's eyeHeight (eye / head position).", "Format: vec3(x,y,z) : [entity_list]", "Optional names: vector3, vec3d, offset", "Entity list may contain:", " - modid:entity_id       : specific entity (e.g. minecraft:player)", " - #modid:tag_name       : entity type tag (e.g. #minecraft:players)", " - #modid                : all entities from a mod (e.g. #minecraft)", " - *                     : all entities", "Multiple entries can be separated by commas", "Example: vec3(0,1.5,0) : [minecraft:player]", "Priority order: specific entity > tag > mod > *"}).defineListAllowEmpty(List.of("defaultHolderLocationOffset"), List.of("vec3(0,-0.5,0) : [*]"), o -> {
                String s;
                return o instanceof String && Common.isValidOffsetRefFormat(s = (String)o);
            });
            BUILDER.pop();
        }

        private static boolean isValidEntityRefFormat(String s) {
            if ("*".equals(s)) {
                return true;
            }
            if (s.startsWith("#")) {
                String body = s.substring(1);
                return body.matches("[a-z0-9_]+(:[a-z0-9_/]+)?");
            }
            return s.matches("[a-z0-9_]+:[a-z0-9_/]+");
        }

        private static boolean isValidOffsetRefFormat(String s) {
            Matcher matcher = OFFSET_PATTERN.matcher(s);
            if (!matcher.matches()) {
                return false;
            }
            try {
                String[] entities;
                Double.parseDouble(matcher.group(1));
                Double.parseDouble(matcher.group(2));
                Double.parseDouble(matcher.group(3));
                String entityList = matcher.group(4);
                for (String entity : entities = entityList.split(",")) {
                    if (Common.isValidEntityRefFormat(entity.trim())) continue;
                    return false;
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

