/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.capability.impi;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.r3944realms.superleadrope.content.capability.inter.IEternalPotato;
import top.r3944realms.superleadrope.core.punishment.IObligationCompletion;
import top.r3944realms.superleadrope.core.punishment.PunishmentDefinition;
import top.r3944realms.superleadrope.core.register.SLPObligationCompletionRegistry;
import top.r3944realms.superleadrope.network.NetworkHandler;
import top.r3944realms.superleadrope.network.toClient.EternalPotatoSyncCapPacket;

public class EternalPotatoImpl
implements IEternalPotato {
    private IEternalPotato.ItemStackSync itemStackSync;
    private Player boundPlayer;
    private UUID ownerUUID;
    private volatile UUID itemUUID;
    private String ownerName;
    private boolean initializing = false;
    private boolean dirtyDuringInit = false;
    private int dailyObligations = 0;
    private int gracePeriod = 0;
    private int pendingPunishments = 0;
    private String lastReset = "";
    private String lastPunishDate = "";
    private PunishmentDefinition punishment = PunishmentDefinition.DEFAULT;
    private IObligationCompletion completionRule = IObligationCompletion.NONE;
    public static final String TAG_LAST_PUNISH_DATE = "last_punish_date";
    public static final String TAG_PENDING_PUNISHMENTS = "pending_punishments";
    public static final String TAG_GRACE_PERIOD = "grace_period";
    public static final String TAG_OWNER_UUID = "owner_uuid";
    public static final String TAG_ITEM_UUID = "item_uuid";
    public static final String TAG_OWNER_NAME = "owner_name";
    public static final String TAG_OBLIGATIONS = "obligations";
    public static final String TAG_LAST_RESET = "last_reset";
    public static final String TAG_PUNISHMENT_TYPE = "punishment_type";
    public static final String TAG_PUNISHMENT_STRENGTH = "punishment_strength";
    public static final String TAG_PUNISHMENT_AFFECT_OTHERS = "punishment_affect_others";
    public static final String TAG_COMPLETION_ID = "completion_id";

    @Override
    public void bindItemStackSync(IEternalPotato.ItemStackSync callback) {
        this.itemStackSync = callback;
    }

    @Override
    public void beginInit() {
        this.initializing = true;
        this.dirtyDuringInit = false;
    }

    @Override
    public void endInit() {
        this.initializing = false;
        if (this.dirtyDuringInit) {
            if (this.boundPlayer != null) {
                this.syncToClient(this.boundPlayer);
            }
            if (this.itemStackSync != null) {
                this.itemStackSync.markDirtyForItem();
            }
            this.dirtyDuringInit = false;
        }
    }

    @Override
    public void bindSyncContext(Player player) {
        if (this.isNetworkSyncNonRequired()) {
            return;
        }
        this.boundPlayer = player;
    }

    @Override
    public Player getBoundPlayer() {
        return this.boundPlayer;
    }

    private void markDirty() {
        if (this.initializing) {
            this.dirtyDuringInit = true;
        } else {
            if (this.boundPlayer != null) {
                this.syncToClient(this.boundPlayer);
            }
            if (this.itemStackSync != null) {
                this.itemStackSync.markDirtyForItem();
            }
        }
    }

    @Override
    public void setItemUUID(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Item UUID cannot be null");
        }
        this.itemUUID = uuid;
    }

    @Override
    public UUID getItemUUID() {
        return this.itemUUID;
    }

    @Override
    public void setOwner(UUID uuid, String name) {
        if (uuid == null) {
            throw new IllegalArgumentException("Owner UUID cannot be null");
        }
        if (name == null) {
            name = "Unknown";
        }
        this.ownerUUID = uuid;
        this.ownerName = name;
        this.markDirty();
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName != null ? this.ownerName : "Unknown";
    }

    @Override
    public void setDailyObligations(int count) {
        if (count < 0) {
            count = 0;
        }
        this.dailyObligations = count;
        this.markDirty();
    }

    @Override
    public int getDailyObligations() {
        return this.dailyObligations;
    }

    @Override
    public int getPendingPunishments() {
        return this.pendingPunishments;
    }

    @Override
    public void setPendingPunishments(int count) {
        if (count < 0) {
            count = 0;
        }
        this.pendingPunishments = count;
        this.markDirty();
    }

    @Override
    public int getGracePunishments() {
        return this.gracePeriod;
    }

    @Override
    public void setGracePunishments(int count) {
        if (count < 0) {
            count = 0;
        }
        this.gracePeriod = count;
        this.markDirty();
    }

    @Override
    public void syncToClient(Player player) {
        if (this.isNetworkSyncNonRequired() || player.m_9236_().f_46443_) {
            return;
        }
        EternalPotatoSyncCapPacket packet = new EternalPotatoSyncCapPacket(this.itemUUID, this.ownerUUID, this.ownerName, this.dailyObligations, this.pendingPunishments, this.gracePeriod, this.lastReset, this.lastPunishDate, this.punishment, this.completionRule);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayer p : server.m_6846_().m_11314_()) {
                NetworkHandler.sendToPlayer(packet, p);
            }
        }
    }

    @Override
    public void setLastReset(String date) {
        this.lastReset = date;
        this.markDirty();
    }

    @Override
    public String getLastReset() {
        return this.lastReset;
    }

    @Override
    public PunishmentDefinition getPunishment() {
        return this.punishment;
    }

    @Override
    public void setPunishment(PunishmentDefinition definition) {
        this.punishment = definition != null ? definition : PunishmentDefinition.DEFAULT;
        this.markDirty();
    }

    @Override
    public void setLastPunishDate(String date) {
        this.lastPunishDate = date;
        this.markDirty();
    }

    @Override
    public String getLastPunishDate() {
        return this.lastPunishDate;
    }

    @Override
    public IObligationCompletion getCompletionRule() {
        return this.completionRule;
    }

    @Override
    public void setCompletionRule(IObligationCompletion completion) {
        this.completionRule = completion != null ? completion : IObligationCompletion.NONE;
        this.markDirty();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.ownerUUID != null) {
            tag.m_128362_(TAG_OWNER_UUID, this.ownerUUID);
        }
        if (this.itemUUID != null) {
            tag.m_128362_(TAG_ITEM_UUID, this.itemUUID);
        }
        if (this.ownerName != null) {
            tag.m_128359_(TAG_OWNER_NAME, this.ownerName);
        }
        tag.m_128405_(TAG_OBLIGATIONS, this.dailyObligations);
        tag.m_128405_(TAG_GRACE_PERIOD, this.gracePeriod);
        if (this.lastReset != null) {
            tag.m_128359_(TAG_LAST_RESET, this.lastReset);
        }
        if (this.punishment != null && this.punishment != PunishmentDefinition.DEFAULT) {
            tag.m_128359_(TAG_PUNISHMENT_TYPE, this.punishment.type().name());
            tag.m_128350_(TAG_PUNISHMENT_STRENGTH, this.punishment.strength());
            tag.m_128379_(TAG_PUNISHMENT_AFFECT_OTHERS, this.punishment.affectOthers());
        }
        if (this.completionRule != null && this.completionRule != IObligationCompletion.NONE) {
            tag.m_128359_(TAG_COMPLETION_ID, this.completionRule.getId());
        }
        if (this.lastPunishDate != null) {
            tag.m_128359_(TAG_LAST_PUNISH_DATE, this.lastPunishDate);
        }
        tag.m_128405_(TAG_PENDING_PUNISHMENTS, this.pendingPunishments);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.m_128403_(TAG_OWNER_UUID)) {
            this.ownerUUID = nbt.m_128342_(TAG_OWNER_UUID);
        }
        if (nbt.m_128441_(TAG_ITEM_UUID)) {
            this.itemUUID = nbt.m_128342_(TAG_ITEM_UUID);
        }
        if (nbt.m_128441_(TAG_OWNER_NAME)) {
            this.ownerName = nbt.m_128461_(TAG_OWNER_NAME);
        }
        if (nbt.m_128441_(TAG_GRACE_PERIOD)) {
            this.gracePeriod = Math.max(0, nbt.m_128451_(TAG_GRACE_PERIOD));
        }
        if (nbt.m_128441_(TAG_OBLIGATIONS)) {
            this.dailyObligations = Math.max(0, nbt.m_128451_(TAG_OBLIGATIONS));
        }
        if (nbt.m_128441_(TAG_PENDING_PUNISHMENTS)) {
            this.pendingPunishments = Math.max(0, nbt.m_128451_(TAG_PENDING_PUNISHMENTS));
        }
        if (nbt.m_128441_(TAG_LAST_RESET)) {
            this.lastReset = nbt.m_128461_(TAG_LAST_RESET);
        }
        if (nbt.m_128441_(TAG_LAST_PUNISH_DATE)) {
            this.lastPunishDate = nbt.m_128461_(TAG_LAST_PUNISH_DATE);
        }
        if (nbt.m_128441_(TAG_PUNISHMENT_TYPE) && nbt.m_128441_(TAG_PUNISHMENT_STRENGTH) && nbt.m_128441_(TAG_PUNISHMENT_AFFECT_OTHERS)) {
            try {
                PunishmentDefinition.Type type = PunishmentDefinition.Type.valueOf(nbt.m_128461_(TAG_PUNISHMENT_TYPE));
                float strength = nbt.m_128457_(TAG_PUNISHMENT_STRENGTH);
                boolean affectOthers = nbt.m_128471_(TAG_PUNISHMENT_AFFECT_OTHERS);
                this.punishment = new PunishmentDefinition(type, strength, affectOthers);
            }
            catch (IllegalArgumentException e) {
                this.punishment = PunishmentDefinition.DEFAULT;
            }
        }
        if (nbt.m_128441_(TAG_COMPLETION_ID)) {
            String id = nbt.m_128461_(TAG_COMPLETION_ID);
            IObligationCompletion rule = SLPObligationCompletionRegistry.byId(id);
            this.completionRule = rule != null ? rule : IObligationCompletion.NONE;
        }
    }
}

