/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.superleadrope.content.capability.impi;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.superleadrope.CommonEventHandler;
import top.r3944realms.superleadrope.content.capability.inter.ILeashState;
import top.r3944realms.superleadrope.content.entity.SuperLeashKnotEntity;
import top.r3944realms.superleadrope.network.NetworkHandler;
import top.r3944realms.superleadrope.network.toClient.LeashStateSyncPacket;
import top.r3944realms.superleadrope.util.nbt.NBTReader;
import top.r3944realms.superleadrope.util.nbt.NBTWriter;

public class LeashStateImpl
implements ILeashState {
    private Entity entity;
    private boolean needsSync = false;
    private long lastSyncTime;
    private final Map<UUID, ILeashState.LeashState> leashHolders = new ConcurrentHashMap<UUID, ILeashState.LeashState>();
    private final Map<BlockPos, ILeashState.LeashState> leashKnots = new ConcurrentHashMap<BlockPos, ILeashState.LeashState>();
    @Nullable
    private volatile Vec3 staticApplyEntityLocationOffset;
    private volatile Vec3 defaultApplyEntityLocationOffset;

    public LeashStateImpl(Entity entity, Vec3 defaultApplyEntityLocationOffset) {
        this.entity = entity;
        this.defaultApplyEntityLocationOffset = defaultApplyEntityLocationOffset;
    }

    @Override
    public void markForSync() {
        if (!this.entity.m_9236_().f_46443_) {
            this.needsSync = true;
            this.immediateSync();
        }
    }

    @Override
    public void immediateSync() {
        this.syncNow();
    }

    @Override
    public void checkSync() {
        if (!this.needsSync || this.entity.m_9236_().f_46443_) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSyncTime > 2000L) {
            this.syncNow();
        }
    }

    private void syncNow() {
        CompoundTag currentData = this.serializeNBT();
        NetworkHandler.sendToPlayer(new LeashStateSyncPacket(this.entity.m_19879_(), currentData), this.entity, PacketDistributor.TRACKING_ENTITY_AND_SELF);
        this.lastSyncTime = System.currentTimeMillis();
        this.needsSync = false;
    }

    @Override
    public boolean hasLeashState() {
        return !this.leashKnots.isEmpty() || !this.leashHolders.isEmpty();
    }

    @Override
    public Map<UUID, ILeashState.LeashState> getHolderLeashStates() {
        ConcurrentMap retMap = Maps.newConcurrentMap();
        retMap.putAll(this.leashHolders);
        return retMap;
    }

    @Override
    public Map<BlockPos, ILeashState.LeashState> getKnotLeashStates() {
        ConcurrentMap retMap = Maps.newConcurrentMap();
        retMap.putAll(this.leashKnots);
        return retMap;
    }

    @Override
    public Optional<ILeashState.LeashState> getLeashState(Entity holder) {
        Optional<ILeashState.LeashState> optional;
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity leashKnot = (SuperLeashKnotEntity)holder;
            optional = this.getLeashState(leashKnot.m_31748_());
        } else {
            optional = this.getLeashState(holder.m_20148_());
        }
        return optional;
    }

    @Override
    public Optional<ILeashState.LeashState> getLeashState(UUID uuid) {
        return this.leashHolders.containsKey(uuid) ? Optional.of(this.leashHolders.get(uuid)) : Optional.empty();
    }

    @Override
    public Optional<ILeashState.LeashState> getLeashState(BlockPos pos) {
        return this.leashKnots.containsKey(pos) ? Optional.of(this.leashKnots.get(pos)) : Optional.empty();
    }

    @Override
    public Optional<Vec3> getHolderLocationOffset(Entity entity) {
        Optional<Vec3> optional;
        if (entity instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity leashKnot = (SuperLeashKnotEntity)entity;
            optional = this.getHolderLocationOffset(leashKnot.m_31748_());
        } else {
            optional = this.getHolderLocationOffset(entity.m_20148_());
        }
        return optional;
    }

    @Override
    public Optional<Vec3> getHolderLocationOffset(UUID uuid) {
        return Optional.ofNullable(this.leashHolders.get(uuid)).map(ILeashState.LeashState::holderLocationOffset);
    }

    @Override
    public Optional<Vec3> getHolderLocationOffset(BlockPos pos) {
        return Optional.ofNullable(this.leashKnots.get(pos)).map(ILeashState.LeashState::holderLocationOffset);
    }

    @Override
    public Vec3 getDefaultLeashApplyEntityLocationOffset() {
        return this.defaultApplyEntityLocationOffset;
    }

    @Override
    public Optional<Vec3> getLeashApplyEntityLocationOffset() {
        return Optional.ofNullable(this.staticApplyEntityLocationOffset);
    }

    @Override
    public void resetLeashHolderLocationOffset(Entity holder) {
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity leashKnot = (SuperLeashKnotEntity)holder;
            this.resetLeashHolderLocationOffset(leashKnot.m_31748_());
        } else {
            this.resetLeashHolderLocationOffset(holder.m_20148_());
        }
    }

    @Override
    public void resetLeashHolderLocationOffset(UUID holderUUID) {
        this.leashHolders.computeIfPresent(holderUUID, (uuid, state) -> state.resetHolderLocationOffset());
        this.markForSync();
    }

    @Override
    public void resetLeashHolderLocationOffset(BlockPos knotPos) {
        this.leashKnots.computeIfPresent(knotPos, (blockPos, state) -> state.resetHolderLocationOffset());
        this.markForSync();
    }

    @Override
    public void setLeashHolderLocationOffset(Entity holder, @Nullable Vec3 offset) {
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity leashKnot = (SuperLeashKnotEntity)holder;
            this.setLeashHolderLocationOffset(leashKnot.m_31748_(), offset);
        } else {
            this.setLeashHolderLocationOffset(holder.m_20148_(), offset);
        }
    }

    @Override
    public void setLeashHolderLocationOffset(UUID holderUUID, Vec3 offset) {
        Level level = this.entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ILeashState.LeashState currentState = this.leashHolders.get(holderUUID);
            if (currentState == null) {
                Entity holder = level2.m_8791_(holderUUID);
                Vec3 defaultHolderLocationOffset = Vec3.f_82478_;
                if (holder != null) {
                    defaultHolderLocationOffset = CommonEventHandler.leashConfigManager.getDefaultHolderOffset(holder);
                }
                this.leashHolders.put(holderUUID, new ILeashState.LeashState(offset, Vec3.f_82478_, defaultHolderLocationOffset));
            } else {
                this.leashHolders.put(holderUUID, currentState.setHolderLocationOffset(offset));
            }
            this.markForSync();
        }
    }

    @Override
    public void setLeashHolderLocationOffset(BlockPos knotPos, Vec3 offset) {
        Level level = this.entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ILeashState.LeashState currentState = this.leashKnots.get(knotPos);
            if (currentState == null) {
                this.leashKnots.put(knotPos, new ILeashState.LeashState(offset, Vec3.f_82478_, SuperLeashKnotEntity.get((Level)level2, knotPos).map(CommonEventHandler.leashConfigManager::getDefaultHolderOffset).orElse(Vec3.f_82478_)));
            } else {
                this.leashKnots.put(knotPos, currentState.setHolderLocationOffset(offset));
            }
            this.markForSync();
        }
    }

    @Override
    public void addLeashHolderLocationOffset(Entity holder, Vec3 offset) {
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity leashKnot = (SuperLeashKnotEntity)holder;
            this.addLeashHolderLocationOffset(leashKnot.m_31748_(), offset);
        } else {
            this.addLeashHolderLocationOffset(holder.m_20148_(), offset);
        }
    }

    @Override
    public void addLeashHolderLocationOffset(UUID holderUUID, Vec3 offset) {
        ILeashState.LeashState currentState = this.leashHolders.get(holderUUID);
        if (currentState != null) {
            Vec3 newHolderLocationOffset = currentState.holderLocationOffset() == null ? currentState.defaultHolderLocationOffset().m_82549_(offset) : currentState.holderLocationOffset().m_82549_(offset);
            this.leashHolders.put(holderUUID, currentState.setHolderLocationOffset(newHolderLocationOffset));
        }
        this.markForSync();
    }

    @Override
    public void addLeashHolderLocationOffset(BlockPos knotPos, Vec3 offset) {
        ILeashState.LeashState currentState = this.leashKnots.get(knotPos);
        if (currentState != null) {
            Vec3 newHolderLocationOffset = currentState.holderLocationOffset() == null ? currentState.defaultHolderLocationOffset().m_82549_(offset) : currentState.holderLocationOffset().m_82549_(offset);
            this.leashKnots.put(knotPos, currentState.setHolderLocationOffset(newHolderLocationOffset));
        }
        this.markForSync();
    }

    @Override
    public void removeLeashHolderLocationOffset(Entity holder) {
        if (holder instanceof SuperLeashKnotEntity) {
            SuperLeashKnotEntity leashKnot = (SuperLeashKnotEntity)holder;
            this.removeLeashHolderLocationOffset(leashKnot.m_31748_());
        } else {
            this.removeLeashHolderLocationOffset(holder.m_20148_());
        }
    }

    @Override
    public void removeLeashHolderLocationOffset(UUID holderUUID) {
        this.leashHolders.remove(holderUUID);
        this.markForSync();
    }

    @Override
    public void removeLeashHolderLocationOffset(BlockPos knotPos) {
        this.leashKnots.remove(knotPos);
        this.markForSync();
    }

    @Override
    public void removeAllLeashHolderLocationOffset() {
        this.leashKnots.clear();
        this.leashHolders.clear();
        this.markForSync();
    }

    @Override
    public void removeAllLeashHolderUUIDLocationOffset() {
        this.leashHolders.clear();
        this.markForSync();
    }

    @Override
    public void removeAllLeashHolderBlockPosLocationOffset() {
        this.leashKnots.clear();
        this.markForSync();
    }

    @Override
    public void resetAllLeashHolderLocationsOffset() {
        this.leashKnots.replaceAll((pos, leashState) -> leashState.resetHolderLocationOffset());
        this.leashHolders.replaceAll((uuid, leashState) -> leashState.resetHolderLocationOffset());
        this.markForSync();
    }

    @Override
    public void resetAllLeashApplyEntityLocationsOffset() {
        this.leashKnots.replaceAll((pos, leashState) -> leashState.setApplyEntityLocationOffset(this.defaultApplyEntityLocationOffset));
        this.leashHolders.replaceAll((uuid, leashState) -> leashState.setApplyEntityLocationOffset(this.defaultApplyEntityLocationOffset));
        this.markForSync();
    }

    @Override
    public void removeLeashApplyEntityLocationOffset() {
        this.staticApplyEntityLocationOffset = null;
        this.markForSync();
    }

    @Override
    public void setLeashApplyEntityLocationOffset(Vec3 leashHolderLocationOffset) {
        this.staticApplyEntityLocationOffset = leashHolderLocationOffset;
        this.markForSync();
    }

    @Override
    public void addLeashApplyEntityLocationOffset(Vec3 offset) {
        Optional.ofNullable(this.staticApplyEntityLocationOffset).ifPresentOrElse(vec3 -> vec3.m_82549_(offset), () -> {
            this.staticApplyEntityLocationOffset = offset;
        });
        this.markForSync();
    }

    @Override
    public void copy(ILeashState other, Entity newEntity) {
        this.entity = newEntity;
        this.defaultApplyEntityLocationOffset = other.getDefaultLeashApplyEntityLocationOffset();
        this.staticApplyEntityLocationOffset = other.getLeashApplyEntityLocationOffset().orElse(null);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag holdersList = new ListTag();
        this.leashHolders.forEach((uuid, state) -> {
            CompoundTag infoTag = LeashStateImpl.generateCompoundTagFromUUIDLeashInfo(uuid, state);
            holdersList.add((Object)infoTag);
        });
        this.leashKnots.forEach((blockPos, state) -> {
            CompoundTag infoTag = LeashStateImpl.generateCompoundTagFromBlockPosLeashState(blockPos, state);
            holdersList.add((Object)infoTag);
        });
        tag.m_128365_("LeashHolders", (Tag)holdersList);
        if (this.staticApplyEntityLocationOffset != null) {
            tag.m_128365_("StaticApplyEntityLocationOffset", (Tag)NBTWriter.writeVec3(this.staticApplyEntityLocationOffset));
        }
        tag.m_128365_("DefaultApplyEntityLocationOffset", (Tag)NBTWriter.writeVec3(this.defaultApplyEntityLocationOffset));
        return tag;
    }

    @NotNull
    private static CompoundTag generateCompoundTagFromUUIDLeashInfo(@NotNull UUID uuid, @NotNull ILeashState.LeashState info) {
        CompoundTag infoTag = new CompoundTag();
        infoTag.m_128362_("HolderUUID", uuid);
        return LeashStateImpl.getCommonCompoundTag(info, infoTag);
    }

    @NotNull
    private static CompoundTag generateCompoundTagFromBlockPosLeashState(@NotNull BlockPos blockpos, @NotNull ILeashState.LeashState info) {
        CompoundTag infoTag = new CompoundTag();
        infoTag.m_128365_("KnotBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)blockpos));
        return LeashStateImpl.getCommonCompoundTag(info, infoTag);
    }

    @NotNull
    private static CompoundTag getCommonCompoundTag(@NotNull ILeashState.LeashState info, CompoundTag infoTag) {
        infoTag.m_128365_("ApplyEntityLocationOffset", (Tag)NBTWriter.writeVec3(info.applyEntityLocationOffset()));
        if (info.holderLocationOffset() != null) {
            infoTag.m_128365_("HolderEntityLocationOffset", (Tag)NBTWriter.writeVec3(info.holderLocationOffset()));
        }
        infoTag.m_128365_("DefaultHolderLocationOffset", (Tag)NBTWriter.writeVec3(info.defaultHolderLocationOffset()));
        return infoTag;
    }

    public void deserializeNBT(@NotNull CompoundTag nbt) {
        this.leashHolders.clear();
        this.leashKnots.clear();
        if (nbt.m_128425_("LeashHolders", 9)) {
            ListTag holdersList = nbt.m_128437_("LeashHolders", 10);
            if (nbt.m_128441_("StaticApplyEntityLocationOffset")) {
                this.staticApplyEntityLocationOffset = NBTReader.readVec3(nbt.m_128469_("StaticApplyEntityLocationOffset"));
            }
            if (!nbt.m_128441_("DefaultApplyEntityLocationOffset")) {
                throw new IllegalArgumentException("Nbt Lost DefaultApplyEntityLocationOffset Value");
            }
            this.defaultApplyEntityLocationOffset = NBTReader.readVec3(nbt.m_128469_("DefaultApplyEntityLocationOffset"));
            for (int i = 0; i < holdersList.size(); ++i) {
                CompoundTag infoTag = holdersList.m_128728_(i);
                if (infoTag.m_128441_("HolderUUID")) {
                    ILeashState.LeashState uuidLeashDataFormListTag = LeashStateImpl.getUUIDLeashStateForm(infoTag);
                    this.leashHolders.put(infoTag.m_128342_("HolderUUID"), uuidLeashDataFormListTag);
                    continue;
                }
                ILeashState.LeashState blockPosLeashDataFormListTag = LeashStateImpl.getUUIDLeashStateForm(infoTag);
                this.leashKnots.put(NbtUtils.m_129239_((CompoundTag)infoTag.m_128469_("KnotBlockPos")), blockPosLeashDataFormListTag);
            }
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    private static ILeashState.LeashState getUUIDLeashStateForm(@NotNull CompoundTag infoTag) {
        return new ILeashState.LeashState(infoTag.m_128441_("HolderEntityLocationOffset") ? NBTReader.readVec3(infoTag.m_128469_("HolderEntityLocationOffset")) : null, NBTReader.readVec3(infoTag.m_128469_("ApplyEntityLocationOffset")), NBTReader.readVec3(infoTag.m_128469_("DefaultHolderLocationOffset")));
    }
}

